/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.utils;

import jadx.core.dex.nodes.ClassNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFromDuplicates {
    private static final Logger LOG = LoggerFactory.getLogger(SelectFromDuplicates.class);
    private static final Pattern CLASSES_DEX_PATTERN = Pattern.compile("classes([1-9]\\d*)\\.dex");

    public static ClassNode process(List<ClassNode> dupClsList) {
        ClassNode bestCls = null;
        int bestClsIndex = -1;
        for (ClassNode clsNode : dupClsList) {
            boolean selectCurrent = false;
            if (bestCls == null) {
                selectCurrent = true;
            } else {
                int clsIndex = SelectFromDuplicates.getClassesIndex(clsNode.getInputFileName());
                if (clsIndex != -1) {
                    if (bestClsIndex != -1) {
                        if (clsIndex < bestClsIndex) {
                            selectCurrent = true;
                        }
                    } else {
                        selectCurrent = true;
                    }
                }
            }
            if (!selectCurrent) continue;
            bestCls = clsNode;
            bestClsIndex = SelectFromDuplicates.getClassesIndex(clsNode.getInputFileName());
        }
        return bestCls;
    }

    private static int getClassesIndex(String source) {
        if ("classes.dex".equals(source)) {
            return 1;
        }
        try {
            Matcher matcher = CLASSES_DEX_PATTERN.matcher(source);
            if (!matcher.matches()) {
                return -1;
            }
            String num = matcher.group(1);
            if (num.equals("1")) {
                return -1;
            }
            return Integer.parseInt(num);
        }
        catch (Exception e) {
            LOG.debug("Failed to parse source classes index", (Throwable)e);
            return -1;
        }
    }
}

