/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class InsnNode
extends LineAttrNode {
    protected final InsnType insnType;
    private RegisterArg result;
    private final List<InsnArg> arguments;
    protected int offset;

    public InsnNode(InsnType type, int argsCount) {
        this(type, argsCount == 0 ? Collections.emptyList() : new ArrayList(argsCount));
    }

    public InsnNode(InsnType type, List<InsnArg> args) {
        this.insnType = type;
        this.arguments = args;
        this.offset = -1;
        for (InsnArg arg : args) {
            this.attachArg(arg);
        }
    }

    public static InsnNode wrapArg(InsnArg arg) {
        InsnNode insn = new InsnNode(InsnType.ONE_ARG, 1);
        insn.addArg(arg);
        return insn;
    }

    public void setResult(@Nullable RegisterArg res) {
        this.result = res;
        if (res != null) {
            res.setParentInsn(this);
            SSAVar ssaVar = res.getSVar();
            if (ssaVar != null) {
                ssaVar.setAssign(res);
            }
        }
    }

    public void addArg(InsnArg arg) {
        this.arguments.add(arg);
        this.attachArg(arg);
    }

    public void setArg(int n, InsnArg arg) {
        this.arguments.set(n, arg);
        this.attachArg(arg);
    }

    protected void attachArg(InsnArg arg) {
        RegisterArg reg;
        SSAVar ssaVar;
        arg.setParentInsn(this);
        if (arg.isRegister() && (ssaVar = (reg = (RegisterArg)arg).getSVar()) != null) {
            ssaVar.use(reg);
        }
    }

    public InsnType getType() {
        return this.insnType;
    }

    public RegisterArg getResult() {
        return this.result;
    }

    public Iterable<InsnArg> getArguments() {
        return this.arguments;
    }

    public List<InsnArg> getArgList() {
        return this.arguments;
    }

    public int getArgsCount() {
        return this.arguments.size();
    }

    public InsnArg getArg(int n) {
        return this.arguments.get(n);
    }

    public boolean containsArg(InsnArg arg) {
        if (this.getArgsCount() == 0) {
            return false;
        }
        for (InsnArg a : this.arguments) {
            if (a != arg) continue;
            return true;
        }
        return false;
    }

    public boolean containsVar(RegisterArg arg) {
        if (this.getArgsCount() == 0) {
            return false;
        }
        return InsnUtils.containsVar(this.arguments, arg);
    }

    public boolean replaceArg(InsnArg from, InsnArg to) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            InsnArg arg = this.arguments.get(i);
            if (arg == from) {
                InsnRemover.unbindArgUsage(null, arg);
                this.setArg(i, to);
                return true;
            }
            if (!arg.isInsnWrap() || !((InsnWrapArg)arg).getWrapInsn().replaceArg(from, to)) continue;
            return true;
        }
        return false;
    }

    protected boolean removeArg(InsnArg arg) {
        int index = this.getArgIndex(arg);
        if (index == -1) {
            return false;
        }
        this.removeArg(index);
        return true;
    }

    public InsnArg removeArg(int index) {
        InsnArg arg = this.arguments.get(index);
        this.arguments.remove(index);
        InsnRemover.unbindArgUsage(null, arg);
        return arg;
    }

    public int getArgIndex(InsnArg arg) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            if (arg != this.arguments.get(i)) continue;
            return i;
        }
        return -1;
    }

    protected void addReg(InsnData insn, int i, ArgType type) {
        this.addArg(InsnArg.reg(insn, i, type));
    }

    protected void addReg(int regNum, ArgType type) {
        this.addArg(InsnArg.reg(regNum, type));
    }

    protected void addLit(long literal, ArgType type) {
        this.addArg(InsnArg.lit(literal, type));
    }

    protected void addLit(InsnData insn, ArgType type) {
        this.addArg(InsnArg.lit(insn, type));
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void getRegisterArgs(Collection<RegisterArg> collection) {
        for (InsnArg arg : this.getArguments()) {
            if (arg.isRegister()) {
                collection.add((RegisterArg)arg);
                continue;
            }
            if (!arg.isInsnWrap()) continue;
            ((InsnWrapArg)arg).getWrapInsn().getRegisterArgs(collection);
        }
    }

    public boolean isConstInsn() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: {
                return true;
            }
        }
        return false;
    }

    public boolean isExitEdgeInsn() {
        switch (this.getType()) {
            case RETURN: 
            case THROW: 
            case CONTINUE: 
            case BREAK: {
                return true;
            }
        }
        return false;
    }

    public boolean canRemoveResult() {
        switch (this.getType()) {
            case INVOKE: 
            case CONSTRUCTOR: {
                return true;
            }
        }
        return false;
    }

    public boolean canReorder() {
        if (this.contains(AFlag.DONT_GENERATE)) {
            return this.getType() != InsnType.MONITOR_EXIT;
        }
        for (InsnArg arg : this.getArguments()) {
            InsnNode wrapInsn;
            if (!arg.isInsnWrap() || (wrapInsn = ((InsnWrapArg)arg).getWrapInsn()).canReorder()) continue;
            return false;
        }
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: 
            case CAST: 
            case MOVE: 
            case ARITH: 
            case NEG: 
            case CMP_L: 
            case CMP_G: 
            case CHECK_CAST: 
            case INSTANCE_OF: 
            case FILL_ARRAY: 
            case FILLED_NEW_ARRAY: 
            case NEW_ARRAY: 
            case STR_CONCAT: {
                return true;
            }
            case SGET: 
            case IGET: {
                return false;
            }
        }
        return false;
    }

    public boolean containsWrappedInsn() {
        for (InsnArg arg : this.getArguments()) {
            if (!arg.isInsnWrap()) continue;
            return true;
        }
        return false;
    }

    public void visitInsns(Consumer<InsnNode> visitor) {
        visitor.accept(this);
        for (InsnArg arg : this.getArguments()) {
            if (!arg.isInsnWrap()) continue;
            ((InsnWrapArg)arg).getWrapInsn().visitInsns(visitor);
        }
    }

    @Nullable
    public <R> R visitInsns(Function<InsnNode, R> visitor) {
        R result = visitor.apply(this);
        if (result != null) {
            return result;
        }
        for (InsnArg arg : this.getArguments()) {
            InsnNode innerInsn;
            R res;
            if (!arg.isInsnWrap() || (res = (innerInsn = ((InsnWrapArg)arg).getWrapInsn()).visitInsns(visitor)) == null) continue;
            return res;
        }
        return null;
    }

    public void visitArgs(Consumer<InsnArg> visitor) {
        for (InsnArg arg : this.getArguments()) {
            if (arg.isInsnWrap()) {
                ((InsnWrapArg)arg).getWrapInsn().visitArgs(visitor);
                continue;
            }
            visitor.accept(arg);
        }
    }

    @Nullable
    public <R> R visitArgs(Function<InsnArg, R> visitor) {
        for (InsnArg arg : this.getArguments()) {
            R result;
            if (arg.isInsnWrap()) {
                InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                result = wrapInsn.visitArgs(visitor);
            } else {
                result = visitor.apply(arg);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isSame(InsnNode other) {
        if (this == other) {
            return true;
        }
        if (this.insnType != other.insnType) {
            return false;
        }
        int size = this.arguments.size();
        if (size != other.arguments.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            InsnNode otherWrapInsn;
            InsnArg arg = this.arguments.get(i);
            InsnArg otherArg = other.arguments.get(i);
            if (!arg.isInsnWrap()) continue;
            if (!otherArg.isInsnWrap()) {
                return false;
            }
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (wrapInsn.isSame(otherWrapInsn = ((InsnWrapArg)otherArg).getWrapInsn())) continue;
            return false;
        }
        return true;
    }

    public boolean isDeepEquals(InsnNode other) {
        if (this == other) {
            return true;
        }
        return this.isSame(other) && Objects.equals(this.result, other.result) && Objects.equals(this.arguments, other.arguments);
    }

    protected final <T extends InsnNode> T copyCommonParams(T copy) {
        if (copy.getArgsCount() == 0) {
            for (InsnArg arg : this.getArguments()) {
                copy.addArg(arg.duplicate());
            }
        }
        copy.copyAttributesFrom(this);
        copy.copyLines(this);
        copy.setOffset(this.getOffset());
        return copy;
    }

    public void copyAttributesFrom(InsnNode attrNode) {
        super.copyAttributesFrom(attrNode);
        this.addSourceLineFrom(attrNode);
    }

    public InsnNode copy() {
        if (this.getClass() != InsnNode.class) {
            throw new JadxRuntimeException("Copy method not implemented in insn class " + this.getClass().getSimpleName());
        }
        return this.copyCommonParams(new InsnNode(this.insnType, this.getArgsCount()));
    }

    public <T extends InsnNode> T copyWithoutResult() {
        return (T)this.copy();
    }

    public InsnNode copyWithoutSsa() {
        Object copy = this.copyWithoutResult();
        if (this.result != null) {
            if (this.result.getSVar() == null) {
                ((InsnNode)copy).setResult(this.result.duplicate());
            } else {
                throw new JadxRuntimeException("Can't copy if SSA var is set");
            }
        }
        return copy;
    }

    public InsnNode copy(RegisterArg newReturnArg) {
        InsnNode copy = this.copy();
        copy.setResult(newReturnArg);
        return copy;
    }

    public InsnNode copyWithNewSsaVar(MethodNode mth) {
        RegisterArg result = this.getResult();
        if (result == null) {
            throw new JadxRuntimeException("Result in null");
        }
        int regNum = result.getRegNum();
        RegisterArg resDupArg = result.duplicate(regNum, null);
        mth.makeNewSVar(resDupArg);
        return this.copy(resDupArg);
    }

    public void rebindArgs() {
        RegisterArg resArg = this.getResult();
        if (resArg != null) {
            SSAVar ssaVar = resArg.getSVar();
            if (ssaVar == null) {
                throw new JadxRuntimeException("No SSA var for result arg: " + String.valueOf(resArg) + " from " + String.valueOf(resArg.getParentInsn()));
            }
            ssaVar.setAssign(resArg);
        }
        for (InsnArg arg : this.getArguments()) {
            if (arg instanceof RegisterArg) {
                RegisterArg reg = (RegisterArg)arg;
                SSAVar ssaVar = reg.getSVar();
                ssaVar.use(reg);
                ssaVar.updateUsedInPhiList();
                continue;
            }
            if (!(arg instanceof InsnWrapArg)) continue;
            ((InsnWrapArg)arg).getWrapInsn().rebindArgs();
        }
    }

    public boolean canThrowException() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: 
            case RETURN: 
            case MOVE: 
            case NEG: 
            case CMP_L: 
            case CMP_G: 
            case IF: 
            case GOTO: 
            case MOVE_EXCEPTION: 
            case NOP: {
                return false;
            }
        }
        return true;
    }

    public void inheritMetadata(InsnNode sourceInsn) {
        if (this.insnType == InsnType.RETURN) {
            this.copyLines(sourceInsn);
            if (this.contains(AFlag.SYNTHETIC)) {
                this.setOffset(sourceInsn.getOffset());
                this.rewriteAttributeFrom(sourceInsn, AType.CODE_COMMENTS);
            } else {
                this.copyAttributeFrom(sourceInsn, AType.CODE_COMMENTS);
            }
        } else {
            this.copyAttributeFrom(sourceInsn, AType.CODE_COMMENTS);
            this.addSourceLineFrom(sourceInsn);
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected boolean appendArgs(StringBuilder sb) {
        if (this.arguments.isEmpty()) {
            return false;
        }
        String argsStr = Utils.listToString(this.arguments);
        if (argsStr.length() < 120) {
            sb.append(argsStr);
            return false;
        }
        String separator = "\n  ";
        sb.append(separator).append(Utils.listToString(this.arguments, separator));
        sb.append('\n');
        return true;
    }

    protected String attributesString() {
        StringBuilder sb = new StringBuilder();
        this.appendAttributes(sb);
        return sb.toString();
    }

    protected void appendAttributes(StringBuilder sb) {
        if (!this.isAttrStorageEmpty()) {
            sb.append(' ').append(this.getAttributesString());
        }
        if (this.getSourceLine() != 0) {
            sb.append(" (LINE:").append(this.getSourceLine()).append(')');
        }
    }

    protected String baseString() {
        StringBuilder sb = new StringBuilder();
        if (this.offset != -1) {
            sb.append(InsnUtils.formatOffset(this.offset)).append(": ");
        }
        sb.append((Object)this.insnType).append(' ');
        if (this.result != null) {
            sb.append(this.result).append(" = ");
        }
        this.appendArgs(sb);
        return sb.toString();
    }

    public String toString() {
        return this.baseString() + this.attributesString();
    }
}

