/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.DecompilationMode;
import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.impl.SimpleCodeWriter;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.api.metadata.annotations.VarRef;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.ISeqConsumer;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultAttr;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultClassAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClassesAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClsInfo;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.api.plugins.input.data.impl.ListConsumer;
import jadx.api.usage.IUsageInfoData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.InlinedAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.IPackageUpdate;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNode
extends NotificationAttrNode
implements ILoadable,
ICodeNode,
IPackageUpdate,
Comparable<ClassNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNode.class);
    private final RootNode root;
    private final IClassData clsData;
    private final ClassInfo clsInfo;
    private PackageNode packageNode;
    private AccessInfo accessFlags;
    private ArgType superClass;
    private List<ArgType> interfaces;
    private List<ArgType> generics = Collections.emptyList();
    private String inputFileName;
    private List<MethodNode> methods;
    private List<FieldNode> fields;
    private List<ClassNode> innerClasses = Collections.emptyList();
    private List<ClassNode> inlinedClasses = Collections.emptyList();
    private String smali;
    private ClassNode parentClass = this;
    private volatile ProcessState state = ProcessState.NOT_LOADED;
    private LoadStage loadStage = LoadStage.NONE;
    private List<ClassNode> dependencies = Collections.emptyList();
    private List<ClassNode> codegenDeps = Collections.emptyList();
    private List<ClassNode> useIn = Collections.emptyList();
    private List<MethodNode> useInMth = Collections.emptyList();
    private Map<MethodInfo, MethodNode> mthInfoMap = Collections.emptyMap();
    private JavaClass javaNode;
    private static final Object DECOMPILE_WITH_MODE_SYNC = new Object();

    public ClassNode(RootNode root, IClassData cls) {
        this.root = root;
        this.clsInfo = ClassInfo.fromType(root, ArgType.object(cls.getType()));
        this.packageNode = PackageNode.getForClass(root, this.clsInfo.getPackage(), this);
        this.clsData = cls.copy();
        this.load(this.clsData, false);
    }

    private void load(IClassData cls, boolean reloading) {
        try {
            this.addAttrs(cls.getAttributes());
            this.accessFlags = new AccessInfo(this.getAccessFlags(cls), AccessInfo.AFType.CLASS);
            this.superClass = this.checkSuperType(cls);
            this.interfaces = Utils.collectionMap(cls.getInterfacesTypes(), ArgType::object);
            this.setInputFileName(cls.getInputFileName());
            ListConsumer fieldsConsumer = new ListConsumer(fld -> FieldNode.build(this, fld));
            ListConsumer methodsConsumer = new ListConsumer(mth -> MethodNode.build(this, mth));
            cls.visitFieldsAndMethods((ISeqConsumer)fieldsConsumer, (ISeqConsumer)methodsConsumer);
            this.fields = fieldsConsumer.getResult();
            this.methods = methodsConsumer.getResult();
            if (reloading) {
                this.restoreUsageData();
            }
            this.initStaticValues(this.fields);
            ClassNode.processAttributes(this);
            ClassNode.processSpecialClasses(this);
            this.buildCache();
            if (this.accessFlags.isModuleInfo()) {
                this.addWarnComment("Modules not supported yet");
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error decode class: " + String.valueOf(this.clsInfo), e);
        }
    }

    private void restoreUsageData() {
        IUsageInfoData usageInfoData = this.root.getArgs().getUsageInfoCache().get(this.root);
        if (usageInfoData != null) {
            usageInfoData.applyForClass(this);
        } else {
            LOG.warn("Can't restore usage data for class: {}", (Object)this);
        }
    }

    private ArgType checkSuperType(IClassData cls) {
        String superType = cls.getSuperType();
        if (superType == null) {
            if (this.clsInfo.getType().getObject().equals("java.lang.Object")) {
                return null;
            }
            if (this.accessFlags.isModuleInfo()) {
                return null;
            }
            throw new JadxRuntimeException("No super class in " + String.valueOf(this.clsInfo.getType()));
        }
        return ArgType.object(superType);
    }

    public void updateGenericClsData(List<ArgType> generics, ArgType superClass, List<ArgType> interfaces) {
        this.generics = generics;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    private static void processSpecialClasses(ClassNode cls) {
        if (cls.getName().equals("package-info") && cls.getFields().isEmpty() && cls.getMethods().isEmpty()) {
            cls.add(AFlag.PACKAGE_INFO);
            cls.add(AFlag.DONT_RENAME);
        }
    }

    private static void processAttributes(ClassNode cls) {
        AnnotationDefaultClassAttr defAttr = (AnnotationDefaultClassAttr)cls.get(JadxAttrType.ANNOTATION_DEFAULT_CLASS);
        if (defAttr != null) {
            cls.remove(JadxAttrType.ANNOTATION_DEFAULT_CLASS);
            for (Map.Entry entry : defAttr.getValues().entrySet()) {
                MethodNode mth = cls.searchMethodByShortName((String)entry.getKey());
                if (mth != null) {
                    mth.addAttr((IJadxAttribute)new AnnotationDefaultAttr((EncodedValue)entry.getValue()));
                    continue;
                }
                cls.addWarnComment("Method from annotation default annotation not found: " + (String)entry.getKey());
            }
        }
        if (!cls.checkSourceFilenameAttr()) {
            cls.remove(JadxAttrType.SOURCE_FILE);
        }
    }

    private int getAccessFlags(IClassData cls) {
        InnerClsInfo innerClsInfo;
        InnerClassesAttr innerClassesAttr = (InnerClassesAttr)this.get(JadxAttrType.INNER_CLASSES);
        if (innerClassesAttr != null && (innerClsInfo = (InnerClsInfo)innerClassesAttr.getMap().get(cls.getType())) != null) {
            return innerClsInfo.getAccessFlags();
        }
        return cls.getAccessFlags();
    }

    public static ClassNode addSyntheticClass(RootNode root, String name, int accessFlags) {
        ClassInfo clsInfo = ClassInfo.fromName(root, name);
        ClassNode existCls = root.resolveClass(clsInfo);
        if (existCls != null) {
            throw new JadxRuntimeException("Class already exist: " + name);
        }
        return ClassNode.addSyntheticClass(root, clsInfo, accessFlags);
    }

    public static ClassNode addSyntheticClass(RootNode root, ClassInfo clsInfo, int accessFlags) {
        ClassNode cls = new ClassNode(root, clsInfo, accessFlags);
        cls.add(AFlag.SYNTHETIC);
        cls.setInputFileName("synthetic");
        cls.setState(ProcessState.PROCESS_COMPLETE);
        root.addClassNode(cls);
        return cls;
    }

    private ClassNode(RootNode root, ClassInfo clsInfo, int accessFlags) {
        this.root = root;
        this.clsData = null;
        this.clsInfo = clsInfo;
        this.interfaces = new ArrayList<ArgType>();
        this.methods = new ArrayList<MethodNode>();
        this.fields = new ArrayList<FieldNode>();
        this.accessFlags = new AccessInfo(accessFlags, AccessInfo.AFType.CLASS);
        this.packageNode = PackageNode.getForClass(root, clsInfo.getPackage(), this);
    }

    private void initStaticValues(List<FieldNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        for (FieldNode fld : fields) {
            AccessInfo accFlags = fld.getAccessFlags();
            if (!accFlags.isStatic() || !accFlags.isFinal() || fld.get(JadxAttrType.CONSTANT_VALUE) != null) continue;
            fld.addAttr((IJadxAttribute)EncodedValue.NULL);
        }
    }

    private boolean checkSourceFilenameAttr() {
        SourceFileAttr sourceFileAttr = (SourceFileAttr)this.get(JadxAttrType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return true;
        }
        String fileName = sourceFileAttr.getFileName();
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        if (fileName.isEmpty() || fileName.equals("SourceFile")) {
            return false;
        }
        if (this.clsInfo != null) {
            String name = this.clsInfo.getShortName();
            if (fileName.equals(name)) {
                return false;
            }
            for (ClassInfo parentCls = this.clsInfo.getParentClass(); parentCls != null; parentCls = parentCls.getParentClass()) {
                String parentName = parentCls.getShortName();
                if (!parentName.equals(fileName) && !parentName.startsWith(fileName + "$")) continue;
                return false;
            }
            if (fileName.contains("$") && fileName.endsWith("$" + name)) {
                return false;
            }
            if (name.contains("$") && name.startsWith(fileName)) {
                return false;
            }
        }
        return true;
    }

    public boolean checkProcessed() {
        return this.getTopParentClass().getState().isProcessComplete();
    }

    public void ensureProcessed() {
        if (!this.checkProcessed()) {
            ClassNode topParentClass = this.getTopParentClass();
            throw new JadxRuntimeException("Expected class to be processed at this point, class: " + String.valueOf(topParentClass) + ", state: " + String.valueOf((Object)topParentClass.getState()));
        }
    }

    public ICodeInfo decompile() {
        return this.decompile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeInfo decompileWithMode(DecompilationMode mode) {
        switch (mode) {
            case AUTO: 
            case RESTRUCTURE: {
                return this.decompile(true);
            }
            case SIMPLE: 
            case FALLBACK: {
                Object object = DECOMPILE_WITH_MODE_SYNC;
                synchronized (object) {
                    ICodeInfo iCodeInfo;
                    try {
                        this.unload();
                        ICodeInfo code = this.root.getProcessClasses().forceGenerateCodeForMode(this, mode);
                        iCodeInfo = Utils.getOrElse(code, ICodeInfo.EMPTY);
                        this.unload();
                    }
                    catch (Throwable throwable) {
                        this.unload();
                        throw throwable;
                    }
                    return iCodeInfo;
                }
            }
        }
        throw new JadxRuntimeException("Unknown mode: " + String.valueOf((Object)mode));
    }

    public ICodeInfo getCode() {
        return this.decompile(true);
    }

    public ICodeInfo reloadCode() {
        this.add(AFlag.CLASS_DEEP_RELOAD);
        return this.decompile(false);
    }

    public void unloadCode() {
        if (this.state == ProcessState.NOT_LOADED) {
            return;
        }
        this.add(AFlag.CLASS_UNLOADED);
        this.unloadFromCache();
        this.deepUnload();
    }

    public void deepUnload() {
        if (this.clsData == null) {
            return;
        }
        this.clearAttributes();
        this.unload();
        this.root().getConstValues().removeForClass(this);
        this.load(this.clsData, true);
        this.innerClasses.forEach(ClassNode::deepUnload);
    }

    public void unloadFromCache() {
        if (this.isInner()) {
            return;
        }
        ICodeCache codeCache = this.root().getCodeCache();
        codeCache.remove(this.getRawName());
    }

    private synchronized ICodeInfo decompile(boolean searchInCache) {
        ICodeInfo code;
        if (this.isInner()) {
            return ICodeInfo.EMPTY;
        }
        ICodeCache codeCache = this.root().getCodeCache();
        String clsRawName = this.getRawName();
        if (searchInCache && (code = codeCache.get(clsRawName)) != ICodeInfo.EMPTY) {
            return code;
        }
        ICodeInfo codeInfo = this.generateClassCode();
        if (codeInfo != ICodeInfo.EMPTY) {
            codeCache.add(clsRawName, codeInfo);
        }
        return codeInfo;
    }

    private ICodeInfo generateClassCode() {
        try {
            ICodeInfo codeInfo = this.root.getProcessClasses().generateCode(this);
            ClassNode.processDefinitionAnnotations(codeInfo);
            return codeInfo;
        }
        catch (Exception | StackOverflowError e) {
            this.addError("Code generation failed", e);
            return new SimpleCodeInfo(Utils.getStackTrace(e));
        }
    }

    private static void processDefinitionAnnotations(ICodeInfo codeInfo) {
        Map<Integer, ICodeAnnotation> annotations = codeInfo.getCodeMetadata().getAsMap();
        if (annotations.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, ICodeAnnotation> entry : annotations.entrySet()) {
            ICodeAnnotation ann = entry.getValue();
            if (ann.getAnnType() != ICodeAnnotation.AnnType.DECLARATION) continue;
            NodeDeclareRef declareRef = (NodeDeclareRef)ann;
            int pos = entry.getKey();
            declareRef.setDefPos(pos);
            declareRef.getNode().setDefPosition(pos);
        }
        annotations.values().removeIf(v -> {
            if (v.getAnnType() == ICodeAnnotation.AnnType.VAR_REF) {
                VarRef varRef = (VarRef)v;
                if (varRef.getRefPos() == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Var reference '{}' incorrect (ref pos is zero) and was removed from metadata", (Object)varRef);
                    }
                    return true;
                }
                return false;
            }
            return false;
        });
    }

    @Nullable
    public ICodeInfo getCodeFromCache() {
        String clsRawName;
        ICodeCache codeCache = this.root().getCodeCache();
        ICodeInfo codeInfo = codeCache.get(clsRawName = this.getRawName());
        if (codeInfo == ICodeInfo.EMPTY) {
            return null;
        }
        return codeInfo;
    }

    @Override
    public void load() {
        for (MethodNode mth : this.getMethods()) {
            try {
                mth.load();
            }
            catch (Exception e) {
                mth.addError("Method load error", e);
            }
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.load();
        }
        this.setState(ProcessState.LOADED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        if (this.state == ProcessState.NOT_LOADED) {
            return;
        }
        ClassInfo classInfo = this.clsInfo;
        synchronized (classInfo) {
            this.methods.forEach(MethodNode::unload);
            this.innerClasses.forEach(ClassNode::unload);
            this.fields.forEach(FieldNode::unload);
            this.unloadAttributes();
            this.setState(ProcessState.NOT_LOADED);
            this.loadStage = LoadStage.NONE;
            this.smali = null;
        }
    }

    private void buildCache() {
        this.mthInfoMap = new HashMap<MethodInfo, MethodNode>(this.methods.size());
        for (MethodNode mth : this.methods) {
            this.mthInfoMap.put(mth.getMethodInfo(), mth);
        }
    }

    @Nullable
    public ArgType getSuperClass() {
        return this.superClass;
    }

    public List<ArgType> getInterfaces() {
        return this.interfaces;
    }

    public List<ArgType> getGenericTypeParameters() {
        return this.generics;
    }

    public ArgType getType() {
        ArgType clsType = this.clsInfo.getType();
        if (Utils.notEmpty(this.generics)) {
            return ArgType.generic(clsType, this.generics);
        }
        return clsType;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public void addField(FieldNode fld) {
        if (this.fields == null || this.fields.isEmpty()) {
            this.fields = new ArrayList<FieldNode>(1);
        }
        this.fields.add(fld);
    }

    @Nullable
    public IFieldInfoRef getConstField(Object obj) {
        return this.getConstField(obj, true);
    }

    @Nullable
    public IFieldInfoRef getConstField(Object obj, boolean searchGlobal) {
        return this.root().getConstValues().getConstField(this, obj, searchGlobal);
    }

    @Nullable
    public IFieldInfoRef getConstFieldByLiteralArg(LiteralArg arg) {
        return this.root().getConstValues().getConstFieldByLiteralArg(this, arg);
    }

    public FieldNode searchField(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equals(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByNameAndType(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equalsNameAndType(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByName(String name) {
        for (FieldNode f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByShortId(String shortId) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().getShortId().equals(shortId)) continue;
            return f;
        }
        return null;
    }

    public MethodNode searchMethod(MethodInfo mth) {
        return this.mthInfoMap.get(mth);
    }

    public MethodNode searchMethodByShortId(String shortId) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getShortId().equals(shortId)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public MethodNode searchMethodByShortName(String name) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public ClassNode getDeclaringClass() {
        return this.isInner() ? this.parentClass : null;
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public void notInner() {
        this.clsInfo.notInner(this.root);
        this.parentClass = this;
    }

    @Override
    public void rename(String newName) {
        if (newName.indexOf(46) == -1) {
            this.clsInfo.changeShortName(newName);
            return;
        }
        ClassInfo newClsInfo = ClassInfo.fromNameWithoutCache(this.root, newName, this.clsInfo.isInner());
        String newPkg = newClsInfo.getPackage();
        String newShortName = newClsInfo.getShortName();
        if (this.clsInfo.isInner()) {
            if (!newPkg.equals(this.clsInfo.getPackage())) {
                this.addWarn("Can't change package for inner class: " + String.valueOf(this) + " to " + newName);
            }
            this.clsInfo.changeShortName(newShortName);
        } else if (this.changeClassNodePackage(newPkg)) {
            this.clsInfo.changePkgAndName(newPkg, newShortName);
        } else {
            this.clsInfo.changeShortName(newShortName);
        }
    }

    private boolean changeClassNodePackage(String fullPkg) {
        if (fullPkg.equals(this.clsInfo.getAliasPkg())) {
            return false;
        }
        if (this.clsInfo.isInner()) {
            throw new JadxRuntimeException("Can't change package for inner class: " + String.valueOf(this.clsInfo));
        }
        this.root.removeClsFromPackage(this.packageNode, this);
        this.packageNode = PackageNode.getForClass(this.root, fullPkg, this);
        this.root.sortPackages();
        return true;
    }

    public void removeAlias() {
        if (!this.clsInfo.isInner()) {
            this.changeClassNodePackage(this.clsInfo.getPackage());
        }
        this.clsInfo.removeAlias();
    }

    @Override
    public void onParentPackageUpdate(PackageNode updatedPkg) {
        if (this.clsInfo.isInner()) {
            return;
        }
        this.clsInfo.changePkg(this.packageNode.getAliasPkgInfo().getFullName());
    }

    public PackageNode getPackageNode() {
        return this.packageNode;
    }

    public ClassNode getTopParentClass() {
        ClassNode parent = this.getParentClass();
        return parent == this ? this : parent.getTopParentClass();
    }

    public void visitParentClasses(Consumer<ClassNode> consumer) {
        ClassNode currentCls = this;
        ClassNode parentCls = currentCls.getParentClass();
        while (parentCls != currentCls) {
            consumer.accept(parentCls);
            currentCls = parentCls;
            parentCls = currentCls.getParentClass();
        }
    }

    public void visitSuperTypes(BiConsumer<ArgType, ArgType> consumer) {
        TypeUtils typeUtils = this.root.getTypeUtils();
        ArgType thisType = this.getType();
        if (!this.superClass.equals(ArgType.OBJECT)) {
            consumer.accept(thisType, this.superClass);
            typeUtils.visitSuperTypes(this.superClass, consumer);
        }
        for (ArgType iface : this.interfaces) {
            consumer.accept(thisType, iface);
            typeUtils.visitSuperTypes(iface, consumer);
        }
    }

    public boolean hasNotGeneratedParent() {
        if (this.contains(AFlag.DONT_GENERATE)) {
            return true;
        }
        ClassNode parent = this.getParentClass();
        if (parent == this) {
            return false;
        }
        return parent.hasNotGeneratedParent();
    }

    public List<ClassNode> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassNode> getInlinedClasses() {
        return this.inlinedClasses;
    }

    public void getInnerAndInlinedClassesRecursive(Set<ClassNode> resultClassesSet) {
        for (ClassNode innerCls : this.innerClasses) {
            if (!resultClassesSet.add(innerCls)) continue;
            innerCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
        for (ClassNode inlinedCls : this.inlinedClasses) {
            if (!resultClassesSet.add(inlinedCls)) continue;
            inlinedCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
    }

    public void addInnerClass(ClassNode cls) {
        if (this.innerClasses.isEmpty()) {
            this.innerClasses = new ArrayList<ClassNode>(5);
        }
        this.innerClasses.add(cls);
        cls.parentClass = this;
    }

    public void addInlinedClass(ClassNode cls) {
        if (this.inlinedClasses.isEmpty()) {
            this.inlinedClasses = new ArrayList<ClassNode>(5);
        }
        cls.addAttr(new InlinedAttr(this));
        this.inlinedClasses.add(cls);
    }

    public boolean isEnum() {
        return this.getAccessFlags().isEnum() && this.getSuperClass() != null && this.getSuperClass().getObject().equals(ArgType.ENUM.getObject());
    }

    public boolean isAnonymous() {
        return this.contains(AType.ANONYMOUS_CLASS);
    }

    public boolean isSynthetic() {
        return this.contains(AFlag.SYNTHETIC);
    }

    public boolean isInner() {
        return this.parentClass != this;
    }

    public boolean isTopClass() {
        return this.parentClass == this;
    }

    @Nullable
    public MethodNode getClassInitMth() {
        return this.searchMethodByShortId("<clinit>()V");
    }

    @Nullable
    public MethodNode getDefaultConstructor() {
        for (MethodNode mth : this.methods) {
            if (!mth.isDefaultConstructor()) continue;
            return mth;
        }
        return null;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public RootNode root() {
        return this.root;
    }

    @Override
    public String typeName() {
        return "class";
    }

    public String getRawName() {
        return this.clsInfo.getRawName();
    }

    public ClassInfo getClassInfo() {
        return this.clsInfo;
    }

    public String getName() {
        return this.clsInfo.getShortName();
    }

    public String getAlias() {
        return this.clsInfo.getAliasShortName();
    }

    @Deprecated
    public String getShortName() {
        return this.clsInfo.getAliasShortName();
    }

    public String getFullName() {
        return this.clsInfo.getAliasFullName();
    }

    public String getPackage() {
        return this.clsInfo.getAliasPkg();
    }

    public String getDisassembledCode() {
        if (this.smali == null) {
            SimpleCodeWriter code = new SimpleCodeWriter(this.root.getArgs());
            this.getDisassembledCode(code);
            LinkedHashSet<ClassNode> allInlinedClasses = new LinkedHashSet<ClassNode>();
            this.getInnerAndInlinedClassesRecursive(allInlinedClasses);
            for (ClassNode innerClass : allInlinedClasses) {
                innerClass.getDisassembledCode(code);
            }
            this.smali = code.finish().getCodeStr();
        }
        return this.smali;
    }

    protected void getDisassembledCode(SimpleCodeWriter code) {
        if (this.clsData == null) {
            code.startLine(String.format("###### Class %s is created by jadx", this.getFullName()));
            return;
        }
        code.startLine(String.format("###### Class %s (%s)", this.getFullName(), this.getRawName()));
        try {
            code.startLine(this.clsData.getDisassembledCode());
        }
        catch (Exception e) {
            code.startLine("Failed to disassemble class:");
            code.startLine(Utils.getStackTrace(e));
        }
    }

    @Nullable
    public IClassData getClsData() {
        return this.clsData;
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public LoadStage getLoadStage() {
        return this.loadStage;
    }

    public void setLoadStage(LoadStage loadStage) {
        this.loadStage = loadStage;
    }

    public void reloadAtCodegenStage() {
        ClassNode topCls = this.getTopParentClass();
        if (topCls.getLoadStage() == LoadStage.CODEGEN_STAGE) {
            throw new JadxRuntimeException("Class not yet loaded at codegen stage: " + String.valueOf(topCls));
        }
        topCls.add(AFlag.RELOAD_AT_CODEGEN_STAGE);
    }

    public List<ClassNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ClassNode> dependencies) {
        this.dependencies = dependencies;
    }

    public void removeDependency(ClassNode dep) {
        this.dependencies = ListUtils.safeRemoveAndTrim(this.dependencies, dep);
    }

    public List<ClassNode> getCodegenDeps() {
        return this.codegenDeps;
    }

    public void setCodegenDeps(List<ClassNode> codegenDeps) {
        this.codegenDeps = codegenDeps;
    }

    public void addCodegenDep(ClassNode dep) {
        if (!this.codegenDeps.contains(dep)) {
            this.codegenDeps = ListUtils.safeAdd(this.codegenDeps, dep);
        }
    }

    public int getTotalDepsCount() {
        return this.dependencies.size() + this.codegenDeps.size();
    }

    public List<ClassNode> getUseIn() {
        return this.useIn;
    }

    public void setUseIn(List<ClassNode> useIn) {
        this.useIn = useIn;
    }

    public List<MethodNode> getUseInMth() {
        return this.useInMth;
    }

    public void setUseInMth(List<MethodNode> useInMth) {
        this.useInMth = useInMth;
    }

    @Override
    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public JavaClass getJavaNode() {
        return this.javaNode;
    }

    public void setJavaNode(JavaClass javaNode) {
        this.javaNode = javaNode;
    }

    @Override
    public ICodeAnnotation.AnnType getAnnType() {
        return ICodeAnnotation.AnnType.CLASS;
    }

    public int hashCode() {
        return this.clsInfo.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassNode) {
            ClassNode other = (ClassNode)o;
            return this.clsInfo.equals(other.clsInfo);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull ClassNode o) {
        return this.clsInfo.compareTo(o.clsInfo);
    }

    public String toString() {
        return this.clsInfo.getFullName();
    }
}

