/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.InsnNode;
import org.jetbrains.annotations.Nullable;

public class InvokeNode
extends BaseInvokeNode {
    private final InvokeType type;
    private final MethodInfo mth;

    public InvokeNode(MethodInfo mthInfo, InsnData insn, InvokeType invokeType, boolean isRange) {
        this(mthInfo, insn, invokeType, invokeType != InvokeType.STATIC, isRange);
    }

    public InvokeNode(MethodInfo mth, InsnData insn, InvokeType type, boolean instanceCall, boolean isRange) {
        super(InsnType.INVOKE, mth.getArgsCount() + (instanceCall ? 1 : 0));
        int k;
        this.mth = mth;
        this.type = type;
        int n = k = isRange ? insn.getReg(0) : 0;
        if (instanceCall) {
            int r = isRange ? k : insn.getReg(k);
            this.addReg(r, mth.getDeclClass().getType());
            ++k;
        }
        for (ArgType arg : mth.getArgumentsTypes()) {
            this.addReg(isRange ? k : insn.getReg(k), arg);
            k += arg.getRegCount();
        }
        int resReg = insn.getResultReg();
        if (resReg != -1) {
            this.setResult(InsnArg.reg(resReg, mth.getReturnType()));
        }
    }

    public InvokeNode(MethodInfo mth, InvokeType invokeType, int argsCount) {
        super(InsnType.INVOKE, argsCount);
        this.mth = mth;
        this.type = invokeType;
    }

    public InvokeType getInvokeType() {
        return this.type;
    }

    @Override
    public MethodInfo getCallMth() {
        return this.mth;
    }

    @Override
    @Nullable
    public InsnArg getInstanceArg() {
        if (this.type != InvokeType.STATIC && this.getArgsCount() > 0) {
            return this.getArg(0);
        }
        return null;
    }

    @Override
    public boolean isStaticCall() {
        return this.type == InvokeType.STATIC;
    }

    public boolean isPolymorphicCall() {
        if (this.type == InvokeType.POLYMORPHIC) {
            return true;
        }
        return this.type == InvokeType.VIRTUAL && this.mth.getDeclClass().getFullName().equals("java.lang.invoke.MethodHandle") && (this.mth.getName().equals("invoke") || this.mth.getName().equals("invokeExact"));
    }

    @Override
    public int getFirstArgOffset() {
        return this.type == InvokeType.STATIC ? 0 : 1;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new InvokeNode(this.mth, this.type, this.getArgsCount()));
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvokeNode) || !super.isSame(obj)) {
            return false;
        }
        InvokeNode other = (InvokeNode)obj;
        return this.type == other.type && this.mth.equals(other.mth);
    }

    @Override
    public String toString() {
        return this.baseString() + " " + String.valueOf((Object)this.type) + " call: " + String.valueOf(this.mth) + this.attributesString();
    }
}

