/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.info.ClassAliasInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassInfo
implements Comparable<ClassInfo> {
    private final ArgType type;
    private String name;
    @Nullable(value="for inner classes")
    private @Nullable(value="for inner classes") String pkg;
    private String fullName;
    @Nullable
    private ClassInfo parentClass;
    @Nullable
    private ClassAliasInfo alias;

    private ClassInfo(RootNode root, ArgType type, boolean canBeInner) {
        this.type = type;
        this.splitAndApplyNames(root, type, canBeInner);
    }

    public static ClassInfo fromType(RootNode root, ArgType type) {
        ArgType clsType = ClassInfo.checkClassType(type);
        ClassInfo cls = root.getInfoStorage().getCls(clsType);
        if (cls != null) {
            return cls;
        }
        boolean canBeInner = root.getArgs().isMoveInnerClasses();
        ClassInfo newClsInfo = new ClassInfo(root, clsType, canBeInner);
        return root.getInfoStorage().putCls(newClsInfo);
    }

    public static ClassInfo fromName(RootNode root, String clsName) {
        return ClassInfo.fromType(root, ArgType.object(clsName));
    }

    public static ClassInfo fromNameWithoutCache(RootNode root, String fullClsName, boolean canBeInner) {
        return new ClassInfo(root, ArgType.object(fullClsName), canBeInner);
    }

    private static ArgType checkClassType(ArgType type) {
        if (type == null) {
            throw new JadxRuntimeException("Null class type");
        }
        if (type.isArray()) {
            return ArgType.OBJECT;
        }
        if (!type.isObject() || type.isGenericType()) {
            throw new JadxRuntimeException("Not class type: " + String.valueOf(type));
        }
        if (type.isGeneric()) {
            return ArgType.object(type.getObject());
        }
        return type;
    }

    public void changeShortName(String aliasName) {
        String aliasPkg = this.getAliasPkg();
        ClassAliasInfo newAlias = Objects.equals(this.name, aliasName) || StringUtils.isEmpty(aliasName) ? (Objects.equals(this.getPackage(), aliasPkg) ? null : new ClassAliasInfo(aliasPkg, this.name)) : new ClassAliasInfo(aliasPkg, aliasName);
        if (newAlias != null) {
            this.fillAliasFullName(newAlias);
        }
        this.alias = newAlias;
    }

    public void changePkg(String aliasPkg) {
        if (this.isInner()) {
            throw new JadxRuntimeException("Can't change package for inner class: " + String.valueOf(this));
        }
        if (!Objects.equals(this.getAliasPkg(), aliasPkg)) {
            ClassAliasInfo newAlias = new ClassAliasInfo(aliasPkg, this.getAliasShortName());
            this.fillAliasFullName(newAlias);
            this.alias = newAlias;
        }
    }

    public void changePkgAndName(String aliasPkg, String aliasShortName) {
        if (this.isInner()) {
            throw new JadxRuntimeException("Can't change package for inner class");
        }
        ClassAliasInfo newAlias = new ClassAliasInfo(aliasPkg, aliasShortName);
        this.fillAliasFullName(newAlias);
        this.alias = newAlias;
    }

    private void fillAliasFullName(ClassAliasInfo alias) {
        if (this.parentClass == null) {
            alias.setFullName(ClassInfo.makeFullClsName(alias.getPkg(), alias.getShortName(), null, true, false));
        }
    }

    public String getAliasPkg() {
        if (this.isInner()) {
            return this.parentClass.getAliasPkg();
        }
        return this.alias == null ? this.getPackage() : this.alias.getPkg();
    }

    public String getAliasShortName() {
        return this.alias == null ? this.getShortName() : this.alias.getShortName();
    }

    public String getAliasFullName() {
        if (this.alias != null) {
            String aliasFullName = this.alias.getFullName();
            if (aliasFullName == null) {
                return this.makeAliasFullName();
            }
            return aliasFullName;
        }
        if (this.parentClass != null && this.parentClass.hasAlias()) {
            return this.makeAliasFullName();
        }
        return this.getFullName();
    }

    public boolean hasAlias() {
        if (this.alias != null && !this.alias.getShortName().equals(this.getShortName())) {
            return true;
        }
        return this.parentClass != null && this.parentClass.hasAlias();
    }

    public boolean hasAliasPkg() {
        return !this.getPackage().equals(this.getAliasPkg());
    }

    public void removeAlias() {
        this.alias = null;
    }

    private void splitAndApplyNames(RootNode root, ArgType type, boolean canBeInner) {
        int sep;
        String clsName;
        String clsPkg;
        String fullObjectName = type.getObject();
        int dot = fullObjectName.lastIndexOf(46);
        if (dot == -1) {
            clsPkg = "";
            clsName = fullObjectName;
        } else {
            clsPkg = fullObjectName.substring(0, dot);
            clsName = fullObjectName.substring(dot + 1);
        }
        boolean innerCls = false;
        if (canBeInner && (sep = clsName.lastIndexOf(36)) > 0 && sep != clsName.length() - 1) {
            Object parClsName = clsPkg + "." + clsName.substring(0, sep);
            if (clsPkg.isEmpty()) {
                parClsName = clsName.substring(0, sep);
            }
            this.pkg = null;
            this.parentClass = ClassInfo.fromName(root, (String)parClsName);
            clsName = clsName.substring(sep + 1);
            innerCls = true;
        }
        if (!innerCls) {
            this.pkg = clsPkg;
            this.parentClass = null;
        }
        this.name = clsName;
        this.fullName = this.makeFullName();
    }

    private static String makeFullClsName(String pkg, String shortName, ClassInfo parentClass, boolean alias, boolean raw) {
        if (parentClass != null) {
            char innerSep;
            char c = innerSep = raw ? (char)'$' : '.';
            String parentFullName = alias ? (raw ? parentClass.makeAliasRawFullName() : parentClass.getAliasFullName()) : (raw ? parentClass.makeRawFullName() : parentClass.getFullName());
            return parentFullName + innerSep + shortName;
        }
        return pkg.isEmpty() ? shortName : pkg + "." + shortName;
    }

    private String makeFullName() {
        return ClassInfo.makeFullClsName(this.pkg, this.name, this.parentClass, false, false);
    }

    public String makeRawFullName() {
        return ClassInfo.makeFullClsName(this.pkg, this.name, this.parentClass, false, true);
    }

    public String makeAliasFullName() {
        return ClassInfo.makeFullClsName(this.getAliasPkg(), this.getAliasShortName(), this.parentClass, true, false);
    }

    public String makeAliasRawFullName() {
        return ClassInfo.makeFullClsName(this.getAliasPkg(), this.getAliasShortName(), this.parentClass, true, true);
    }

    public String getAliasFullPath() {
        return this.getAliasPkg().replace('.', File.separatorChar) + File.separatorChar + this.getAliasNameWithoutPackage().replace('.', '_');
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.name;
    }

    @NotNull
    public String getPackage() {
        if (this.parentClass != null) {
            return this.parentClass.getPackage();
        }
        if (this.pkg == null) {
            throw new JadxRuntimeException("Package is null for not inner class");
        }
        return this.pkg;
    }

    public boolean isDefaultPackage() {
        return this.getPackage().isEmpty();
    }

    public String getRawName() {
        return this.type.getObject();
    }

    public String getAliasNameWithoutPackage() {
        if (this.parentClass == null) {
            return this.getAliasShortName();
        }
        return this.parentClass.getAliasNameWithoutPackage() + "." + this.getAliasShortName();
    }

    @Nullable
    public ClassInfo getParentClass() {
        return this.parentClass;
    }

    public ClassInfo getTopParentClass() {
        if (this.parentClass != null) {
            ClassInfo topCls = this.parentClass.getTopParentClass();
            return topCls != null ? topCls : this.parentClass;
        }
        return null;
    }

    public boolean isInner() {
        return this.parentClass != null;
    }

    public void notInner(RootNode root) {
        this.splitAndApplyNames(root, this.type, false);
        this.parentClass = null;
    }

    public void convertToInner(ClassNode parent) {
        this.splitAndApplyNames(parent.root(), this.type, true);
        this.parentClass = parent.getClassInfo();
    }

    public void updateNames(RootNode root) {
        this.splitAndApplyNames(root, this.type, this.isInner());
    }

    public ArgType getType() {
        return this.type;
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassInfo) {
            return this.type.equals(((ClassInfo)obj).type);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull ClassInfo other) {
        return this.getRawName().compareTo(other.getRawName());
    }
}

