/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrList;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class AttributeStorage {
    private static final Map<IJadxAttrType<?>, IJadxAttribute> EMPTY_ATTRIBUTES;
    private final Set<AFlag> flags = EnumSet.noneOf(AFlag.class);
    private Map<IJadxAttrType<?>, IJadxAttribute> attributes = EMPTY_ATTRIBUTES;

    public static AttributeStorage fromList(List<IJadxAttribute> list) {
        AttributeStorage storage = new AttributeStorage();
        storage.add(list);
        return storage;
    }

    public void add(AFlag flag) {
        this.flags.add(flag);
    }

    public void add(IJadxAttribute attr) {
        this.writeAttributes(map -> map.put(attr.getAttrType(), attr));
    }

    public void add(List<IJadxAttribute> list) {
        this.writeAttributes(map -> list.forEach(attr -> map.put(attr.getAttrType(), attr)));
    }

    public <T> void add(IJadxAttrType<AttrList<T>> type, T obj) {
        AttrList<T> list = this.get(type);
        if (list == null) {
            list = new AttrList<T>(type);
            this.add(list);
        }
        list.getList().add(obj);
    }

    public void addAll(AttributeStorage otherList) {
        this.flags.addAll(otherList.flags);
        if (!otherList.attributes.isEmpty()) {
            this.writeAttributes(m -> m.putAll(otherList.attributes));
        }
    }

    public boolean contains(AFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public <T extends IJadxAttribute> boolean contains(IJadxAttrType<T> type) {
        return this.attributes.containsKey(type);
    }

    public <T extends IJadxAttribute> T get(IJadxAttrType<T> type) {
        return (T)this.attributes.get(type);
    }

    public IAnnotation getAnnotation(String cls) {
        AnnotationsAttr aList = (AnnotationsAttr)this.get((IJadxAttrType)JadxAttrType.ANNOTATION_LIST);
        return aList == null ? null : aList.get(cls);
    }

    public <T> List<T> getAll(IJadxAttrType<AttrList<T>> type) {
        AttrList<T> attrList = this.get(type);
        if (attrList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(attrList.getList());
    }

    public void remove(AFlag flag) {
        this.flags.remove((Object)flag);
    }

    public void clearFlags() {
        this.flags.clear();
    }

    public <T extends IJadxAttribute> void remove(IJadxAttrType<T> type) {
        if (!this.attributes.isEmpty()) {
            this.writeAttributes(map -> map.remove(type));
        }
    }

    public void remove(IJadxAttribute attr) {
        if (!this.attributes.isEmpty()) {
            this.writeAttributes(map -> {
                IJadxAttrType type = attr.getAttrType();
                IJadxAttribute a = (IJadxAttribute)map.get(type);
                if (a == attr) {
                    map.remove(type);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttributes(Consumer<Map<IJadxAttrType<?>, IJadxAttribute>> mapConsumer) {
        AttributeStorage attributeStorage = this;
        synchronized (attributeStorage) {
            if (this.attributes == EMPTY_ATTRIBUTES) {
                this.attributes = new IdentityHashMap(2);
            }
            mapConsumer.accept(this.attributes);
            if (this.attributes.isEmpty()) {
                this.attributes = EMPTY_ATTRIBUTES;
            }
        }
    }

    public void unloadAttributes() {
        if (this.attributes.isEmpty()) {
            return;
        }
        this.writeAttributes(map -> map.entrySet().removeIf(entry -> !((IJadxAttribute)entry.getValue()).keepLoaded()));
    }

    public List<String> getAttributeStrings() {
        int size = this.flags.size() + this.attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (AFlag aFlag : this.flags) {
            list.add(aFlag.toString());
        }
        for (IJadxAttribute iJadxAttribute : this.attributes.values()) {
            list.add(iJadxAttribute.toAttrString());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.attributes.isEmpty();
    }

    public String toString() {
        List<String> list = this.getAttributeStrings();
        if (list.isEmpty()) {
            return "";
        }
        list.sort(String::compareTo);
        return "A[" + Utils.listToString(list) + "]";
    }

    static {
        int flagsCount = AFlag.values().length;
        if (flagsCount >= 64) {
            throw new JadxRuntimeException("Try to reduce flags count to 64 for use one long in EnumSet, now " + flagsCount);
        }
        EMPTY_ATTRIBUTES = Collections.emptyMap();
    }
}

