/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.metadata.annotations;

import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.VarRef;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.MethodNode;
import org.jetbrains.annotations.Nullable;

public class VarNode
implements ICodeNodeRef {
    private final MethodNode mth;
    private final int reg;
    private final int ssa;
    private final ArgType type;
    @Nullable
    private String name;
    private int defPos;
    private final VarRef varRef;

    @Nullable
    public static VarNode get(MethodNode mth, RegisterArg reg) {
        SSAVar ssaVar = reg.getSVar();
        if (ssaVar == null) {
            return null;
        }
        return VarNode.get(mth, ssaVar);
    }

    @Nullable
    public static VarNode get(MethodNode mth, CodeVar codeVar) {
        return VarNode.get(mth, codeVar.getAnySsaVar());
    }

    @Nullable
    public static VarNode get(MethodNode mth, SSAVar ssaVar) {
        CodeVar codeVar = ssaVar.getCodeVar();
        if (codeVar.isThis()) {
            return null;
        }
        VarNode cachedVarNode = codeVar.getCachedVarNode();
        if (cachedVarNode != null) {
            return cachedVarNode;
        }
        VarNode newVarNode = new VarNode(mth, ssaVar);
        codeVar.setCachedVarNode(newVarNode);
        return newVarNode;
    }

    @Nullable
    public static ICodeAnnotation getRef(MethodNode mth, RegisterArg reg) {
        VarNode varNode = VarNode.get(mth, reg);
        if (varNode == null) {
            return null;
        }
        return varNode.getVarRef();
    }

    protected VarNode(MethodNode mth, SSAVar ssaVar) {
        this(mth, ssaVar.getRegNum(), ssaVar.getVersion(), ssaVar.getCodeVar().getType(), ssaVar.getCodeVar().getName());
    }

    public VarNode(MethodNode mth, int reg, int ssa, ArgType type, String name) {
        this.mth = mth;
        this.reg = reg;
        this.ssa = ssa;
        this.type = type;
        this.name = name;
        this.varRef = VarRef.fromVarNode(this);
    }

    public MethodNode getMth() {
        return this.mth;
    }

    public int getReg() {
        return this.reg;
    }

    public int getSsa() {
        return this.ssa;
    }

    public ArgType getType() {
        return this.type;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VarRef getVarRef() {
        return this.varRef;
    }

    @Override
    public int getDefPosition() {
        return this.defPos;
    }

    @Override
    public void setDefPosition(int pos) {
        this.defPos = pos;
    }

    @Override
    public ICodeAnnotation.AnnType getAnnType() {
        return ICodeAnnotation.AnnType.VAR;
    }

    public int hashCode() {
        int h = 31 * this.getReg() + this.getSsa();
        return 31 * h + this.mth.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VarNode)) {
            return false;
        }
        VarNode other = (VarNode)o;
        return this.getReg() == other.getReg() && this.getSsa() == other.getSsa() && this.getMth().equals(other.getMth());
    }

    public String toString() {
        return "VarNode{r" + this.reg + "v" + this.ssa + "}";
    }
}

