/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.impl.passes;

import jadx.api.impl.passes.IPassWrapperVisitor;
import jadx.api.plugins.pass.JadxPass;
import jadx.api.plugins.pass.types.JadxDecompilePass;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.exceptions.JadxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompilePassWrapper
extends AbstractVisitor
implements IPassWrapperVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DecompilePassWrapper.class);
    private final JadxDecompilePass decompilePass;

    public DecompilePassWrapper(JadxDecompilePass decompilePass) {
        this.decompilePass = decompilePass;
    }

    @Override
    public JadxPass getPass() {
        return this.decompilePass;
    }

    @Override
    public void init(RootNode root) throws JadxException {
        try {
            this.decompilePass.init(root);
        }
        catch (Exception | StackOverflowError e) {
            LOG.error("Error in decompile pass init: {}", (Object)this, (Object)e);
        }
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        try {
            return this.decompilePass.visit(cls);
        }
        catch (Exception | StackOverflowError e) {
            cls.addError("Error in decompile pass: " + String.valueOf(this), e);
            return false;
        }
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            this.decompilePass.visit(mth);
        }
        catch (Exception | StackOverflowError e) {
            mth.addError("Error in decompile pass: " + String.valueOf(this), e);
        }
    }

    @Override
    public String getName() {
        return this.decompilePass.getInfo().getName();
    }
}

