/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.core.deobf.FileTypeDetector;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.zip.IZipEntry;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class ResourceFile {
    private final JadxDecompiler decompiler;
    private final String name;
    private ResourceType type;
    @Nullable
    private IZipEntry zipEntry;
    private String deobfName;

    public static ResourceFile createResourceFile(JadxDecompiler decompiler, File file, ResourceType type) {
        return new ResourceFile(decompiler, file.getAbsolutePath(), type);
    }

    public static ResourceFile createResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        if (!decompiler.getArgs().getSecurity().isValidEntryName(name)) {
            return null;
        }
        return new ResourceFile(decompiler, name, type);
    }

    protected ResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        this.decompiler = decompiler;
        this.name = name;
        this.type = type;
    }

    public String getOriginalName() {
        return this.name;
    }

    public String getDeobfName() {
        return this.deobfName != null ? this.deobfName : this.name;
    }

    public void setDeobfName(String resFullName) {
        this.deobfName = resFullName;
    }

    public ResourceType getType() {
        return this.type;
    }

    public ResContainer loadContent() {
        return ResourcesLoader.loadContent(this.decompiler, this);
    }

    public boolean setAlias(ResourceEntry entry, boolean useHeaders) {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            sb.append("res/").append(entry.getTypeName()).append(entry.getConfig());
            sb.append("/").append(entry.getKeyName());
            if (useHeaders) {
                try {
                    int maxBytesToReadLimit = 4096;
                    byte[] bytes = ResourcesLoader.decodeStream(this, (size, is) -> {
                        int bytesToRead = size > 0L ? (int)Math.min(size, (long)maxBytesToReadLimit) : (size == 0L ? 0 : maxBytesToReadLimit);
                        if (bytesToRead == 0) {
                            return new byte[0];
                        }
                        return is.readNBytes(bytesToRead);
                    });
                    String fileExtension = FileTypeDetector.detectFileExtension(bytes);
                    if (!StringUtils.isEmpty(fileExtension)) {
                        sb.append(fileExtension);
                        break block6;
                    }
                    sb.append(this.getExtFromName(this.name));
                }
                catch (JadxException maxBytesToReadLimit) {}
            } else {
                sb.append(this.getExtFromName(this.name));
            }
        }
        String alias = sb.toString();
        if (!alias.equals(this.name)) {
            this.setDeobfName(alias);
            this.type = ResourceType.getFileType(alias);
            return true;
        }
        return false;
    }

    private String getExtFromName(String name) {
        if (name.contains(".9.png")) {
            return ".9.png";
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(lastDot);
        }
        return "";
    }

    @Nullable
    public IZipEntry getZipEntry() {
        return this.zipEntry;
    }

    void setZipEntry(@Nullable IZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    public JadxDecompiler getDecompiler() {
        return this.decompiler;
    }

    public String toString() {
        return "ResourceFile{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + "}";
    }
}

