/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.deobf.NameMapper;

class ResNameUtils {
    private ResNameUtils() {
    }

    static String sanitizeAsResourceName(String name, String postfix, boolean allowNonPrintable) {
        if (name.isEmpty()) {
            return postfix;
        }
        StringBuilder sb = new StringBuilder(name.length() + 1);
        boolean nameChanged = false;
        int cp = name.codePointAt(0);
        if (ResNameUtils.isValidResourceNameStart(cp, allowNonPrintable)) {
            sb.appendCodePoint(cp);
        } else {
            sb.append('_');
            nameChanged = true;
            if (ResNameUtils.isValidResourceNamePart(cp, allowNonPrintable)) {
                sb.appendCodePoint(cp);
            }
        }
        for (int i = Character.charCount(cp); i < name.length(); i += Character.charCount(cp)) {
            cp = name.codePointAt(i);
            if (ResNameUtils.isValidResourceNamePart(cp, allowNonPrintable)) {
                sb.appendCodePoint(cp);
                continue;
            }
            sb.append('_');
            nameChanged = true;
        }
        String sanitizedName = sb.toString();
        if (NameMapper.isReserved(sanitizedName)) {
            nameChanged = true;
        }
        return nameChanged ? sanitizedName + postfix : sanitizedName;
    }

    static String convertToRFieldName(String resourceName) {
        return resourceName.replace('.', '_');
    }

    private static boolean isValidResourceNameStart(int codePoint, boolean allowNonPrintable) {
        return (allowNonPrintable || NameMapper.isPrintableAsciiCodePoint(codePoint)) && ResNameUtils.isValidAapt2ResourceNameStart(codePoint) && NameMapper.isValidIdentifierStart(codePoint);
    }

    private static boolean isValidResourceNamePart(int codePoint, boolean allowNonPrintable) {
        return (allowNonPrintable || NameMapper.isPrintableAsciiCodePoint(codePoint)) && (ResNameUtils.isValidAapt2ResourceNamePart(codePoint) && NameMapper.isValidIdentifierPart(codePoint) || codePoint == 46);
    }

    private static boolean isValidAapt2ResourceNameStart(int codePoint) {
        return ResNameUtils.isXidStart(codePoint) || codePoint == 95;
    }

    private static boolean isValidAapt2ResourceNamePart(int codePoint) {
        return ResNameUtils.isXidContinue(codePoint) || codePoint == 46 || codePoint == 45;
    }

    private static boolean isXidStart(int codePoint) {
        return codePoint < 880 && Character.isUnicodeIdentifierStart(codePoint);
    }

    private static boolean isXidContinue(int codePoint) {
        return codePoint < 880 && Character.isUnicodeIdentifierPart(codePoint) && !Character.isIdentifierIgnorable(codePoint);
    }
}

