/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ParserStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBinaryParser
extends ParserConstants {
    private static final Logger LOG = LoggerFactory.getLogger(CommonBinaryParser.class);
    protected ParserStream is;

    protected BinaryXMLStrings parseStringPool() throws IOException {
        this.is.checkInt16(1, "String pool expected");
        return this.parseStringPoolNoType();
    }

    protected BinaryXMLStrings parseStringPoolNoType() throws IOException {
        long start = this.is.getPos() - 2L;
        int headerSize = this.is.readInt16();
        if (headerSize != 28) {
            LOG.warn("Unexpected string pool header size: 0x{}, expected: 0x1C", (Object)Integer.toHexString(headerSize));
        }
        long size = this.is.readUInt32();
        long chunkEnd = start + size;
        return this.parseStringPoolNoSize(start, chunkEnd);
    }

    protected BinaryXMLStrings parseStringPoolNoSize(long start, long chunkEnd) throws IOException {
        int stringCount = this.is.readInt32();
        int styleCount = this.is.readInt32();
        int flags = this.is.readInt32();
        long stringsStart = this.is.readInt32();
        long stylesStart = this.is.readInt32();
        byte[] buffer = this.is.readInt8Array((int)(chunkEnd - this.is.getPos()));
        this.is.checkPos(chunkEnd, "Expected strings pool end");
        return new BinaryXMLStrings(stringCount, stringsStart -= this.is.getPos() - start, buffer, (flags & 0x100) != 0);
    }

    protected void die(String message) throws IOException {
        throw new IOException("Decode error: " + message + ", position: 0x" + Long.toHexString(this.is.getPos()));
    }
}

