/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.regions.maker.RegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.RegionUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ExcHandlersRegionMaker {
    private final MethodNode mth;
    private final RegionMaker regionMaker;

    public ExcHandlersRegionMaker(MethodNode mth, RegionMaker regionMaker) {
        this.mth = mth;
        this.regionMaker = regionMaker;
    }

    public void process() {
        if (this.mth.isNoExceptionHandlers()) {
            return;
        }
        IRegion excOutBlock = this.collectHandlerRegions();
        if (excOutBlock != null) {
            this.mth.getRegion().add(excOutBlock);
        }
    }

    @Nullable
    private IRegion collectHandlerRegions() {
        List<TryCatchBlockAttr> tcs = this.mth.getAll(AType.TRY_BLOCKS_LIST);
        for (TryCatchBlockAttr tc : tcs) {
            ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(tc.getHandlersCount());
            HashSet<BlockNode> splitters = new HashSet<BlockNode>();
            for (ExceptionHandler handler : tc.getHandlers()) {
                BlockNode handlerBlock = handler.getHandlerBlock();
                if (handlerBlock != null) {
                    blocks.add(handlerBlock);
                    splitters.add(BlockUtils.getTopSplitterForHandler(handlerBlock));
                    continue;
                }
                this.mth.addDebugComment("No exception handler block: " + String.valueOf(handler));
            }
            HashSet<BlockNode> exits = new HashSet<BlockNode>();
            for (BlockNode splitter : splitters) {
                for (BlockNode handler : blocks) {
                    if (handler.contains(AFlag.REMOVE)) continue;
                    List<BlockNode> s = splitter.getSuccessors();
                    if (s.isEmpty()) {
                        this.mth.addDebugComment("No successors for splitter: " + String.valueOf(splitter));
                        continue;
                    }
                    BlockNode ss = s.get(0);
                    BlockNode cross = BlockUtils.getPathCross(this.mth, ss, handler);
                    if (cross == null || cross == ss || cross == handler) continue;
                    exits.add(cross);
                }
            }
            for (ExceptionHandler handler : tc.getHandlers()) {
                this.processExcHandler(handler, exits);
            }
        }
        return this.processHandlersOutBlocks(tcs);
    }

    @Nullable
    private IRegion processHandlersOutBlocks(List<TryCatchBlockAttr> tcs) {
        HashSet<IBlock> allRegionBlocks = new HashSet<IBlock>();
        RegionUtils.getAllRegionBlocks(this.mth.getRegion(), allRegionBlocks);
        HashSet<BlockNode> successorBlocks = new HashSet<BlockNode>();
        for (TryCatchBlockAttr tc : tcs) {
            for (ExceptionHandler exceptionHandler : tc.getHandlers()) {
                IContainer region = exceptionHandler.getHandlerRegion();
                if (region == null) continue;
                IBlock lastBlock = RegionUtils.getLastBlock(region);
                if (lastBlock instanceof BlockNode) {
                    successorBlocks.addAll(((BlockNode)lastBlock).getSuccessors());
                }
                RegionUtils.getAllRegionBlocks(region, allRegionBlocks);
            }
        }
        successorBlocks.removeAll(allRegionBlocks);
        if (successorBlocks.isEmpty()) {
            return null;
        }
        RegionStack stack = this.regionMaker.getStack();
        Region excOutRegion = new Region(this.mth.getRegion());
        for (IBlock iBlock : successorBlocks) {
            if (!(iBlock instanceof BlockNode)) continue;
            stack.clear();
            stack.push(excOutRegion);
            excOutRegion.add(this.regionMaker.makeRegion((BlockNode)iBlock));
        }
        return excOutRegion;
    }

    private void processExcHandler(ExceptionHandler handler, Set<BlockNode> exits) {
        BlockNode dom;
        BlockNode start = handler.getHandlerBlock();
        if (start == null) {
            return;
        }
        RegionStack stack = this.regionMaker.getStack().clear();
        if (handler.isFinally()) {
            dom = BlockUtils.getTopSplitterForHandler(start);
        } else {
            dom = start;
            stack.addExits(exits);
        }
        if (dom.contains(AFlag.REMOVE)) {
            return;
        }
        BitSet domFrontier = dom.getDomFrontier();
        List<BlockNode> handlerExits = BlockUtils.bitSetToBlocks(this.mth, domFrontier);
        boolean inLoop = this.mth.getLoopForBlock(start) != null;
        for (BlockNode exit : handlerExits) {
            if (inLoop && !BlockUtils.isPathExists(start, exit) || !RegionUtils.isRegionContainsBlock(this.mth.getRegion(), exit)) continue;
            stack.addExit(exit);
        }
        handler.setHandlerRegion(this.regionMaker.makeRegion(start));
        ExcHandlerAttr excHandlerAttr = start.get(AType.EXC_HANDLER);
        if (excHandlerAttr == null) {
            this.mth.addWarn("Missing exception handler attribute for start block: " + String.valueOf(start));
        } else {
            handler.getHandlerRegion().addAttr(excHandlerAttr);
        }
    }
}

