/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.gradle;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.core.dex.attributes.nodes.CodeFeaturesAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.FixSwitchOverEnum;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.export.GradleInfoStorage;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.Map;

@JadxVisitor(name="NonFinalResIdsVisitor", desc="Detect usage of android resource constants in cases where constant expressions are required.", runAfter={FixSwitchOverEnum.class})
public class NonFinalResIdsVisitor
extends AbstractVisitor
implements IRegionIterativeVisitor {
    private boolean nonFinalResIdsFlagRequired = false;
    private GradleInfoStorage gradleInfoStorage;

    @Override
    public void init(RootNode root) throws JadxException {
        this.gradleInfoStorage = root.getGradleInfoStorage();
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (this.nonFinalResIdsFlagRequired) {
            return false;
        }
        AnnotationsAttr annotationsList = (AnnotationsAttr)cls.get(JadxAttrType.ANNOTATION_LIST);
        if (this.visitAnnotationList(annotationsList)) {
            return false;
        }
        return super.visit(cls);
    }

    private static boolean isCustomResourceClass(ClassInfo cls) {
        ClassInfo parentClass = cls.getParentClass();
        return parentClass != null && parentClass.getShortName().equals("R") && !parentClass.getFullName().equals("android.R");
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        AnnotationsAttr annotationsList = (AnnotationsAttr)mth.get(JadxAttrType.ANNOTATION_LIST);
        if (this.visitAnnotationList(annotationsList)) {
            this.nonFinalResIdsFlagRequired = true;
            return;
        }
        if (this.nonFinalResIdsFlagRequired || !CodeFeaturesAttr.contains(mth, CodeFeaturesAttr.CodeFeature.SWITCH)) {
            return;
        }
        DepthRegionTraversal.traverseIterative(mth, this);
    }

    private boolean visitAnnotationList(AnnotationsAttr annotationsList) {
        if (annotationsList != null) {
            for (IAnnotation annotation : annotationsList.getAll()) {
                if (annotation.getVisibility() == AnnotationVisibility.SYSTEM) continue;
                for (Map.Entry entry : annotation.getValues().entrySet()) {
                    Object value = ((EncodedValue)entry.getValue()).getValue();
                    if (!(value instanceof IFieldInfoRef) || !NonFinalResIdsVisitor.isCustomResourceClass(((IFieldInfoRef)value).getFieldInfo().getDeclClass())) continue;
                    this.gradleInfoStorage.setNonFinalResIds(true);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visitRegion(MethodNode mth, IRegion region) {
        if (this.nonFinalResIdsFlagRequired) {
            return false;
        }
        if (region instanceof SwitchRegion) {
            return this.detectSwitchOverResIds((SwitchRegion)region);
        }
        return false;
    }

    private boolean detectSwitchOverResIds(SwitchRegion switchRegion) {
        for (SwitchRegion.CaseInfo caseInfo : switchRegion.getCases()) {
            for (Object key : caseInfo.getKeys()) {
                ClassNode topParentClass;
                if (!(key instanceof FieldNode) || !AndroidResourcesUtils.isResourceClass(topParentClass = ((FieldNode)key).getTopParentClass()) || "android.R".equals(topParentClass.getFullName())) continue;
                this.nonFinalResIdsFlagRequired = true;
                this.gradleInfoStorage.setNonFinalResIds(true);
                return false;
            }
        }
        return false;
    }
}

