/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.fixaccessmodifiers;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodInlineAttr;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.fixaccessmodifiers.VisibilityUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.Set;
import java.util.stream.Collectors;

@JadxVisitor(name="FixAccessModifiers", desc="Change class and method access modifiers if needed", runAfter={ModVisitor.class})
public class FixAccessModifiers
extends AbstractVisitor {
    private VisibilityUtils visibilityUtils;
    private boolean respectAccessModifiers;

    @Override
    public void init(RootNode root) {
        this.visibilityUtils = new VisibilityUtils(root);
        this.respectAccessModifiers = root.getArgs().isRespectBytecodeAccModifiers();
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (this.respectAccessModifiers) {
            return true;
        }
        this.fixClassVisibility(cls);
        return true;
    }

    @Override
    public void visit(MethodNode mth) {
        if (this.respectAccessModifiers || mth.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        this.fixMethodVisibility(mth);
    }

    private void fixClassVisibility(ClassNode cls) {
        AccessInfo accessFlags = cls.getAccessFlags();
        if (cls.isTopClass() && accessFlags.isPublic()) {
            return;
        }
        if (cls.isTopClass() && (accessFlags.isPrivate() || accessFlags.isProtected())) {
            FixAccessModifiers.changeVisibility(cls, 1);
            return;
        }
        for (ClassNode useCls : cls.getUseIn()) {
            this.visibilityUtils.checkVisibility(cls, useCls, (node, visFlag) -> FixAccessModifiers.changeVisibility((NotificationAttrNode)node, visFlag));
        }
        for (MethodNode useMth : cls.getUseInMth()) {
            MethodInlineAttr inlineAttr = useMth.get(AType.METHOD_INLINE);
            boolean isInline = inlineAttr != null && !inlineAttr.notNeeded();
            boolean isCandidateForInline = useMth.contains(AFlag.METHOD_CANDIDATE_FOR_INLINE);
            if (!isInline && !isCandidateForInline) continue;
            Set usedInClss = useMth.getUseIn().stream().map(MethodNode::getParentClass).collect(Collectors.toSet());
            for (ClassNode useCls : usedInClss) {
                this.visibilityUtils.checkVisibility(cls, useCls, (node, visFlag) -> FixAccessModifiers.changeVisibility((NotificationAttrNode)node, visFlag));
            }
        }
    }

    private void fixMethodVisibility(MethodNode mth) {
        IMethodDetails parentMD;
        AccessInfo parentAccInfo;
        AccessInfo accessFlags = mth.getAccessFlags();
        MethodOverrideAttr overrideAttr = mth.get(AType.METHOD_OVERRIDE);
        if (overrideAttr != null && !overrideAttr.getOverrideList().isEmpty() && accessFlags.isVisibilityWeakerThan(parentAccInfo = new AccessInfo((parentMD = overrideAttr.getOverrideList().get(0)).getRawAccessFlags(), AccessInfo.AFType.METHOD))) {
            FixAccessModifiers.changeVisibility(mth, parentAccInfo.getVisibility().rawValue());
        }
        for (MethodNode useMth : mth.getUseIn()) {
            this.visibilityUtils.checkVisibility(mth, useMth, (node, visFlag) -> FixAccessModifiers.changeVisibility((NotificationAttrNode)node, visFlag));
        }
    }

    public static void changeVisibility(NotificationAttrNode node, int newVisFlag) {
        AccessInfo accessFlags = node.getAccessFlags();
        AccessInfo newAccFlags = accessFlags.changeVisibility(newVisFlag);
        if (newAccFlags != accessFlags) {
            node.setAccessFlags(newAccFlags);
            node.addInfoComment("Access modifiers changed from: " + accessFlags.visibilityName());
        }
    }
}

