/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions;

import jadx.api.ICodeWriter;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SwitchRegion
extends AbstractRegion
implements IBranchRegion {
    public static final Object DEFAULT_CASE_KEY = new Object(){

        public String toString() {
            return "default";
        }
    };
    private final BlockNode header;
    private final List<CaseInfo> cases;

    public SwitchRegion(IRegion parent, BlockNode header) {
        super(parent);
        this.header = header;
        this.cases = new ArrayList<CaseInfo>();
    }

    public BlockNode getHeader() {
        return this.header;
    }

    public void addCase(List<Object> keysList, IContainer c) {
        this.cases.add(new CaseInfo(keysList, c));
    }

    public List<CaseInfo> getCases() {
        return this.cases;
    }

    public List<IContainer> getCaseContainers() {
        return Utils.collectionMap(this.cases, caseInfo -> caseInfo.container);
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(this.cases.size() + 1);
        all.add(this.header);
        all.addAll(this.getCaseContainers());
        return Collections.unmodifiableList(all);
    }

    @Override
    public List<IContainer> getBranches() {
        return Collections.unmodifiableList(this.getCaseContainers());
    }

    @Override
    public void generate(RegionGen regionGen, ICodeWriter code) throws CodegenException {
        regionGen.makeSwitch(this, code);
    }

    @Override
    public String baseString() {
        return this.header.baseString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Switch: ").append(this.cases.size());
        for (CaseInfo caseInfo : this.cases) {
            List<String> keyStrings = Utils.collectionMap(caseInfo.getKeys(), k -> k == DEFAULT_CASE_KEY ? "default" : k.toString());
            sb.append("\n case ").append(Utils.listToString(keyStrings)).append(" -> ").append(caseInfo.getContainer());
        }
        return sb.toString();
    }

    public static final class CaseInfo {
        private final List<Object> keys;
        private final IContainer container;

        public CaseInfo(List<Object> keys, IContainer container) {
            this.keys = keys;
            this.container = container;
        }

        public List<Object> getKeys() {
            return this.keys;
        }

        public IContainer getContainer() {
            return this.container;
        }
    }
}

