/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.utils;

import jadx.core.clsp.ClspClass;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.ClassTypeVarsAttr;
import jadx.core.dex.attributes.nodes.MethodTypeVarsAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private final RootNode root;

    public TypeUtils(RootNode rootNode) {
        this.root = rootNode;
    }

    public List<ArgType> getClassGenerics(ArgType type) {
        ClassNode classNode = this.root.resolveClass(type);
        if (classNode != null) {
            return classNode.getGenericTypeParameters();
        }
        ClspClass clsDetails = this.root.getClsp().getClsDetails(type);
        if (clsDetails == null || clsDetails.getTypeParameters().isEmpty()) {
            return Collections.emptyList();
        }
        List<ArgType> generics = clsDetails.getTypeParameters();
        return generics == null ? Collections.emptyList() : generics;
    }

    @Nullable
    public ClassTypeVarsAttr getClassTypeVars(ArgType type) {
        ClassNode classNode = this.root.resolveClass(type);
        if (classNode == null) {
            return null;
        }
        ClassTypeVarsAttr typeVarsAttr = classNode.get(AType.CLASS_TYPE_VARS);
        if (typeVarsAttr != null) {
            return typeVarsAttr;
        }
        return this.buildClassTypeVarsAttr(classNode);
    }

    public ArgType expandTypeVariables(ClassNode cls, ArgType type) {
        if (type.containsTypeVariable()) {
            this.expandTypeVar(cls, type, TypeUtils.getKnownTypeVarsAtClass(cls));
        }
        return type;
    }

    public ArgType expandTypeVariables(MethodNode mth, ArgType type) {
        if (type.containsTypeVariable()) {
            this.expandTypeVar(mth, type, this.getKnownTypeVarsAtMethod(mth));
        }
        return type;
    }

    private void expandTypeVar(NotificationAttrNode node, ArgType type, Collection<ArgType> typeVars) {
        if (typeVars.isEmpty()) {
            return;
        }
        boolean allExtendsEmpty = true;
        for (ArgType argType : typeVars) {
            if (!Utils.notEmpty(argType.getExtendTypes())) continue;
            allExtendsEmpty = false;
            break;
        }
        if (allExtendsEmpty) {
            return;
        }
        type.visitTypes(t -> {
            if (t.isGenericType()) {
                String typeVarName = t.getObject();
                for (ArgType typeVar : typeVars) {
                    if (!typeVar.getObject().equals(typeVarName)) continue;
                    t.setExtendTypes(typeVar.getExtendTypes());
                    return null;
                }
                node.addWarnComment("Unknown type variable: " + typeVarName + " in type: " + String.valueOf(type));
            }
            return null;
        });
    }

    public Set<ArgType> getKnownTypeVarsAtMethod(MethodNode mth) {
        MethodTypeVarsAttr typeVarsAttr = mth.get(AType.METHOD_TYPE_VARS);
        if (typeVarsAttr != null) {
            return typeVarsAttr.getTypeVars();
        }
        Set<ArgType> typeVars = TypeUtils.collectKnownTypeVarsAtMethod(mth);
        MethodTypeVarsAttr varsAttr = MethodTypeVarsAttr.build(typeVars);
        mth.addAttr(varsAttr);
        return varsAttr.getTypeVars();
    }

    private static Collection<ArgType> getKnownTypeVarsAtClass(ClassNode cls) {
        if (cls.isInner()) {
            HashSet<ArgType> typeVars = new HashSet<ArgType>(cls.getGenericTypeParameters());
            cls.visitParentClasses(parent -> typeVars.addAll(parent.getGenericTypeParameters()));
            return typeVars;
        }
        return cls.getGenericTypeParameters();
    }

    private static Set<ArgType> collectKnownTypeVarsAtMethod(MethodNode mth) {
        HashSet typeVars = new HashSet();
        typeVars.addAll(TypeUtils.getKnownTypeVarsAtClass(mth.getParentClass()));
        typeVars.addAll(mth.getTypeParameters());
        return typeVars.isEmpty() ? Collections.emptySet() : typeVars;
    }

    @Nullable
    public ArgType checkForUnknownTypeVars(MethodNode mth, ArgType checkType) {
        Set<ArgType> knownTypeVars = this.getKnownTypeVarsAtMethod(mth);
        return checkType.visitTypes(type -> {
            if (type.isGenericType() && !knownTypeVars.contains(type)) {
                return type;
            }
            return null;
        });
    }

    public boolean containsUnknownTypeVar(MethodNode mth, ArgType type) {
        return this.checkForUnknownTypeVars(mth, type) != null;
    }

    @Nullable
    public ArgType replaceClassGenerics(ArgType instanceType, ArgType typeWithGeneric) {
        return this.replaceClassGenerics(instanceType, instanceType, typeWithGeneric);
    }

    @Nullable
    public ArgType replaceClassGenerics(ArgType instanceType, ArgType genericSourceType, ArgType typeWithGeneric) {
        if (typeWithGeneric == null || genericSourceType == null) {
            return null;
        }
        Map<ArgType, ArgType> typeVarsMap = Collections.emptyMap();
        ClassTypeVarsAttr typeVars = this.getClassTypeVars(instanceType);
        if (typeVars != null) {
            typeVarsMap = TypeUtils.mergeTypeMaps(typeVarsMap, typeVars.getTypeVarsMapFor(genericSourceType));
        }
        typeVarsMap = TypeUtils.mergeTypeMaps(typeVarsMap, this.getTypeVariablesMapping(instanceType));
        for (ArgType outerType = instanceType.getOuterType(); outerType != null; outerType = outerType.getOuterType()) {
            typeVarsMap = TypeUtils.mergeTypeMaps(typeVarsMap, this.getTypeVariablesMapping(outerType));
        }
        return this.replaceTypeVariablesUsingMap(typeWithGeneric, typeVarsMap);
    }

    private static Map<ArgType, ArgType> mergeTypeMaps(Map<ArgType, ArgType> base, Map<ArgType, ArgType> addition) {
        if (base.isEmpty()) {
            return addition;
        }
        if (addition.isEmpty()) {
            return base;
        }
        HashMap<ArgType, ArgType> map = new HashMap<ArgType, ArgType>(base.size() + addition.size());
        for (Map.Entry<ArgType, ArgType> entry : base.entrySet()) {
            ArgType value = entry.getValue();
            ArgType type = addition.remove(value);
            if (type != null) {
                map.put(entry.getKey(), type);
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        map.putAll(addition);
        return map;
    }

    public Map<ArgType, ArgType> getTypeVariablesMapping(ArgType clsType) {
        if (!clsType.isGeneric()) {
            return Collections.emptyMap();
        }
        List<ArgType> typeParameters = this.root.getTypeUtils().getClassGenerics(clsType);
        if (typeParameters.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ArgType> actualTypes = clsType.getGenericTypes();
        if (Utils.isEmpty(actualTypes)) {
            return Collections.emptyMap();
        }
        int genericParamsCount = actualTypes.size();
        if (genericParamsCount != typeParameters.size()) {
            return Collections.emptyMap();
        }
        HashMap<ArgType, ArgType> replaceMap = new HashMap<ArgType, ArgType>(genericParamsCount);
        for (int i = 0; i < genericParamsCount; ++i) {
            ArgType actualType = actualTypes.get(i);
            ArgType typeVar = typeParameters.get(i);
            if (typeVar.getExtendTypes() != null) {
                typeVar = ArgType.genericType(typeVar.getObject());
            }
            replaceMap.put(typeVar, actualType);
        }
        return replaceMap;
    }

    public Map<ArgType, ArgType> getTypeVarMappingForInvoke(BaseInvokeNode invokeInsn) {
        IMethodDetails mthDetails = this.root.getMethodUtils().getMethodDetails(invokeInsn);
        if (mthDetails == null) {
            return Collections.emptyMap();
        }
        HashMap<ArgType, ArgType> map = new HashMap<ArgType, ArgType>(1 + invokeInsn.getArgsCount());
        TypeUtils.addTypeVarMapping(map, mthDetails.getReturnType(), invokeInsn.getResult());
        int argCount = Math.min(mthDetails.getArgTypes().size(), invokeInsn.getArgsCount());
        for (int i = 0; i < argCount; ++i) {
            TypeUtils.addTypeVarMapping(map, mthDetails.getArgTypes().get(i), invokeInsn.getArg(i));
        }
        return map;
    }

    private static void addTypeVarMapping(Map<ArgType, ArgType> map, ArgType typeVar, InsnArg arg) {
        if (arg == null || typeVar == null || !typeVar.isTypeKnown()) {
            return;
        }
        if (typeVar.isGenericType()) {
            map.put(typeVar, arg.getType());
        }
    }

    @Nullable
    public ArgType replaceMethodGenerics(BaseInvokeNode invokeInsn, IMethodDetails details, ArgType typeWithGeneric) {
        if (typeWithGeneric == null) {
            return null;
        }
        List<ArgType> methodArgTypes = details.getArgTypes();
        if (methodArgTypes.isEmpty()) {
            return null;
        }
        int firstArgOffset = invokeInsn.getFirstArgOffset();
        int argsCount = methodArgTypes.size();
        for (int i = 0; i < argsCount; ++i) {
            ArgType methodArgType = methodArgTypes.get(i);
            InsnArg insnArg = invokeInsn.getArg(i + firstArgOffset);
            ArgType insnType = insnArg.getType();
            if (!methodArgType.equals(typeWithGeneric)) continue;
            return insnType;
        }
        return null;
    }

    @Nullable
    public ArgType replaceTypeVariablesUsingMap(ArgType replaceType, Map<ArgType, ArgType> replaceMap) {
        if (replaceMap.isEmpty()) {
            return null;
        }
        if (replaceType.isGenericType()) {
            return replaceMap.get(replaceType);
        }
        if (replaceType.isArray()) {
            ArgType replaced = this.replaceTypeVariablesUsingMap(replaceType.getArrayElement(), replaceMap);
            if (replaced == null) {
                return null;
            }
            return ArgType.array(replaced);
        }
        ArgType wildcardType = replaceType.getWildcardType();
        if (wildcardType != null && wildcardType.containsTypeVariable()) {
            ArgType newWildcardType = this.replaceTypeVariablesUsingMap(wildcardType, replaceMap);
            if (newWildcardType == null) {
                return null;
            }
            return ArgType.wildcard(newWildcardType, replaceType.getWildcardBound());
        }
        if (replaceType.isGeneric()) {
            ArgType outerType = replaceType.getOuterType();
            if (outerType != null) {
                ArgType replacedOuter = this.replaceTypeVariablesUsingMap(outerType, replaceMap);
                if (replacedOuter == null) {
                    return null;
                }
                ArgType innerType = replaceType.getInnerType();
                ArgType replacedInner = this.replaceTypeVariablesUsingMap(innerType, replaceMap);
                return ArgType.outerGeneric(replacedOuter, replacedInner == null ? innerType : replacedInner);
            }
            List<ArgType> genericTypes = replaceType.getGenericTypes();
            if (Utils.notEmpty(genericTypes)) {
                List<ArgType> newTypes = Utils.collectionMap(genericTypes, t -> {
                    ArgType type = this.replaceTypeVariablesUsingMap((ArgType)t, replaceMap);
                    return type == null ? t : type;
                });
                return ArgType.generic(replaceType, newTypes);
            }
        }
        return null;
    }

    private ClassTypeVarsAttr buildClassTypeVarsAttr(ClassNode cls) {
        HashMap<String, Map<ArgType, ArgType>> map = new HashMap<String, Map<ArgType, ArgType>>();
        ArgType currentClsType = cls.getClassInfo().getType();
        map.put(currentClsType.getObject(), this.getTypeVariablesMapping(currentClsType));
        cls.visitSuperTypes((parent, type) -> {
            List<ArgType> sourceTypeVars;
            List<ArgType> currentVars = type.getGenericTypes();
            if (Utils.isEmpty(currentVars)) {
                return;
            }
            int varsCount = currentVars.size();
            if (varsCount == (sourceTypeVars = this.getClassGenerics((ArgType)type)).size()) {
                Map parentTypeMap = (Map)map.get(parent.getObject());
                HashMap<ArgType, ArgType> varsMap = new HashMap<ArgType, ArgType>(varsCount);
                for (int i = 0; i < varsCount; ++i) {
                    ArgType currentTypeVar = currentVars.get(i);
                    ArgType resultType = parentTypeMap != null ? (ArgType)parentTypeMap.get(currentTypeVar) : null;
                    varsMap.put(sourceTypeVars.get(i), resultType != null ? resultType : currentTypeVar);
                }
                map.put(type.getObject(), varsMap);
            }
        });
        List<ArgType> currentTypeVars = cls.getGenericTypeParameters();
        ClassTypeVarsAttr typeVarsAttr = new ClassTypeVarsAttr(currentTypeVars, map);
        cls.addAttr(typeVarsAttr);
        return typeVarsAttr;
    }

    public void visitSuperTypes(ArgType type, BiConsumer<ArgType, ArgType> consumer) {
        ClassNode cls = this.root.resolveClass(type);
        if (cls != null) {
            cls.visitSuperTypes(consumer);
        } else {
            ClspClass clspClass = this.root.getClsp().getClsDetails(type);
            if (clspClass != null) {
                for (ArgType superType : clspClass.getParents()) {
                    if (superType.equals(ArgType.OBJECT)) continue;
                    consumer.accept(type, superType);
                    this.visitSuperTypes(superType, consumer);
                }
            }
        }
    }
}

