/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.utils.Utils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JadxError
implements Comparable<JadxError> {
    private final String error;
    private final Throwable cause;

    public JadxError(String error, Throwable cause) {
        this.error = Objects.requireNonNull(error);
        this.cause = cause;
    }

    public String getError() {
        return this.error;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int compareTo(@NotNull JadxError o) {
        return this.error.compareTo(o.getError());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JadxError other = (JadxError)o;
        return this.error.equals(other.error);
    }

    public int hashCode() {
        return this.error.hashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("JadxError: ").append(this.error).append(' ');
        if (this.cause != null) {
            str.append(this.cause.getClass());
            str.append(':');
            str.append(this.cause.getMessage());
            str.append('\n');
            str.append(Utils.getStackTrace(this.cause));
        }
        return str.toString();
    }
}

