/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.utils;

import jadx.api.ICodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.core.dex.nodes.MethodNode;
import java.util.function.BiFunction;

public class CodeUtils {
    public static String getLineForPos(String code, int pos) {
        int start = CodeUtils.getLineStartForPos(code, pos);
        int end = CodeUtils.getLineEndForPos(code, pos);
        return code.substring(start, end);
    }

    public static int getLineStartForPos(String code, int pos) {
        int start = CodeUtils.getNewLinePosBefore(code, pos);
        return start == -1 ? 0 : start + 1;
    }

    public static int getLineEndForPos(String code, int pos) {
        int end = CodeUtils.getNewLinePosAfter(code, pos);
        return end == -1 ? code.length() : end;
    }

    public static int getNewLinePosAfter(String code, int startPos) {
        int prev;
        int pos = code.indexOf(10, startPos);
        if (pos != -1 && code.charAt(prev = pos - 1) == '\r') {
            return prev;
        }
        return pos;
    }

    public static int getNewLinePosBefore(String code, int startPos) {
        return code.lastIndexOf(10, startPos);
    }

    public static int getLineNumForPos(String code, int pos, String newLine) {
        int newLineLen = newLine.length();
        int line = 1;
        int prev = 0;
        int next;
        while ((next = code.indexOf(newLine, prev)) < pos) {
            prev = next + newLineLen;
            ++line;
        }
        return line;
    }

    public static String extractMethodCode(MethodNode mth, ICodeInfo codeInfo) {
        int end = CodeUtils.getMethodEnd(mth, codeInfo);
        if (end == -1) {
            return "";
        }
        int start = CodeUtils.getMethodStart(mth, codeInfo);
        if (end < start) {
            return "";
        }
        return codeInfo.getCodeStr().substring(start, end);
    }

    private static int getMethodStart(MethodNode mth, ICodeInfo codeInfo) {
        int pos = mth.getDefPosition();
        String newLineStr = mth.root().getArgs().getCodeNewLineStr();
        String emptyLine = newLineStr + newLineStr;
        int emptyLinePos = codeInfo.getCodeStr().lastIndexOf(emptyLine, pos);
        return emptyLinePos == -1 ? pos : emptyLinePos + emptyLine.length();
    }

    public static int getMethodEnd(MethodNode mth, ICodeInfo codeInfo) {
        if (!codeInfo.hasMetadata()) {
            return -1;
        }
        Integer end = codeInfo.getCodeMetadata().searchDown(mth.getDefPosition() + 1, new BiFunction<Integer, ICodeAnnotation, Integer>(){
            int nested = 0;

            @Override
            public Integer apply(Integer pos, ICodeAnnotation ann) {
                switch (ann.getAnnType()) {
                    case DECLARATION: {
                        ICodeNodeRef node = ((NodeDeclareRef)ann).getNode();
                        switch (node.getAnnType()) {
                            case CLASS: 
                            case METHOD: {
                                ++this.nested;
                            }
                        }
                        break;
                    }
                    case END: {
                        if (this.nested == 0) {
                            return pos;
                        }
                        --this.nested;
                    }
                }
                return null;
            }
        });
        return end == null ? -1 : end;
    }
}

