/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.IDecompileScheduler;
import jadx.api.JadxArgs;
import jadx.api.JadxArgsValidator;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.api.JavaVariable;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.metadata.annotations.VarRef;
import jadx.api.plugins.CustomResourcesLoader;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.events.IJadxEvents;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.JadxCodeInput;
import jadx.api.plugins.pass.JadxPass;
import jadx.api.plugins.pass.types.JadxAfterLoadPass;
import jadx.api.plugins.pass.types.JadxPassType;
import jadx.api.utils.tasks.ITaskExecutor;
import jadx.core.Jadx;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.SaveCode;
import jadx.core.export.ExportGradle;
import jadx.core.export.OutDirs;
import jadx.core.plugins.JadxPluginManager;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.events.JadxEventsImpl;
import jadx.core.utils.DecompilerScheduler;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.tasks.TaskExecutor;
import jadx.core.xmlgen.ResourcesSaver;
import jadx.zip.ZipReader;
import jadx.zip.security.IJadxZipSecurity;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxDecompiler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JadxDecompiler.class);
    private final JadxArgs args;
    private final JadxPluginManager pluginManager;
    private final List<ICodeLoader> loadedInputs = new ArrayList<ICodeLoader>();
    private final ZipReader zipReader;
    private RootNode root;
    private List<JavaClass> classes;
    private List<ResourceFile> resources;
    private final IDecompileScheduler decompileScheduler = new DecompilerScheduler();
    private final ResourcesLoader resourcesLoader;
    private final List<ICodeLoader> customCodeLoaders = new ArrayList<ICodeLoader>();
    private final List<CustomResourcesLoader> customResourcesLoaders = new ArrayList<CustomResourcesLoader>();
    private final Map<JadxPassType, List<JadxPass>> customPasses = new HashMap<JadxPassType, List<JadxPass>>();
    private final List<Closeable> closeableList = new ArrayList<Closeable>();
    private IJadxEvents events = new JadxEventsImpl();

    public JadxDecompiler() {
        this(new JadxArgs());
    }

    public JadxDecompiler(JadxArgs args) {
        this.args = Objects.requireNonNull(args);
        this.pluginManager = new JadxPluginManager(this);
        this.resourcesLoader = new ResourcesLoader(this);
        this.zipReader = new ZipReader((IJadxZipSecurity)args.getSecurity());
    }

    public void load() {
        this.reset();
        JadxArgsValidator.validate(this);
        LOG.info("loading ...");
        FileUtils.updateTempRootDir(this.args.getFilesGetter().getTempDir());
        this.loadPlugins();
        this.loadInputFiles();
        this.root = new RootNode(this);
        this.root.init();
        this.root.loadClasses(this.loadedInputs);
        this.root.loadResources(this.resourcesLoader, this.getResources());
        this.root.finishClassLoad();
        this.root.initClassPath();
        this.root.mergePasses(this.customPasses);
        this.root.runPreDecompileStage();
        this.root.initPasses();
        this.loadFinished();
    }

    public void reloadPasses() {
        LOG.info("reloading (passes only) ...");
        this.customPasses.clear();
        this.root.resetPasses();
        this.events.reset();
        this.loadPlugins();
        this.root.mergePasses(this.customPasses);
        this.root.restartVisitors();
        this.root.initPasses();
        this.loadFinished();
    }

    private void loadInputFiles() {
        this.loadedInputs.clear();
        List<Path> inputPaths = Utils.collectionMap(this.args.getInputFiles(), File::toPath);
        List<Path> inputFiles = FileUtils.expandDirs(inputPaths);
        long start = System.currentTimeMillis();
        for (PluginContext plugin : this.pluginManager.getResolvedPluginContexts()) {
            for (JadxCodeInput codeLoader : plugin.getCodeInputs()) {
                try {
                    ICodeLoader loader = codeLoader.loadFiles(inputFiles);
                    if (loader == null || loader.isEmpty()) continue;
                    this.loadedInputs.add(loader);
                }
                catch (Exception e) {
                    LOG.warn("Failed to load code for plugin: {}", (Object)plugin, (Object)e);
                }
            }
        }
        this.loadedInputs.addAll(this.customCodeLoaders);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded using {} inputs plugin in {} ms", (Object)this.loadedInputs.size(), (Object)(System.currentTimeMillis() - start));
        }
    }

    private void reset() {
        this.unloadPlugins();
        this.root = null;
        this.classes = null;
        this.resources = null;
        this.events.reset();
    }

    @Override
    public void close() {
        this.reset();
        this.closeAll(this.loadedInputs);
        this.closeAll(this.customCodeLoaders);
        this.closeAll(this.customResourcesLoaders);
        this.closeAll(this.closeableList);
        FileUtils.deleteDirIfExists(this.args.getFilesGetter().getTempDir());
        this.args.close();
        FileUtils.clearTempRootDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAll(List<? extends Closeable> list) {
        try {
            for (Closeable closeable : list) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    LOG.warn("Fail to close '{}'", (Object)closeable, (Object)e);
                }
            }
        }
        finally {
            list.clear();
        }
    }

    private void loadPlugins() {
        this.pluginManager.providesSuggestion("java-input", this.args.isUseDxInput() ? "java-convert" : "java-input");
        this.pluginManager.load(this.args.getPluginLoader());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved plugins: {}", this.pluginManager.getResolvedPluginContexts());
        }
        this.pluginManager.initResolved();
        if (LOG.isDebugEnabled()) {
            List passes = this.customPasses.values().stream().flatMap(Collection::stream).map(p -> p.getInfo().getName()).collect(Collectors.toList());
            LOG.debug("Loaded custom passes: {} {}", (Object)passes.size(), passes);
        }
    }

    private void unloadPlugins() {
        this.pluginManager.unloadResolved();
    }

    private void loadFinished() {
        LOG.debug("Load finished");
        List<JadxPass> list = this.customPasses.get(JadxAfterLoadPass.TYPE);
        if (list != null) {
            for (JadxPass pass : list) {
                ((JadxAfterLoadPass)pass).init(this);
            }
        }
    }

    public void registerPlugin(JadxPlugin plugin) {
        this.pluginManager.register(plugin);
    }

    public static String getVersion() {
        return Jadx.getVersion();
    }

    public void save() {
        this.save(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    public void save(int intervalInMillis, ProgressListener listener) {
        try {
            ITaskExecutor tasks = this.getSaveTaskExecutor();
            tasks.execute();
            long total = tasks.getTasksCount();
            while (tasks.isRunning()) {
                listener.progress(tasks.getProgress(), total);
                Thread.sleep(intervalInMillis);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Save interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void saveSources() {
        this.save(true, false);
    }

    public void saveResources() {
        this.save(false, true);
    }

    private void save(boolean saveSources, boolean saveResources) {
        TaskExecutor executor = this.getSaveTasks(saveSources, saveResources);
        executor.execute();
        executor.awaitTermination();
    }

    public ITaskExecutor getSaveTaskExecutor() {
        return this.getSaveTasks(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    @Deprecated(forRemoval=true)
    public ExecutorService getSaveExecutor() {
        ITaskExecutor executor = this.getSaveTaskExecutor();
        executor.execute();
        return executor.getInternalExecutor();
    }

    @Deprecated(forRemoval=true)
    public List<Runnable> getSaveTasks() {
        return Collections.singletonList(this::save);
    }

    private TaskExecutor getSaveTasks(boolean saveSources, boolean saveResources) {
        OutDirs outDirs;
        ExportGradle gradleExport;
        if (this.root == null) {
            throw new JadxRuntimeException("No loaded files");
        }
        if (this.args.getExportGradleType() != null) {
            gradleExport = new ExportGradle(this.root, this.args.getOutDir(), this.getResources());
            outDirs = gradleExport.init();
        } else {
            gradleExport = null;
            outDirs = new OutDirs(this.args.getOutDirSrc(), this.args.getOutDirRes());
            outDirs.makeDirs();
        }
        TaskExecutor executor = new TaskExecutor();
        executor.setThreadsCount(this.args.getThreadsCount());
        if (saveResources) {
            this.appendResourcesSaveTasks(executor, outDirs.getResOutDir());
        }
        if (saveSources) {
            this.appendSourcesSave(executor, outDirs.getSrcOutDir());
        }
        if (gradleExport != null) {
            executor.addSequentialTask(gradleExport::generateGradleFiles);
        }
        return executor;
    }

    private void appendResourcesSaveTasks(ITaskExecutor executor, File outDir) {
        if (this.args.isSkipFilesSave()) {
            return;
        }
        for (ResourceFile resourceFile : this.getResources()) {
            if (resourceFile.getType() != ResourceType.MANIFEST) continue;
            new ResourcesSaver(this, outDir, resourceFile).run();
            break;
        }
        Set inputFileNames = this.args.getInputFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        Set<String> codeSources = this.collectCodeSources();
        ArrayList<ResourcesSaver> tasks = new ArrayList<ResourcesSaver>();
        for (ResourceFile resourceFile : this.getResources()) {
            ResourceType resType = resourceFile.getType();
            if (resType == ResourceType.MANIFEST) continue;
            String resOriginalName = resourceFile.getOriginalName();
            if (resType != ResourceType.ARSC && inputFileNames.contains(resOriginalName) || codeSources.contains(resOriginalName)) continue;
            tasks.add(new ResourcesSaver(this, outDir, resourceFile));
        }
        executor.addParallelTasks(tasks);
    }

    private Set<String> collectCodeSources() {
        HashSet<String> set = new HashSet<String>();
        for (ClassNode cls : this.root.getClasses(true)) {
            int endIdx;
            if (cls.getClsData() == null) continue;
            String inputFileName = cls.getInputFileName();
            if (inputFileName.endsWith(".class") && (endIdx = inputFileName.lastIndexOf(58)) != -1) {
                int startIdx = inputFileName.lastIndexOf(58, endIdx - 1) + 1;
                inputFileName = inputFileName.substring(startIdx, endIdx);
            }
            set.add(inputFileName);
        }
        return set;
    }

    private void appendSourcesSave(ITaskExecutor executor, File outDir) {
        List<List<JavaClass>> batches;
        List<JavaClass> classes = this.getClasses();
        List<JavaClass> processQueue = this.filterClasses(classes);
        try {
            batches = this.decompileScheduler.buildBatches(processQueue);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Decompilation batches build failed", e);
        }
        ArrayList<Runnable> decompileTasks = new ArrayList<Runnable>(batches.size());
        for (List<JavaClass> decompileBatch : batches) {
            decompileTasks.add(() -> {
                for (JavaClass cls : decompileBatch) {
                    try {
                        ClassNode clsNode = cls.getClassNode();
                        ICodeInfo code = clsNode.getCode();
                        SaveCode.save(outDir, clsNode, code);
                    }
                    catch (Exception e) {
                        LOG.error("Error saving class: {}", (Object)cls, (Object)e);
                    }
                }
            });
        }
        executor.addParallelTasks(decompileTasks);
    }

    private List<JavaClass> filterClasses(List<JavaClass> classes) {
        Predicate<String> classFilter = this.args.getClassFilter();
        ArrayList<JavaClass> list = new ArrayList<JavaClass>(classes.size());
        for (JavaClass cls : classes) {
            ClassNode clsNode = cls.getClassNode();
            if (clsNode.contains(AFlag.DONT_GENERATE)) continue;
            if (classFilter != null && !classFilter.test(clsNode.getClassInfo().getFullName())) {
                if (this.args.isIncludeDependencies()) continue;
                clsNode.add(AFlag.DONT_GENERATE);
                continue;
            }
            list.add(cls);
        }
        return list;
    }

    public List<JavaClass> getClasses() {
        if (this.root == null) {
            return Collections.emptyList();
        }
        if (this.classes == null) {
            List<ClassNode> classNodeList = this.root.getClasses();
            ArrayList<JavaClass> clsList = new ArrayList<JavaClass>(classNodeList.size());
            for (ClassNode classNode : classNodeList) {
                if (classNode.contains(AFlag.DONT_GENERATE) || classNode.getClassInfo().isInner()) continue;
                clsList.add(this.convertClassNode(classNode));
            }
            this.classes = Collections.unmodifiableList(clsList);
        }
        return this.classes;
    }

    public List<JavaClass> getClassesWithInners() {
        return Utils.collectionMap(this.root.getClasses(), this::convertClassNode);
    }

    public synchronized List<ResourceFile> getResources() {
        if (this.resources == null) {
            if (this.root == null) {
                return Collections.emptyList();
            }
            this.resources = this.resourcesLoader.load(this.root);
        }
        return this.resources;
    }

    public List<JavaPackage> getPackages() {
        return Utils.collectionMap(this.root.getPackages(), this::convertPackageNode);
    }

    public int getErrorsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getErrorCount();
    }

    public int getWarnsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getWarnsCount();
    }

    public void printErrorsReport() {
        if (this.root == null) {
            return;
        }
        this.root.getClsp().printMissingClasses();
        this.root.getErrorsCounter().printReport();
    }

    @ApiStatus.Internal
    public RootNode getRoot() {
        return this.root;
    }

    @ApiStatus.Internal
    synchronized JavaClass convertClassNode(ClassNode cls) {
        JavaClass javaClass = cls.getJavaNode();
        if (javaClass == null) {
            javaClass = cls.isInner() ? new JavaClass(cls, this.convertClassNode(cls.getParentClass())) : new JavaClass(cls, this);
            cls.setJavaNode(javaClass);
        }
        return javaClass;
    }

    @ApiStatus.Internal
    synchronized JavaField convertFieldNode(FieldNode fld) {
        JavaField javaField = fld.getJavaNode();
        if (javaField == null) {
            JavaClass parentCls = this.convertClassNode(fld.getParentClass());
            javaField = new JavaField(parentCls, fld);
            fld.setJavaNode(javaField);
        }
        return javaField;
    }

    @ApiStatus.Internal
    synchronized JavaMethod convertMethodNode(MethodNode mth) {
        JavaMethod javaMethod = mth.getJavaNode();
        if (javaMethod == null) {
            javaMethod = new JavaMethod(this.convertClassNode(mth.getParentClass()), mth);
            mth.setJavaNode(javaMethod);
        }
        return javaMethod;
    }

    @ApiStatus.Internal
    synchronized JavaPackage convertPackageNode(PackageNode pkg) {
        JavaPackage foundPkg = pkg.getJavaNode();
        if (foundPkg != null) {
            return foundPkg;
        }
        List<JavaClass> clsList = Utils.collectionMap(pkg.getClasses(), this::convertClassNode);
        int subPkgsCount = pkg.getSubPackages().size();
        ArrayList<JavaPackage> subPkgs = subPkgsCount == 0 ? Collections.emptyList() : new ArrayList<JavaPackage>(subPkgsCount);
        JavaPackage javaPkg = new JavaPackage(pkg, clsList, subPkgs);
        if (subPkgsCount != 0) {
            for (PackageNode subPackage : pkg.getSubPackages()) {
                subPkgs.add(this.convertPackageNode(subPackage));
            }
        }
        pkg.setJavaNode(javaPkg);
        return javaPkg;
    }

    @Nullable
    public JavaClass searchJavaClassByOrigFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().map(this::convertClassNode).orElse(null);
    }

    @Nullable
    public ClassNode searchClassNodeByOrigFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().orElse(null);
    }

    @Nullable
    public JavaClass searchJavaClassOrItsParentByOrigFullName(String fullName) {
        ClassNode node = this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().orElse(null);
        if (node != null) {
            if (node.contains(AFlag.DONT_GENERATE)) {
                return this.convertClassNode(node.getTopParentClass());
            }
            return this.convertClassNode(node);
        }
        return null;
    }

    @Nullable
    public JavaClass searchJavaClassByAliasFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getAliasFullName().equals(fullName)).findFirst().map(this::convertClassNode).orElse(null);
    }

    @Nullable
    public JavaNode getJavaNodeByRef(ICodeNodeRef ann) {
        return this.getJavaNodeByCodeAnnotation(null, ann);
    }

    @Nullable
    public JavaNode getJavaNodeByCodeAnnotation(@Nullable ICodeInfo codeInfo, @Nullable ICodeAnnotation ann) {
        if (ann == null) {
            return null;
        }
        switch (ann.getAnnType()) {
            case CLASS: {
                return this.convertClassNode((ClassNode)ann);
            }
            case METHOD: {
                return this.convertMethodNode((MethodNode)ann);
            }
            case FIELD: {
                return this.convertFieldNode((FieldNode)ann);
            }
            case PKG: {
                return this.convertPackageNode((PackageNode)ann);
            }
            case DECLARATION: {
                return this.getJavaNodeByCodeAnnotation(codeInfo, ((NodeDeclareRef)ann).getNode());
            }
            case VAR: {
                return this.resolveVarNode((VarNode)ann);
            }
            case VAR_REF: {
                return this.resolveVarRef(codeInfo, (VarRef)ann);
            }
            case OFFSET: {
                return null;
            }
        }
        throw new JadxRuntimeException("Unknown annotation type: " + String.valueOf((Object)ann.getAnnType()) + ", class: " + String.valueOf(ann.getClass()));
    }

    private JavaVariable resolveVarNode(VarNode varNode) {
        JavaMethod javaNode = this.convertMethodNode(varNode.getMth());
        return new JavaVariable(javaNode, varNode);
    }

    @Nullable
    private JavaVariable resolveVarRef(ICodeInfo codeInfo, VarRef varRef) {
        ICodeNodeRef nodeRef;
        if (codeInfo == null) {
            throw new JadxRuntimeException("Missing code info for resolve VarRef: " + String.valueOf(varRef));
        }
        ICodeAnnotation varNodeAnn = codeInfo.getCodeMetadata().getAt(varRef.getRefPos());
        if (varNodeAnn != null && varNodeAnn.getAnnType() == ICodeAnnotation.AnnType.DECLARATION && (nodeRef = ((NodeDeclareRef)varNodeAnn).getNode()).getAnnType() == ICodeAnnotation.AnnType.VAR) {
            return this.resolveVarNode((VarNode)nodeRef);
        }
        return null;
    }

    List<JavaNode> convertNodes(Collection<? extends ICodeNodeRef> nodesList) {
        return nodesList.stream().map(this::getJavaNodeByRef).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public JavaNode getJavaNodeAtPosition(ICodeInfo codeInfo, int pos) {
        ICodeAnnotation ann = codeInfo.getCodeMetadata().getAt(pos);
        return this.getJavaNodeByCodeAnnotation(codeInfo, ann);
    }

    @Nullable
    public JavaNode getClosestJavaNode(ICodeInfo codeInfo, int pos) {
        ICodeAnnotation ann = codeInfo.getCodeMetadata().getClosestUp(pos);
        return this.getJavaNodeByCodeAnnotation(codeInfo, ann);
    }

    @Nullable
    public JavaNode getEnclosingNode(ICodeInfo codeInfo, int pos) {
        ICodeNodeRef obj = codeInfo.getCodeMetadata().getNodeAt(pos);
        if (obj == null) {
            return null;
        }
        return this.getJavaNodeByRef(obj);
    }

    public void reloadCodeData() {
        this.root.notifyCodeDataListeners();
    }

    public JadxArgs getArgs() {
        return this.args;
    }

    public JadxPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public IDecompileScheduler getDecompileScheduler() {
        return this.decompileScheduler;
    }

    public IJadxEvents events() {
        return this.events;
    }

    public void setEventsImpl(IJadxEvents eventsImpl) {
        this.events = eventsImpl;
    }

    public void addCustomCodeLoader(ICodeLoader customCodeLoader) {
        this.customCodeLoaders.add(customCodeLoader);
    }

    public List<ICodeLoader> getCustomCodeLoaders() {
        return this.customCodeLoaders;
    }

    public void addCustomResourcesLoader(CustomResourcesLoader loader) {
        if (this.customResourcesLoaders.contains(loader)) {
            return;
        }
        this.customResourcesLoaders.add(loader);
    }

    public List<CustomResourcesLoader> getCustomResourcesLoaders() {
        return this.customResourcesLoaders;
    }

    public void addCustomPass(JadxPass pass) {
        this.customPasses.computeIfAbsent(pass.getPassType(), l -> new ArrayList()).add(pass);
    }

    public ResourcesLoader getResourcesLoader() {
        return this.resourcesLoader;
    }

    public ZipReader getZipReader() {
        return this.zipReader;
    }

    public void addCloseable(Closeable closeable) {
        this.closeableList.add(closeable);
    }

    public String toString() {
        return "jadx decompiler " + JadxDecompiler.getVersion();
    }

    public static interface ProgressListener {
        public void progress(long var1, long var3);
    }
}

