/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.ResourcesLoader;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.android.AndroidResourcesMap;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.XMLChar;
import jadx.core.xmlgen.XmlDeobf;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryXMLParser
extends CommonBinaryParser {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryXMLParser.class);
    private final RootNode rootNode;
    private final ManifestAttributes manifestAttributes;
    private final boolean attrNewLine;
    private final Map<Integer, String> resNames;
    private Map<String, String> nsMap;
    private Set<String> nsMapGenerated;
    private Set<String> definedNamespaces;
    private final Map<String, String> tagAttrDeobfNames = new HashMap<String, String>();
    private ICodeWriter writer;
    private BinaryXMLStrings strings;
    private String currentTag = "ERROR";
    private boolean firstElement;
    private ValuesParser valuesParser;
    private boolean isLastEnd = true;
    private boolean isOneLine = true;
    private int namespaceDepth = 0;
    @Nullable
    private int[] resourceIds;
    private String appPackageName;
    private Map<String, ClassNode> classNameCache;

    public BinaryXMLParser(RootNode rootNode) {
        this.rootNode = rootNode;
        this.manifestAttributes = rootNode.initManifestAttributes();
        this.attrNewLine = !rootNode.getArgs().isSkipXmlPrettyPrint();
        try {
            ConstStorage constStorage = rootNode.getConstValues();
            this.resNames = constStorage.getResourcesNames();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("BinaryXMLParser init error", e);
        }
    }

    public synchronized ICodeInfo parse(InputStream inputStream) throws IOException {
        this.resourceIds = null;
        this.is = new ParserStream(inputStream);
        if (!this.isBinaryXml()) {
            return ResourcesLoader.loadToCodeWriter(inputStream);
        }
        this.nsMapGenerated = new HashSet<String>();
        this.nsMap = new HashMap<String, String>();
        this.definedNamespaces = new HashSet<String>();
        this.writer = this.rootNode.makeCodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.firstElement = true;
        this.decode();
        this.nsMap = null;
        this.definedNamespaces = null;
        ICodeInfo codeInfo = this.writer.finish();
        this.classNameCache = null;
        return codeInfo;
    }

    private boolean isBinaryXml() throws IOException {
        this.is.mark(4);
        int v = this.is.readInt16();
        int h = this.is.readInt16();
        if (h == 8) {
            return true;
        }
        this.is.reset();
        return false;
    }

    void decode() throws IOException {
        int size = this.is.readInt32();
        block10: while (this.is.getPos() < (long)size) {
            int type = this.is.readInt16();
            switch (type) {
                case 0: {
                    continue block10;
                }
                case 1: {
                    this.strings = this.parseStringPoolNoType();
                    this.valuesParser = new ValuesParser(this.strings, this.resNames);
                    continue block10;
                }
                case 384: {
                    this.parseResourceMap();
                    continue block10;
                }
                case 256: {
                    this.parseNameSpace();
                    continue block10;
                }
                case 260: {
                    this.parseCData();
                    continue block10;
                }
                case 257: {
                    this.parseNameSpaceEnd();
                    continue block10;
                }
                case 258: {
                    this.parseElement();
                    continue block10;
                }
                case 259: {
                    this.parseElementEnd();
                    continue block10;
                }
            }
            if (this.namespaceDepth == 0) {
                return;
            }
            this.die("Type: 0x" + Integer.toHexString(type) + " not yet implemented");
        }
    }

    private void parseResourceMap() throws IOException {
        if (this.is.readInt16() != 8) {
            this.die("Header size of resmap is not 8!");
        }
        int size = this.is.readInt32();
        int len = (size - 8) / 4;
        this.resourceIds = new int[len];
        for (int i = 0; i < len; ++i) {
            this.resourceIds[i] = this.is.readInt32();
        }
    }

    private void parseNameSpace() throws IOException {
        int headerSize = this.is.readInt16();
        if (headerSize > 16) {
            LOG.warn("Invalid namespace header");
        } else if (headerSize < 16) {
            this.die("NAMESPACE header is not 0x10 big");
        }
        int size = this.is.readInt32();
        if (size > 24) {
            LOG.warn("Invalid namespace size");
        } else if (size < 24) {
            this.die("NAMESPACE header chunk is not 0x18 big");
        }
        int beginLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int beginPrefix = this.is.readInt32();
        int beginURI = this.is.readInt32();
        this.is.skip(headerSize - 16);
        String nsKey = this.getString(beginURI);
        String nsValue = this.getString(beginPrefix);
        if (StringUtils.notBlank(nsKey) && !this.nsMap.containsValue(nsValue)) {
            this.nsMap.putIfAbsent(nsKey, nsValue);
        }
        ++this.namespaceDepth;
    }

    private void parseNameSpaceEnd() throws IOException {
        int headerSize = this.is.readInt16();
        if (headerSize > 16) {
            LOG.warn("Invalid namespace end");
        } else if (headerSize < 16) {
            this.die("NAMESPACE end is not 0x10 big");
        }
        int dataSize = this.is.readInt32();
        if (dataSize != 24) {
            LOG.warn("Invalid namespace end size");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int endPrefix = this.is.readInt32();
        int endURI = this.is.readInt32();
        this.is.skip(headerSize - 16);
        --this.namespaceDepth;
        String nsKey = this.getString(endURI);
        String nsValue = this.getString(endPrefix);
        if (StringUtils.notBlank(nsKey) && !this.nsMap.containsValue(nsValue)) {
            this.nsMap.putIfAbsent(nsKey, nsValue);
        }
    }

    private void parseCData() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("CDATA header is not 0x10");
        }
        if (this.is.readInt32() != 28) {
            this.die("CDATA header chunk is not 0x1C");
        }
        int lineNumber = this.is.readInt32();
        this.is.skip(4L);
        int strIndex = this.is.readInt32();
        String str = this.getString(strIndex);
        if (!this.isLastEnd) {
            this.isLastEnd = true;
            this.writer.add('>');
        }
        this.writer.attachSourceLine(lineNumber);
        String escapedStr = StringUtils.escapeXML(str);
        this.writer.add(escapedStr);
        long size = this.is.readInt16();
        this.is.skip(size - 2L);
    }

    private void parseElement() throws IOException {
        int attributeSize;
        if (this.firstElement) {
            this.firstElement = false;
        } else {
            this.writer.incIndent();
        }
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT HEADER SIZE is not 0x10");
        }
        long startPos = this.is.getPos();
        int elementSize = this.is.readInt32();
        int elementBegLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int startNS = this.is.readInt32();
        int startNSName = this.is.readInt32();
        if (!this.isLastEnd && !"ERROR".equals(this.currentTag)) {
            this.writer.add('>');
        }
        this.isOneLine = true;
        this.isLastEnd = false;
        this.currentTag = this.deobfClassName(this.getString(startNSName));
        this.currentTag = this.getValidTagAttributeName(this.currentTag);
        this.writer.startLine('<').add(this.currentTag);
        this.writer.attachSourceLine(elementBegLineNumber);
        int attributeStart = this.is.readInt16();
        if (attributeStart != 20) {
            this.die("startNS's attributeStart is not 0x14");
        }
        if ((attributeSize = this.is.readInt16()) < 20) {
            this.die("startNS's attributeSize is less than 0x14");
        }
        int attributeCount = this.is.readInt16();
        int idIndex = this.is.readInt16();
        int classIndex = this.is.readInt16();
        int styleIndex = this.is.readInt16();
        if ("manifest".equals(this.currentTag) || this.definedNamespaces.size() != this.nsMap.size()) {
            for (Map.Entry<String, String> entry : this.nsMap.entrySet()) {
                if (this.definedNamespaces.contains(entry.getKey())) continue;
                this.definedNamespaces.add(entry.getKey());
                String nsValue = this.getValidTagAttributeName(entry.getValue());
                this.writer.add(" xmlns");
                if (nsValue != null && !nsValue.trim().isEmpty()) {
                    this.writer.add(':');
                    this.writer.add(nsValue);
                }
                this.writer.add("=\"").add(StringUtils.escapeXML(entry.getKey())).add('\"');
            }
        }
        HashSet<String> attrCache = new HashSet<String>();
        boolean attrNewLine = attributeCount != 1 && this.attrNewLine;
        for (int i = 0; i < attributeCount; ++i) {
            this.parseAttribute(i, attrNewLine, attrCache, attributeSize);
        }
        long endPos = this.is.getPos();
        if (endPos - startPos + 4L < (long)elementSize) {
            this.is.skip((long)elementSize - (endPos - startPos + 4L));
        }
    }

    private void parseAttribute(int i, boolean newLine, Set<String> attrCache, int attributeSize) throws IOException {
        String attrFullName;
        int attributeNS = this.is.readInt32();
        int attributeName = this.is.readInt32();
        int attributeRawValue = this.is.readInt32();
        this.is.skip(3L);
        int attrValDataType = this.is.readInt8();
        int attrValData = this.is.readInt32();
        this.is.skip(attributeSize - 20);
        String shortNsName = null;
        if (attributeNS != -1) {
            shortNsName = this.getAttributeNS(attributeNS, newLine);
        }
        String attrName = this.getValidTagAttributeName(this.getAttributeName(attributeName));
        String string = attrFullName = shortNsName != null ? shortNsName + ":" + attrName : attrName;
        if (XmlDeobf.isDuplicatedAttr(attrFullName, attrCache)) {
            return;
        }
        if (newLine) {
            this.writer.startLine().addIndent();
        } else {
            this.writer.add(' ');
        }
        this.writer.add(attrFullName).add("=\"");
        String decodedAttr = this.manifestAttributes.decode(attrFullName, attrValData);
        if (decodedAttr != null) {
            this.memorizePackageName(attrName, decodedAttr);
            if (this.isDeobfCandidateAttr(attrFullName)) {
                decodedAttr = this.deobfClassName(decodedAttr);
            }
            this.attachClassNode(this.writer, attrName, decodedAttr);
            this.writer.add(StringUtils.escapeXML(decodedAttr));
        } else {
            this.decodeAttribute(attributeNS, attrValDataType, attrValData, attrFullName);
        }
        if (shortNsName != null && shortNsName.equals("android")) {
            if (attrName.equals("pathData")) {
                this.rootNode.getGradleInfoStorage().setVectorPathData(true);
            } else if (attrName.equals("fillType")) {
                this.rootNode.getGradleInfoStorage().setVectorFillType(true);
            }
        }
        this.writer.add('\"');
    }

    private String getAttributeNS(int attributeNS, boolean newLine) {
        String attrName;
        String attrUrl = this.getString(attributeNS);
        if (attrUrl == null || attrUrl.isEmpty()) {
            if (BinaryXMLParser.isResInternalId(attributeNS)) {
                return null;
            }
            attrUrl = "http://schemas.android.com/apk/res/android";
        }
        if ((attrName = this.nsMap.get(attrUrl)) == null) {
            attrName = this.generateNameForNS(attrUrl, newLine);
        }
        return attrName;
    }

    private String generateNameForNS(String attrUrl, boolean newLine) {
        Object attrName;
        if ("http://schemas.android.com/apk/res/android".equals(attrUrl)) {
            attrName = "android";
            this.nsMap.put("http://schemas.android.com/apk/res/android", (String)attrName);
        } else {
            int i = 1;
            while (true) {
                if (!this.nsMapGenerated.contains(attrName = "ns" + i) && !this.nsMap.containsValue(attrName)) {
                    this.nsMapGenerated.add((String)attrName);
                    break;
                }
                ++i;
            }
        }
        if (newLine) {
            this.writer.startLine().addIndent();
        } else {
            this.writer.add(' ');
        }
        this.writer.add("xmlns:").add((String)attrName).add("=\"").add(attrUrl).add("\" ");
        return attrName;
    }

    private String getAttributeName(int id) {
        int resId;
        String str;
        if (this.resourceIds != null && 0 <= id && id < this.resourceIds.length && (str = AndroidResourcesMap.getResName(resId = this.resourceIds[id])) != null) {
            int typeEnd = str.indexOf(47);
            if (typeEnd != -1) {
                return str.substring(typeEnd + 1);
            }
            return str;
        }
        String str2 = this.getString(id);
        if (str2 == null || str2.isEmpty()) {
            return "NOT_FOUND_0x" + Integer.toHexString(id);
        }
        return str2;
    }

    private String getString(int strId) {
        if (0 <= strId && strId < this.strings.size()) {
            return this.strings.get(strId);
        }
        return "NOT_FOUND_STR_0x" + Integer.toHexString(strId);
    }

    private void decodeAttribute(int attributeNS, int attrValDataType, int attrValData, String attrFullName) {
        if (attrValDataType == 1) {
            String resName = this.resNames.get(attrValData);
            if (resName != null) {
                this.writer.add('@');
                if (resName.startsWith("id/")) {
                    this.writer.add('+');
                }
                this.writer.add(resName);
            } else {
                String androidResName = AndroidResourcesMap.getResName(attrValData);
                if (androidResName != null) {
                    this.writer.add("@android:").add(androidResName);
                } else if (attrValData == 0) {
                    this.writer.add("@null");
                } else {
                    this.writer.add("0x").add(Integer.toHexString(attrValData));
                }
            }
        } else {
            String str;
            try {
                str = this.valuesParser.decodeValue(attrValDataType, attrValData);
            }
            catch (JadxRuntimeException e) {
                LOG.error("Failed to decode attribute value of \"{}\"", (Object)attrFullName, (Object)e);
                str = null;
            }
            this.memorizePackageName(attrFullName, str);
            if (this.isDeobfCandidateAttr(attrFullName)) {
                str = this.deobfClassName(str);
            }
            this.attachClassNode(this.writer, attrFullName, str);
            this.writer.add(str != null ? StringUtils.escapeXML(str) : "null");
        }
    }

    private void parseElementEnd() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT END header is not 0x10");
        }
        if (this.is.readInt32() != 24) {
            this.die("ELEMENT END header chunk is not 0x18 big");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int elementNS = this.is.readInt32();
        int elementNameId = this.is.readInt32();
        String elemName = this.deobfClassName(this.getString(elementNameId));
        if (this.currentTag.equals(elemName = this.getValidTagAttributeName(elemName)) && this.isOneLine && !this.isLastEnd) {
            this.writer.add("/>");
        } else {
            this.writer.startLine("</");
            this.writer.attachSourceLine(endLineNumber);
            this.writer.add(elemName).add('>');
        }
        this.isLastEnd = true;
        if (this.writer.getIndent() != 0) {
            this.writer.decIndent();
        }
    }

    private String getValidTagAttributeName(String originalName) {
        String generated;
        if (XMLChar.isValidName(originalName)) {
            return originalName;
        }
        if (this.tagAttrDeobfNames.containsKey(originalName)) {
            return this.tagAttrDeobfNames.get(originalName);
        }
        while (this.tagAttrDeobfNames.containsValue(generated = BinaryXMLParser.generateTagAttrName())) {
        }
        this.tagAttrDeobfNames.put(originalName, generated);
        return generated;
    }

    private static String generateTagAttrName() {
        int length = 6;
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 6; ++i) {
            sb.append((char)(r.nextInt(26) + 97));
        }
        return sb.toString();
    }

    private void attachClassNode(ICodeWriter writer, String attrFullName, String clsName) {
        ClassNode classNode;
        if (!writer.isMetadataSupported()) {
            return;
        }
        if (clsName == null || !attrFullName.equals("android:name")) {
            return;
        }
        Object clsFullName = clsName.startsWith(".") ? this.appPackageName + clsName : clsName;
        if (this.classNameCache == null) {
            this.classNameCache = this.rootNode.buildFullAliasClassCache();
        }
        if ((classNode = this.classNameCache.get(clsFullName)) != null) {
            writer.attachAnnotation(classNode);
        }
    }

    private String deobfClassName(String className) {
        String newName = XmlDeobf.deobfClassName(this.rootNode, className, this.appPackageName);
        if (newName != null) {
            return newName;
        }
        return className;
    }

    private boolean isDeobfCandidateAttr(String attrFullName) {
        return "android:name".equals(attrFullName);
    }

    private void memorizePackageName(String attrFullName, String attrValue) {
        if ("manifest".equals(this.currentTag) && "package".equals(attrFullName)) {
            this.appPackageName = attrValue;
        }
    }
}

