/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.export;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.dex.nodes.RootNode;
import jadx.core.export.ExportGradleType;
import jadx.core.export.OutDirs;
import jadx.core.export.gen.AndroidGradleGenerator;
import jadx.core.export.gen.IExportGradleGenerator;
import jadx.core.export.gen.SimpleJavaGradleGenerator;
import jadx.core.utils.android.AndroidManifestParser;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportGradle {
    private static final Logger LOG = LoggerFactory.getLogger(ExportGradle.class);
    private final RootNode root;
    private final File projectDir;
    private final List<ResourceFile> resources;
    private IExportGradleGenerator generator;

    public ExportGradle(RootNode root, File projectDir, List<ResourceFile> resources) {
        this.root = root;
        this.projectDir = projectDir;
        this.resources = resources;
    }

    public OutDirs init() {
        ExportGradleType exportType = this.getExportGradleType();
        LOG.info("Export Gradle project using '{}' template", (Object)exportType);
        switch (exportType) {
            case ANDROID_APP: 
            case ANDROID_LIBRARY: {
                this.generator = new AndroidGradleGenerator(this.root, this.projectDir, this.resources, exportType);
                break;
            }
            case SIMPLE_JAVA: {
                this.generator = new SimpleJavaGradleGenerator(this.root, this.projectDir, this.resources);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unexpected export type: " + exportType);
            }
        }
        this.generator.init();
        OutDirs outDirs = this.generator.getOutDirs();
        outDirs.makeDirs();
        return outDirs;
    }

    private ExportGradleType getExportGradleType() {
        ExportGradleType argsExportType = this.root.getArgs().getExportGradleType();
        ExportGradleType detectedType = ExportGradle.detectExportType(this.root, this.resources);
        if (argsExportType == null || argsExportType == ExportGradleType.AUTO || argsExportType == detectedType) {
            return detectedType;
        }
        return argsExportType;
    }

    public static ExportGradleType detectExportType(RootNode root, List<ResourceFile> resources) {
        ResourceFile androidManifest = AndroidManifestParser.getAndroidManifest(resources);
        if (androidManifest != null) {
            if (resources.stream().anyMatch(r -> r.getOriginalName().equals("classes.jar"))) {
                return ExportGradleType.ANDROID_LIBRARY;
            }
            if (resources.stream().anyMatch(r -> r.getType() == ResourceType.ARSC)) {
                return ExportGradleType.ANDROID_APP;
            }
        }
        return ExportGradleType.SIMPLE_JAVA;
    }

    public void generateGradleFiles() {
        this.generator.generateFiles();
    }
}

