/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.JadxArgs;
import jadx.api.deobf.IAliasProvider;
import jadx.api.deobf.IRenameCondition;
import jadx.core.deobf.DeobfPresets;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.exceptions.JadxException;

public class DeobfuscatorVisitor
extends AbstractVisitor {
    @Override
    public void init(RootNode root) throws JadxException {
        JadxArgs args = root.getArgs();
        if (!args.isDeobfuscationOn()) {
            return;
        }
        DeobfPresets mapping = DeobfPresets.build(root);
        if (args.getGeneratedRenamesMappingFileMode().shouldRead() && mapping.load()) {
            mapping.apply(root);
        }
        IAliasProvider aliasProvider = args.getAliasProvider();
        IRenameCondition renameCondition = args.getRenameCondition();
        mapping.initIndexes(aliasProvider);
        DeobfuscatorVisitor.process(root, renameCondition, aliasProvider);
    }

    public static void process(RootNode root, IRenameCondition renameCondition, IAliasProvider aliasProvider) {
        boolean pkgUpdated = false;
        for (PackageNode pkg : root.getPackages()) {
            String alias;
            if (!renameCondition.shouldRename(pkg) || (alias = aliasProvider.forPackage(pkg)) == null) continue;
            pkg.rename(alias, false);
            pkgUpdated = true;
        }
        if (pkgUpdated) {
            root.runPackagesUpdate();
        }
        for (ClassNode cls : root.getClasses()) {
            String clsAlias;
            if (renameCondition.shouldRename(cls) && (clsAlias = aliasProvider.forClass(cls)) != null) {
                cls.rename(clsAlias);
            }
            for (FieldNode fld : cls.getFields()) {
                String fldAlias;
                if (!renameCondition.shouldRename(fld) || (fldAlias = aliasProvider.forField(fld)) == null) continue;
                fld.rename(fldAlias);
            }
            for (MethodNode mth : cls.getMethods()) {
                String mthAlias;
                if (!renameCondition.shouldRename(mth) || (mthAlias = aliasProvider.forMethod(mth)) == null) continue;
                mth.rename(mthAlias);
            }
        }
    }

    @Override
    public String getName() {
        return "DeobfuscatorVisitor";
    }
}

