/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.deobf.IAliasProvider;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;

public class DeobfAliasProvider
implements IAliasProvider {
    private int pkgIndex = 0;
    private int clsIndex = 0;
    private int fldIndex = 0;
    private int mthIndex = 0;
    private int maxLength;

    @Override
    public void init(RootNode root) {
        this.maxLength = root.getArgs().getDeobfuscationMaxLength();
    }

    @Override
    public void initIndexes(int pkg, int cls, int fld, int mth) {
        this.pkgIndex = pkg;
        this.clsIndex = cls;
        this.fldIndex = fld;
        this.mthIndex = mth;
    }

    @Override
    public String forPackage(PackageNode pkg) {
        return String.format("p%03d%s", this.pkgIndex++, this.prepareNamePart(pkg.getPkgInfo().getName()));
    }

    @Override
    public String forClass(ClassNode cls) {
        String prefix = this.makeClsPrefix(cls);
        return String.format("%sC%04d%s", prefix, this.clsIndex++, this.prepareNamePart(cls.getName()));
    }

    @Override
    public String forField(FieldNode fld) {
        return String.format("f%d%s", this.fldIndex++, this.prepareNamePart(fld.getName()));
    }

    @Override
    public String forMethod(MethodNode mth) {
        String prefix = mth.contains(AType.METHOD_OVERRIDE) ? "mo" : "m";
        return String.format("%s%d%s", prefix, this.mthIndex++, this.prepareNamePart(mth.getName()));
    }

    private String prepareNamePart(String name) {
        if (name.length() > this.maxLength) {
            return "x" + Integer.toHexString(name.hashCode());
        }
        return NameMapper.removeInvalidCharsMiddle(name);
    }

    private String makeClsPrefix(ClassNode cls) {
        if (cls.isEnum()) {
            return "Enum";
        }
        StringBuilder result = new StringBuilder();
        if (cls.getAccessFlags().isInterface()) {
            result.append("Interface");
        } else if (cls.getAccessFlags().isAbstract()) {
            result.append("Abstract");
        }
        result.append(DeobfAliasProvider.getBaseName(cls));
        return result.toString();
    }

    private static String getBaseName(ClassNode cls) {
        ClassNode currentCls = cls;
        while (currentCls != null) {
            String superClsName;
            ArgType superCls = currentCls.getSuperClass();
            if (superCls != null && ((superClsName = superCls.getObject()).startsWith("android.app.") || superClsName.startsWith("android.os."))) {
                return DeobfAliasProvider.getClsName(superClsName);
            }
            for (ArgType interfaceType : cls.getInterfaces()) {
                String name = interfaceType.getObject();
                if (name.equals("java.lang.Runnable")) {
                    return "Runnable";
                }
                if (!name.startsWith("java.util.concurrent.") && !name.startsWith("android.view.") && !name.startsWith("android.content.")) continue;
                return DeobfAliasProvider.getClsName(name);
            }
            if (superCls == null) break;
            currentCls = cls.root().resolveClass(superCls);
        }
        return "";
    }

    private static String getClsName(String name) {
        int pgkEnd = name.lastIndexOf(46);
        String clsName = name.substring(pgkEnd + 1);
        return StringUtils.removeChar(clsName, '$');
    }
}

