/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import com.android.aapt.Resources;
import jadx.api.ICodeInfo;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.CommonProtoParser;
import jadx.core.xmlgen.IResParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ResProtoParser
extends CommonProtoParser
implements IResParser {
    private final RootNode root;
    private final ResourceStorage resStorage = new ResourceStorage();

    public ResProtoParser(RootNode root) {
        this.root = root;
    }

    public ResContainer decodeFiles(InputStream inputStream) throws IOException {
        this.decode(inputStream);
        ValuesParser vp = new ValuesParser(new BinaryXMLStrings(), this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp);
        ICodeInfo content = XmlGenUtils.makeXmlDump(this.root.makeCodeWriter(), this.resStorage);
        List<ResContainer> xmlFiles = resGen.makeResourcesXml(this.root.getArgs());
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        Resources.ResourceTable table = Resources.ResourceTable.parseFrom((byte[])FileUtils.streamToByteArray(inputStream));
        for (Resources.Package p : table.getPackageList()) {
            this.parse(p);
        }
        this.resStorage.finish();
    }

    private void parse(Resources.Package p) {
        String name = p.getPackageName();
        this.resStorage.setAppPackage(name);
        this.parse(name, p.getTypeList());
    }

    private void parse(String packageName, List<Resources.Type> types) {
        for (Resources.Type type : types) {
            String typeName = type.getName();
            for (Resources.Entry entry : type.getEntryList()) {
                int id = entry.getEntryId().getId();
                String entryName = entry.getName();
                for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                    String config = this.parse(configValue.getConfig());
                    ResourceEntry resEntry = new ResourceEntry(id, packageName, typeName, entryName, config);
                    this.resStorage.add(resEntry);
                    ProtoValue protoValue = configValue.getValue().getValueCase() == Resources.Value.ValueCase.ITEM ? new ProtoValue(this.parse(configValue.getValue().getItem())) : this.parse(configValue.getValue().getCompoundValue());
                    resEntry.setProtoValue(protoValue);
                }
            }
        }
    }

    @Override
    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    @Override
    public BinaryXMLStrings getStrings() {
        return new BinaryXMLStrings();
    }
}

