/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.plugins.pass.JadxPass;
import jadx.api.plugins.pass.JadxPassInfo;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PassMerge {
    private final List<IDexTreeVisitor> visitors;
    private Set<String> mergePassesNames;
    private Map<IDexTreeVisitor, String> namesMap;

    public PassMerge(List<IDexTreeVisitor> visitors) {
        this.visitors = visitors;
    }

    public void merge(List<JadxPass> customPasses, Function<JadxPass, IDexTreeVisitor> wrap) {
        if (Utils.isEmpty(customPasses)) {
            return;
        }
        List<MergePass> mergePasses = ListUtils.map(customPasses, p -> new MergePass((JadxPass)p, (IDexTreeVisitor)wrap.apply((JadxPass)p), p.getInfo()));
        PassMerge.linkDeps(mergePasses);
        mergePasses.sort(new ExtDepsComparator(this.visitors).thenComparing(InvertedDepsComparator.INSTANCE));
        this.namesMap = new IdentityHashMap<IDexTreeVisitor, String>();
        this.visitors.forEach(p -> this.namesMap.put((IDexTreeVisitor)p, p.getName()));
        mergePasses.forEach(p -> this.namesMap.put(p.getVisitor(), p.getName()));
        this.mergePassesNames = mergePasses.stream().map(MergePass::getName).collect(Collectors.toSet());
        for (MergePass mergePass : mergePasses) {
            int pos = this.searchInsertPos(mergePass);
            if (pos == -1) {
                this.visitors.add(mergePass.getVisitor());
                continue;
            }
            this.visitors.add(pos, mergePass.getVisitor());
        }
    }

    private int searchInsertPos(MergePass pass) {
        List<String> runAfter = pass.after();
        List<String> runBefore = pass.before();
        if (runAfter.isEmpty() && runBefore.isEmpty()) {
            return -1;
        }
        if (ListUtils.isSingleElement(runAfter, "start")) {
            return 0;
        }
        if (ListUtils.isSingleElement(runBefore, "end")) {
            return -1;
        }
        int visitorsCount = this.visitors.size();
        HashMap<String, Integer> namePosMap = new HashMap<String, Integer>(visitorsCount);
        for (int i = 0; i < visitorsCount; ++i) {
            namePosMap.put(this.namesMap.get(this.visitors.get(i)), i);
        }
        int after = -1;
        for (String string : runAfter) {
            Integer pos = (Integer)namePosMap.get(string);
            if (pos != null) {
                after = Math.max(after, pos);
                continue;
            }
            if (this.mergePassesNames.contains(string)) continue;
            throw new JadxRuntimeException("Ordering pass not found: " + string + ", listed in 'runAfter' of pass: " + pass + "\n all passes: " + ListUtils.map(this.visitors, this.namesMap::get));
        }
        int before = Integer.MAX_VALUE;
        for (String name : runBefore) {
            Integer pos = (Integer)namePosMap.get(name);
            if (pos != null) {
                before = Math.min(before, pos);
                continue;
            }
            if (this.mergePassesNames.contains(name)) continue;
            throw new JadxRuntimeException("Ordering pass not found: " + name + ", listed in 'runBefore' of pass: " + pass + "\n all passes: " + ListUtils.map(this.visitors, this.namesMap::get));
        }
        if (before <= after) {
            throw new JadxRuntimeException("Conflict order requirements for pass: " + pass + "\n run after: " + runAfter + "\n run before: " + runBefore + "\n passes: " + ListUtils.map(this.visitors, this.namesMap::get));
        }
        if (after == -1) {
            if (before == Integer.MAX_VALUE) {
                return -1;
            }
            return before;
        }
        int n = after + 1;
        return n >= visitorsCount ? -1 : n;
    }

    private static void linkDeps(List<MergePass> mergePasses) {
        Map<String, MergePass> map = mergePasses.stream().collect(Collectors.toMap(MergePass::getName, p -> p));
        for (MergePass pass : mergePasses) {
            for (String after : pass.getInfo().runAfter()) {
                MergePass beforePass = map.get(after);
                if (beforePass == null) continue;
                beforePass.before().add(pass.getName());
            }
            for (String before : pass.getInfo().runBefore()) {
                MergePass afterPass = map.get(before);
                if (afterPass == null) continue;
                afterPass.after().add(pass.getName());
            }
        }
    }

    private static class InvertedDepsComparator
    implements Comparator<MergePass> {
        public static final InvertedDepsComparator INSTANCE = new InvertedDepsComparator();

        private InvertedDepsComparator() {
        }

        @Override
        public int compare(MergePass first, MergePass second) {
            if (first.before().contains(second.getName()) || first.after().contains(second.getName())) {
                return 1;
            }
            if (second.before().contains(first.getName()) || second.after().contains(first.getName())) {
                return -1;
            }
            return 0;
        }
    }

    private static class ExtDepsComparator
    implements Comparator<MergePass> {
        private final Set<String> names;

        public ExtDepsComparator(List<IDexTreeVisitor> visitors) {
            this.names = visitors.stream().map(IDexTreeVisitor::getName).collect(Collectors.toSet());
        }

        @Override
        public int compare(MergePass first, MergePass second) {
            boolean isFirst = this.containsVisitor(first.before()) || this.containsVisitor(first.after());
            boolean isSecond = this.containsVisitor(second.before()) || this.containsVisitor(second.after());
            return -Boolean.compare(isFirst, isSecond);
        }

        private boolean containsVisitor(List<String> deps) {
            for (String dep : deps) {
                if (!this.names.contains(dep)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class MergePass {
        private final JadxPass pass;
        private final IDexTreeVisitor visitor;
        private final JadxPassInfo info;
        private final List<String> before;
        private final List<String> after;

        private MergePass(JadxPass pass, IDexTreeVisitor visitor, JadxPassInfo info) {
            this.pass = pass;
            this.visitor = visitor;
            this.info = info;
            this.before = new ArrayList<String>(info.runBefore());
            this.after = new ArrayList<String>(info.runAfter());
        }

        public JadxPass getPass() {
            return this.pass;
        }

        public IDexTreeVisitor getVisitor() {
            return this.visitor;
        }

        public String getName() {
            return this.info.getName();
        }

        public JadxPassInfo getInfo() {
            return this.info;
        }

        public List<String> before() {
            return this.before;
        }

        public List<String> after() {
            return this.after;
        }

        public String toString() {
            return this.info.getName();
        }
    }
}

