/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins.events;

import jadx.api.plugins.events.IJadxEvent;
import jadx.api.plugins.events.JadxEventType;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class JadxEventsManager {
    private final Map<JadxEventType<?>, List<Consumer<IJadxEvent>>> listeners = new IdentityHashMap();
    private final ExecutorService eventsThreadPool = Executors.newSingleThreadExecutor(JadxEventsManager.makeThreadFactory());

    public synchronized <E extends IJadxEvent> void addListener(JadxEventType<E> eventType, Consumer<E> listener) {
        this.listeners.computeIfAbsent(eventType, et -> new ArrayList()).add(listener);
    }

    public synchronized void send(IJadxEvent event) {
        List<Consumer<IJadxEvent>> consumers = this.listeners.get(event.getType());
        if (consumers != null) {
            for (Consumer<IJadxEvent> consumer : consumers) {
                this.eventsThreadPool.execute(() -> consumer.accept(event));
            }
        }
    }

    public synchronized void reset() {
        this.listeners.clear();
    }

    private static ThreadFactory makeThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "jadx-events-thread-" + this.threadNumber.incrementAndGet());
            }
        };
    }
}

