/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.export;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.dex.nodes.RootNode;
import jadx.core.export.ExportGradleProject;
import jadx.core.utils.android.AndroidManifestParser;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.ResContainer;
import java.io.File;
import java.util.List;

public class ExportGradleTask
implements Runnable {
    private final List<ResourceFile> resources;
    private final RootNode root;
    private final File projectDir;
    private final File srcOutDir;
    private final File resOutDir;

    public ExportGradleTask(List<ResourceFile> resources, RootNode root, File projectDir) {
        this.resources = resources;
        this.projectDir = projectDir;
        this.root = root;
        File appDir = new File(projectDir, "app");
        this.srcOutDir = new File(appDir, "src/main/java");
        this.resOutDir = new File(appDir, "src/main");
    }

    public void init() {
        FileUtils.makeDirs(this.srcOutDir);
        FileUtils.makeDirs(this.resOutDir);
    }

    @Override
    public void run() {
        ResourceFile androidManifest = AndroidManifestParser.getAndroidManifest(this.resources);
        if (androidManifest == null) {
            throw new IllegalStateException("Could not find AndroidManifest.xml");
        }
        List<ResContainer> resContainers = this.resources.stream().filter(resourceFile -> resourceFile.getType() == ResourceType.ARSC).findFirst().orElseThrow(IllegalStateException::new).loadContent().getSubFiles();
        ResContainer strings = resContainers.stream().filter(resContainer -> resContainer.getName().contains("values/strings.xml")).findFirst().orElseGet(() -> resContainers.stream().filter(resContainer -> resContainer.getFileName().contains("strings.xml")).findFirst().orElse(null));
        ExportGradleProject export = new ExportGradleProject(this.root, this.projectDir, androidManifest, strings);
        export.generateGradleFiles();
    }

    public File getSrcOutDir() {
        return this.srcOutDir;
    }

    public File getResOutDir() {
        return this.resOutDir;
    }
}

