/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.clsp.ClspGraph;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.InitCodeVariables;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.dex.visitors.typeinference.FinishTypeInference;
import jadx.core.dex.visitors.typeinference.ITypeBound;
import jadx.core.dex.visitors.typeinference.TypeBoundCheckCastAssign;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.dex.visitors.typeinference.TypeSearch;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Fix Types Visitor", desc="Try various methods to fix unresolved types", runAfter={TypeInferenceVisitor.class}, runBefore={FinishTypeInference.class})
public final class FixTypesVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(FixTypesVisitor.class);
    private final TypeInferenceVisitor typeInference = new TypeInferenceVisitor();
    private TypeUpdate typeUpdate;
    private List<Function<MethodNode, Boolean>> resolvers;

    @Override
    public void init(RootNode root) {
        this.typeUpdate = root.getTypeUpdate();
        this.typeInference.init(root);
        this.resolvers = Arrays.asList(this::tryRestoreTypeVarCasts, this::tryInsertCasts, this::tryDeduceTypes, this::trySplitConstInsns, this::tryToFixIncompatiblePrimitives, this::tryToForceImmutableTypes, this::tryInsertAdditionalMove, this::runMultiVariableSearch, this::tryRemoveGenerics);
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode() || FixTypesVisitor.checkTypes(mth)) {
            return;
        }
        try {
            Function<MethodNode, Boolean> resolver;
            Iterator<Function<MethodNode, Boolean>> iterator = this.resolvers.iterator();
            while (!(!iterator.hasNext() || (resolver = iterator.next()).apply(mth).booleanValue() && FixTypesVisitor.checkTypes(mth))) {
            }
        }
        catch (Exception e) {
            mth.addError("Types fix failed", e);
        }
    }

    private static boolean checkTypes(MethodNode mth) {
        for (SSAVar var : mth.getSVars()) {
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown()) continue;
            return false;
        }
        return true;
    }

    private boolean runMultiVariableSearch(MethodNode mth) {
        try {
            TypeSearch typeSearch = new TypeSearch(mth);
            if (!typeSearch.run()) {
                mth.addWarnComment("Multi-variable type inference failed");
            }
            for (SSAVar var : mth.getSVars()) {
                if (var.getTypeInfo().getType().isTypeKnown()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            mth.addWarnComment("Multi-variable type inference failed. Error: " + Utils.getStackTrace(e));
            return false;
        }
    }

    private boolean setBestType(MethodNode mth, SSAVar ssaVar) {
        try {
            return this.calculateFromBounds(mth, ssaVar);
        }
        catch (JadxOverflowException e) {
            throw e;
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to calculate best type for var: " + ssaVar, e);
            return false;
        }
    }

    private boolean calculateFromBounds(MethodNode mth, SSAVar ssaVar) {
        TypeInfo typeInfo = ssaVar.getTypeInfo();
        Set<ITypeBound> bounds = typeInfo.getBounds();
        Optional<ArgType> bestTypeOpt = this.selectBestTypeFromBounds(bounds);
        if (bestTypeOpt.isEmpty()) {
            return false;
        }
        ArgType candidateType = bestTypeOpt.get();
        TypeUpdateResult result = this.typeUpdate.apply(mth, ssaVar, candidateType);
        if (result == TypeUpdateResult.REJECT) {
            return false;
        }
        return result == TypeUpdateResult.CHANGED;
    }

    private Optional<ArgType> selectBestTypeFromBounds(Set<ITypeBound> bounds) {
        return bounds.stream().map(ITypeBound::getType).filter(Objects::nonNull).max(this.typeUpdate.getTypeCompare().getComparator());
    }

    private boolean tryPossibleTypes(MethodNode mth, SSAVar var, ArgType type) {
        List<ArgType> types = this.makePossibleTypesList(type, var);
        if (types.isEmpty()) {
            return false;
        }
        for (ArgType candidateType : types) {
            TypeUpdateResult result = this.typeUpdate.apply(mth, var, candidateType);
            if (result != TypeUpdateResult.CHANGED) continue;
            return true;
        }
        return false;
    }

    private List<ArgType> makePossibleTypesList(ArgType type, @Nullable SSAVar var) {
        if (type.isArray()) {
            ArrayList<ArgType> list = new ArrayList<ArgType>();
            for (ArgType arrElemType : this.makePossibleTypesList(type.getArrayElement(), null)) {
                list.add(ArgType.array(arrElemType));
            }
            return list;
        }
        if (var != null) {
            for (ITypeBound b : var.getTypeInfo().getBounds()) {
                ArgType boundType = b.getType();
                if (!boundType.isObject() && !boundType.isArray()) continue;
                return Collections.emptyList();
            }
        }
        ArrayList list = new ArrayList();
        for (PrimitiveType possibleType : type.getPossibleTypes()) {
            if (possibleType == PrimitiveType.VOID) continue;
            list.add(ArgType.convertFromPrimitiveType(possibleType));
        }
        return list;
    }

    private boolean tryDeduceTypes(MethodNode mth) {
        boolean fixed = false;
        for (SSAVar ssaVar : mth.getSVars()) {
            if (!this.deduceType(mth, ssaVar)) continue;
            fixed = true;
        }
        return fixed;
    }

    private boolean deduceType(MethodNode mth, SSAVar var) {
        if (var.isTypeImmutable()) {
            return false;
        }
        ArgType type = var.getTypeInfo().getType();
        if (type.isTypeKnown()) {
            return false;
        }
        if (this.setBestType(mth, var)) {
            return true;
        }
        if (this.tryPossibleTypes(mth, var, type)) {
            return true;
        }
        return this.tryWiderObjects(mth, var);
    }

    private boolean tryRemoveGenerics(MethodNode mth) {
        boolean resolved = true;
        for (SSAVar var : mth.getSVars()) {
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown() || var.isTypeImmutable() || this.tryRawType(mth, var)) continue;
            resolved = false;
        }
        return resolved;
    }

    private boolean tryRawType(MethodNode mth, SSAVar var) {
        LinkedHashSet<ArgType> objTypes = new LinkedHashSet<ArgType>();
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || !boundType.isObject()) continue;
            objTypes.add(boundType);
        }
        if (objTypes.isEmpty()) {
            return false;
        }
        for (ArgType objType : objTypes) {
            if (!this.checkRawType(mth, var, objType)) continue;
            mth.addDebugComment("Type inference failed for " + var.toShortString() + ". Raw type applied. Possible types: " + Utils.listToString(objTypes));
            return true;
        }
        return false;
    }

    private boolean checkRawType(MethodNode mth, SSAVar var, ArgType objType) {
        if (objType.isObject() && objType.containsGeneric()) {
            ArgType rawType = objType.isGenericType() ? ArgType.OBJECT : ArgType.object(objType.getObject());
            TypeUpdateResult result = this.typeUpdate.applyWithWiderAllow(mth, var, rawType);
            return result == TypeUpdateResult.CHANGED;
        }
        return false;
    }

    private boolean tryRestoreTypeVarCasts(MethodNode mth) {
        int changed = 0;
        List<SSAVar> mthSVars = mth.getSVars();
        for (SSAVar var : mthSVars) {
            changed += this.restoreTypeVarCasts(var);
        }
        if (changed == 0) {
            return false;
        }
        this.typeInference.initTypeBounds(mth);
        return this.typeInference.runTypePropagation(mth);
    }

    private int restoreTypeVarCasts(SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        Set<ITypeBound> bounds = typeInfo.getBounds();
        if (!ListUtils.anyMatch(bounds, t -> t.getType().isGenericType())) {
            return 0;
        }
        List<ITypeBound> casts = ListUtils.filter(bounds, TypeBoundCheckCastAssign.class::isInstance);
        if (casts.isEmpty()) {
            return 0;
        }
        ArgType bestType = this.selectBestTypeFromBounds(bounds).orElse(ArgType.UNKNOWN);
        if (!bestType.isGenericType()) {
            return 0;
        }
        List<ArgType> extendTypes = bestType.getExtendTypes();
        if (extendTypes.size() != 1) {
            return 0;
        }
        int fixed = 0;
        ArgType extendType = extendTypes.get(0);
        for (ITypeBound bound : casts) {
            TypeBoundCheckCastAssign cast = (TypeBoundCheckCastAssign)bound;
            ArgType castType = cast.getType();
            TypeCompareEnum result = this.typeUpdate.getTypeCompare().compareTypes(extendType, castType);
            if (!result.isEqual() && result != TypeCompareEnum.NARROW_BY_GENERIC) continue;
            cast.getInsn().updateIndex(bestType);
            ++fixed;
        }
        return fixed;
    }

    private boolean tryInsertCasts(MethodNode mth) {
        int added = 0;
        List<SSAVar> mthSVars = mth.getSVars();
        int varsCount = mthSVars.size();
        for (int i = 0; i < varsCount; ++i) {
            SSAVar var = mthSVars.get(i);
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown() || var.isTypeImmutable()) continue;
            added += this.tryInsertVarCast(mth, var);
        }
        if (added != 0) {
            InitCodeVariables.rerun(mth);
            this.typeInference.initTypeBounds(mth);
            return this.typeInference.runTypePropagation(mth);
        }
        return false;
    }

    private int tryInsertVarCast(MethodNode mth, SSAVar var) {
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || boundType.equals(var.getTypeInfo().getType()) || !boundType.containsTypeVariable() || mth.root().getTypeUtils().containsUnknownTypeVar(mth, boundType)) continue;
            if (this.insertAssignCast(mth, var, boundType)) {
                return 1;
            }
            return this.insertUseCasts(mth, var);
        }
        return 0;
    }

    private int insertUseCasts(MethodNode mth, SSAVar var) {
        List<RegisterArg> useList = var.getUseList();
        if (useList.isEmpty()) {
            return 0;
        }
        int useCasts = 0;
        for (RegisterArg useReg : new ArrayList<RegisterArg>(useList)) {
            if (!this.insertSoftUseCast(mth, useReg)) continue;
            ++useCasts;
        }
        return useCasts;
    }

    private boolean insertAssignCast(MethodNode mth, SSAVar var, ArgType castType) {
        RegisterArg assignArg = var.getAssign();
        InsnNode assignInsn = assignArg.getParentInsn();
        if (assignInsn == null || assignInsn.getType() == InsnType.PHI) {
            return false;
        }
        BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
        if (assignBlock == null) {
            return false;
        }
        assignInsn.setResult(assignArg.duplicateWithNewSSAVar(mth));
        IndexInsnNode castInsn = this.makeSoftCastInsn(assignArg.duplicate(), assignInsn.getResult().duplicate(), castType);
        return BlockUtils.insertAfterInsn(assignBlock, assignInsn, castInsn);
    }

    private boolean insertSoftUseCast(MethodNode mth, RegisterArg useArg) {
        InsnNode useInsn = useArg.getParentInsn();
        if (useInsn == null || useInsn.getType() == InsnType.PHI) {
            return false;
        }
        if (useInsn.getType() == InsnType.IF && useInsn.getArg(1).isZeroConst()) {
            return false;
        }
        BlockNode useBlock = BlockUtils.getBlockByInsn(mth, useInsn);
        if (useBlock == null) {
            return false;
        }
        IndexInsnNode castInsn = this.makeSoftCastInsn(useArg.duplicateWithNewSSAVar(mth), useArg.duplicate(), useArg.getInitType());
        useInsn.replaceArg(useArg, castInsn.getResult().duplicate());
        boolean success = BlockUtils.insertBeforeInsn(useBlock, useInsn, castInsn);
        return success;
    }

    private IndexInsnNode makeSoftCastInsn(RegisterArg result, RegisterArg arg, ArgType castType) {
        IndexInsnNode castInsn = new IndexInsnNode(InsnType.CHECK_CAST, castType, 1);
        castInsn.setResult(result);
        castInsn.addArg(arg);
        castInsn.add(AFlag.SOFT_CAST);
        castInsn.add(AFlag.SYNTHETIC);
        return castInsn;
    }

    private boolean trySplitConstInsns(MethodNode mth) {
        boolean constSplit = false;
        for (SSAVar var : new ArrayList<SSAVar>(mth.getSVars())) {
            if (!this.checkAndSplitConstInsn(mth, var)) continue;
            constSplit = true;
        }
        if (!constSplit) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.typeInference.initTypeBounds(mth);
        return this.typeInference.runTypePropagation(mth);
    }

    private boolean checkAndSplitConstInsn(MethodNode mth, SSAVar var) {
        ArgType type = var.getTypeInfo().getType();
        if (type.isTypeKnown() || var.isTypeImmutable()) {
            return false;
        }
        return FixTypesVisitor.splitByPhi(mth, var) || this.dupConst(mth, var);
    }

    private boolean dupConst(MethodNode mth, SSAVar var) {
        InsnNode assignInsn = var.getAssign().getAssignInsn();
        if (!InsnUtils.isInsnType(assignInsn, InsnType.CONST)) {
            return false;
        }
        if (var.getUseList().size() < 2) {
            return false;
        }
        BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
        if (assignBlock == null) {
            return false;
        }
        assignInsn.remove(AFlag.DONT_INLINE);
        int insertIndex = 1 + BlockUtils.getInsnIndexInBlock(assignBlock, assignInsn);
        ArrayList<RegisterArg> useList = new ArrayList<RegisterArg>(var.getUseList());
        int useCount = useList.size();
        for (int i = 0; i < useCount; ++i) {
            InsnNode useInsn;
            RegisterArg useArg = (RegisterArg)useList.get(i);
            useArg.remove(AFlag.DONT_INLINE_CONST);
            if (i == 0 || (useInsn = useArg.getParentInsn()) == null) continue;
            InsnNode newInsn = assignInsn.copyWithNewSsaVar(mth);
            assignBlock.getInstructions().add(insertIndex, newInsn);
            useInsn.replaceArg(useArg, newInsn.getResult().duplicate());
        }
        return true;
    }

    private static boolean splitByPhi(MethodNode mth, SSAVar var) {
        if (var.getUsedInPhi().size() < 2) {
            return false;
        }
        InsnNode assignInsn = var.getAssign().getAssignInsn();
        InsnNode constInsn = InsnUtils.checkInsnType(assignInsn, InsnType.CONST);
        if (constInsn == null) {
            return false;
        }
        BlockNode blockNode = BlockUtils.getBlockByInsn(mth, constInsn);
        if (blockNode == null) {
            return false;
        }
        boolean first = true;
        for (PhiInsn phiInsn : var.getUsedInPhi()) {
            if (first) {
                first = false;
                continue;
            }
            InsnNode copyInsn = constInsn.copyWithNewSsaVar(mth);
            copyInsn.add(AFlag.SYNTHETIC);
            BlockUtils.insertAfterInsn(blockNode, constInsn, copyInsn);
            RegisterArg phiArg = phiInsn.getArgBySsaVar(var);
            phiInsn.replaceArg(phiArg, copyInsn.getResult().duplicate());
        }
        return true;
    }

    private boolean tryInsertAdditionalMove(MethodNode mth) {
        int insnsAdded = 0;
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiListAttr = block.get(AType.PHI_LIST);
            if (phiListAttr == null) continue;
            for (PhiInsn phiInsn : phiListAttr.getList()) {
                insnsAdded += this.tryInsertAdditionalInsn(mth, phiInsn);
            }
        }
        if (insnsAdded == 0) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.typeInference.initTypeBounds(mth);
        if (this.typeInference.runTypePropagation(mth) && FixTypesVisitor.checkTypes(mth)) {
            return true;
        }
        return this.tryDeduceTypes(mth);
    }

    private int tryInsertAdditionalInsn(MethodNode mth, PhiInsn phiInsn) {
        ArgType phiType = this.getCommonTypeForPhiArgs(phiInsn);
        if (phiType != null && phiType.isTypeKnown()) {
            return 0;
        }
        if (this.insertMovesForPhi(mth, phiInsn, false) == 0) {
            return 0;
        }
        return this.insertMovesForPhi(mth, phiInsn, true);
    }

    @Nullable
    private ArgType getCommonTypeForPhiArgs(PhiInsn phiInsn) {
        ArgType phiArgType = null;
        for (InsnArg arg : phiInsn.getArguments()) {
            ArgType type = arg.getType();
            if (phiArgType == null) {
                phiArgType = type;
                continue;
            }
            if (phiArgType.equals(type)) continue;
            return null;
        }
        return phiArgType;
    }

    private int insertMovesForPhi(MethodNode mth, PhiInsn phiInsn, boolean apply) {
        int argsCount = phiInsn.getArgsCount();
        int count = 0;
        for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
            InsnType assignType;
            RegisterArg reg = phiInsn.getArg(argIndex);
            BlockNode startBlock = phiInsn.getBlockByArgIndex(argIndex);
            BlockNode blockNode = this.checkBlockForInsnInsert(startBlock);
            if (blockNode == null) {
                mth.addDebugComment("Failed to insert an additional move for type inference into block " + startBlock);
                return 0;
            }
            boolean add = true;
            SSAVar var = reg.getSVar();
            InsnNode assignInsn = var.getAssign().getAssignInsn();
            if (assignInsn != null && ((assignType = assignInsn.getType()) == InsnType.CONST || assignType == InsnType.MOVE && var.getUseCount() == 1)) {
                add = false;
            }
            if (!add) continue;
            ++count;
            if (!apply) continue;
            this.insertMove(mth, blockNode, phiInsn, reg);
        }
        return count;
    }

    private void insertMove(MethodNode mth, BlockNode blockNode, PhiInsn phiInsn, RegisterArg reg) {
        SSAVar var = reg.getSVar();
        int regNum = reg.getRegNum();
        RegisterArg resultArg = reg.duplicate(regNum, null);
        SSAVar newSsaVar = mth.makeNewSVar(resultArg);
        RegisterArg arg = reg.duplicate(regNum, var);
        InsnNode moveInsn = new InsnNode(InsnType.MOVE, 1);
        moveInsn.setResult(resultArg);
        moveInsn.addArg(arg);
        moveInsn.add(AFlag.SYNTHETIC);
        blockNode.getInstructions().add(moveInsn);
        phiInsn.replaceArg(reg, reg.duplicate(regNum, newSsaVar));
    }

    @Nullable
    private BlockNode checkBlockForInsnInsert(BlockNode blockNode) {
        if (blockNode.isSynthetic()) {
            return null;
        }
        InsnNode lastInsn = BlockUtils.getLastInsn(blockNode);
        if (lastInsn != null && BlockSplitter.isSeparate(lastInsn.getType())) {
            List<BlockNode> preds = blockNode.getPredecessors();
            if (preds.size() == 1) {
                return this.checkBlockForInsnInsert(preds.get(0));
            }
            return null;
        }
        return blockNode;
    }

    private boolean tryWiderObjects(MethodNode mth, SSAVar var) {
        LinkedHashSet<ArgType> objTypes = new LinkedHashSet<ArgType>();
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || !boundType.isObject()) continue;
            objTypes.add(boundType);
        }
        if (objTypes.isEmpty()) {
            return false;
        }
        ClspGraph clsp = mth.root().getClsp();
        for (ArgType objType : objTypes) {
            for (String ancestor : clsp.getSuperTypes(objType.getObject())) {
                ArgType ancestorType = ArgType.object(ancestor);
                TypeUpdateResult result = this.typeUpdate.applyWithWiderAllow(mth, var, ancestorType);
                if (result != TypeUpdateResult.CHANGED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryToFixIncompatiblePrimitives(MethodNode mth) {
        boolean fixed = false;
        List<SSAVar> ssaVars = mth.getSVars();
        int ssaVarsCount = ssaVars.size();
        for (int i = 0; i < ssaVarsCount; ++i) {
            if (!this.processIncompatiblePrimitives(mth, ssaVars.get(i))) continue;
            fixed = true;
        }
        if (!fixed) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.typeInference.initTypeBounds(mth);
        return this.typeInference.runTypePropagation(mth);
    }

    private boolean processIncompatiblePrimitives(MethodNode mth, SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        if (typeInfo.getType().isTypeKnown()) {
            return false;
        }
        boolean assigned = false;
        for (ITypeBound bound : typeInfo.getBounds()) {
            ArgType boundType = bound.getType();
            switch (bound.getBound()) {
                case ASSIGN: {
                    if (!boundType.contains(PrimitiveType.BOOLEAN)) {
                        return false;
                    }
                    assigned = true;
                    break;
                }
                case USE: {
                    if (boundType.canBeAnyNumber()) break;
                    return false;
                }
            }
        }
        if (!assigned) {
            return false;
        }
        boolean fixed = false;
        for (RegisterArg arg : new ArrayList<RegisterArg>(var.getUseList())) {
            if (!this.fixBooleanUsage(mth, arg)) continue;
            fixed = true;
        }
        return fixed;
    }

    private boolean fixBooleanUsage(MethodNode mth, RegisterArg boundArg) {
        InsnArg secondArg;
        ArithNode arithInsn;
        ArgType boundType = boundArg.getInitType();
        if (boundType == ArgType.BOOLEAN || boundType.isTypeKnown() && !boundType.isPrimitive()) {
            return false;
        }
        InsnNode insn = boundArg.getParentInsn();
        if (insn == null || insn.getType() == InsnType.IF) {
            return false;
        }
        BlockNode blockNode = BlockUtils.getBlockByInsn(mth, insn);
        if (blockNode == null) {
            return false;
        }
        List<InsnNode> insnList = blockNode.getInstructions();
        int insnIndex = InsnList.getIndex(insnList, insn);
        if (insnIndex == -1) {
            return false;
        }
        InsnType insnType = insn.getType();
        if (insnType == InsnType.CAST) {
            ArgType type = (ArgType)((IndexInsnNode)insn).getIndex();
            TernaryInsn convertInsn = this.prepareBooleanConvertInsn(insn.getResult(), boundArg, type);
            BlockUtils.replaceInsn(mth, blockNode, insnIndex, (InsnNode)convertInsn);
            return true;
        }
        if (insnType == InsnType.ARITH && (arithInsn = (ArithNode)insn).getOp() == ArithOp.XOR && arithInsn.getArgsCount() == 2 && (secondArg = arithInsn.getArg(1)).isLiteral() && ((LiteralArg)secondArg).getLiteral() == 1L) {
            InsnNode convertInsn = this.notBooleanToInt(arithInsn, boundArg);
            BlockUtils.replaceInsn(mth, blockNode, insnIndex, convertInsn);
            return true;
        }
        RegisterArg resultArg = boundArg.duplicateWithNewSSAVar(mth);
        TernaryInsn convertInsn = this.prepareBooleanConvertInsn(resultArg, boundArg, boundType);
        insnList.add(insnIndex, convertInsn);
        insn.replaceArg(boundArg, convertInsn.getResult().duplicate());
        return true;
    }

    private InsnNode notBooleanToInt(ArithNode insn, RegisterArg boundArg) {
        InsnNode notInsn = new InsnNode(InsnType.NOT, 1);
        notInsn.addArg(boundArg.duplicate());
        notInsn.add(AFlag.SYNTHETIC);
        ArgType resType = insn.getResult().getType();
        if (resType.canBePrimitive(PrimitiveType.BOOLEAN)) {
            notInsn.setResult(insn.getResult());
            return notInsn;
        }
        InsnArg notArg = InsnArg.wrapArg(notInsn);
        notArg.setType(ArgType.BOOLEAN);
        TernaryInsn convertInsn = ModVisitor.makeBooleanConvertInsn(insn.getResult(), notArg, ArgType.INT);
        convertInsn.add(AFlag.SYNTHETIC);
        return convertInsn;
    }

    private TernaryInsn prepareBooleanConvertInsn(RegisterArg resultArg, RegisterArg boundArg, ArgType useType) {
        RegisterArg useArg = boundArg.getSVar().getAssign().duplicate();
        TernaryInsn convertInsn = ModVisitor.makeBooleanConvertInsn(resultArg, useArg, useType);
        convertInsn.add(AFlag.SYNTHETIC);
        return convertInsn;
    }

    private boolean tryToForceImmutableTypes(MethodNode mth) {
        boolean fixed = false;
        for (SSAVar ssaVar : mth.getSVars()) {
            ArgType type = ssaVar.getTypeInfo().getType();
            if (type.isTypeKnown() || !ssaVar.isTypeImmutable() || !this.forceImmutableType(ssaVar)) continue;
            fixed = true;
        }
        if (!fixed) {
            return false;
        }
        return this.typeInference.runTypePropagation(mth);
    }

    private boolean forceImmutableType(SSAVar ssaVar) {
        for (RegisterArg useArg : ssaVar.getUseList()) {
            InsnType insnType;
            InsnNode parentInsn = useArg.getParentInsn();
            if (parentInsn == null || (insnType = parentInsn.getType()) != InsnType.AGET && insnType != InsnType.APUT) continue;
            ssaVar.setType(ssaVar.getImmutableType());
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "FixTypesVisitor";
    }
}

