/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.rename;

import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BetterName;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SourceFileRename
extends AbstractVisitor {
    @Override
    public String getName() {
        return "SourceFileRename";
    }

    @Override
    public void init(RootNode root) throws JadxException {
        String alias;
        if (!root.getArgs().isUseSourceNameAsClassAlias()) {
            return;
        }
        List<ClassNode> classes = root.getClasses();
        HashMap<String, Boolean> canUseAlias = new HashMap<String, Boolean>();
        for (ClassNode cls : classes) {
            canUseAlias.put(cls.getClassInfo().getShortName(), Boolean.FALSE);
        }
        ArrayList<ClsRename> renames = new ArrayList<ClsRename>();
        for (ClassNode cls : classes) {
            if (cls.contains(AFlag.DONT_RENAME) || (alias = SourceFileRename.getAliasFromSourceFile(cls)) == null) continue;
            Boolean prev = (Boolean)canUseAlias.get(alias);
            if (prev == null) {
                canUseAlias.put(alias, Boolean.TRUE);
                renames.add(new ClsRename(cls, alias));
                continue;
            }
            if (prev != Boolean.TRUE) continue;
            canUseAlias.put(alias, Boolean.FALSE);
        }
        for (ClsRename clsRename : renames) {
            alias = clsRename.getAlias();
            if (canUseAlias.get(alias) != Boolean.TRUE) continue;
            SourceFileRename.applyRename(clsRename.getCls(), alias);
        }
    }

    private static void applyRename(ClassNode cls, String alias) {
        String currentAlias;
        String betterName;
        if (cls.getClassInfo().hasAlias() && (betterName = BetterName.compareAndGet(alias, currentAlias = cls.getAlias())).equals(currentAlias)) {
            return;
        }
        cls.getClassInfo().changeShortName(alias);
        cls.addAttr(new RenameReasonAttr(cls).append("use source file name"));
    }

    @Nullable
    private static String getAliasFromSourceFile(ClassNode cls) {
        SourceFileAttr sourceFileAttr = (SourceFileAttr)cls.get(JadxAttrType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return null;
        }
        if (cls.getClassInfo().isInner()) {
            return null;
        }
        String name = sourceFileAttr.getFileName();
        name = StringUtils.removeSuffix(name, ".java");
        if (!NameMapper.isValidAndPrintable(name = StringUtils.removeSuffix(name, ".kt"))) {
            return null;
        }
        if (name.equals(cls.getName())) {
            return null;
        }
        return name;
    }

    private static final class ClsRename {
        private final ClassNode cls;
        private final String alias;

        private ClsRename(ClassNode cls, String alias) {
            this.cls = cls;
            this.alias = alias;
        }

        public ClassNode getCls() {
            return this.cls;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            return "ClsRename{" + this.cls + " -> '" + this.alias + "'}";
        }
    }
}

