/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.prepare;

import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.utils.exceptions.JadxException;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="CollectConstValues", desc="Collect and store values from static final fields")
public class CollectConstValues
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        RootNode root = cls.root();
        if (!root.getArgs().isReplaceConsts()) {
            return true;
        }
        if (cls.getFields().isEmpty()) {
            return true;
        }
        ConstStorage constStorage = root.getConstValues();
        for (FieldNode fld : cls.getFields()) {
            try {
                Object value = CollectConstValues.getFieldConstValue(fld);
                if (value == null) continue;
                constStorage.addConstField(fld, value, fld.getAccessFlags().isPublic());
            }
            catch (Exception e) {
                cls.addWarnComment("Failed to process value of field: " + fld, e);
            }
        }
        return true;
    }

    @Nullable
    public static Object getFieldConstValue(FieldNode fld) {
        EncodedValue constVal;
        AccessInfo accFlags = fld.getAccessFlags();
        if (accFlags.isStatic() && accFlags.isFinal() && (constVal = (EncodedValue)fld.get(JadxAttrType.CONSTANT_VALUE)) != null && constVal != EncodedValue.NULL) {
            return constVal.getValue();
        }
        return null;
    }
}

