/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.blocks.DominatorTree;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import java.util.ArrayList;
import java.util.BitSet;

public class PostDominatorTree {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compute(MethodNode mth) {
        if (!mth.contains(AFlag.COMPUTE_POST_DOM)) {
            return;
        }
        try {
            BlockNode block;
            int i;
            int mthBlocksCount = mth.getBasicBlocks().size();
            ArrayList<BlockNode> sorted = new ArrayList<BlockNode>(mthBlocksCount);
            BlockUtils.visitReverseDFS(mth, sorted::add);
            int blocksCount = sorted.size();
            int[] ids = new int[mthBlocksCount];
            for (int i2 = 0; i2 < blocksCount; ++i2) {
                ids[i2] = ((BlockNode)sorted.get(i2)).getId();
            }
            mth.updateBlockIds(sorted);
            BlockNode[] postDoms = DominatorTree.build(sorted, BlockNode::getSuccessors);
            BlockNode firstBlock = (BlockNode)sorted.get(0);
            firstBlock.setPostDoms(EmptyBitSet.EMPTY);
            firstBlock.setIPostDom(null);
            for (i = 1; i < blocksCount; ++i) {
                block = (BlockNode)sorted.get(i);
                BlockNode iPostDom = postDoms[i];
                block.setIPostDom(iPostDom);
                BitSet postDomBS = DominatorTree.collectDoms(postDoms, iPostDom);
                block.setPostDoms(postDomBS);
            }
            for (i = 1; i < blocksCount; ++i) {
                block = (BlockNode)sorted.get(i);
                BitSet bs = new BitSet(blocksCount);
                block.getPostDoms().stream().forEach(n -> bs.set(ids[n]));
                bs.clear(ids[i]);
                block.setPostDoms(bs);
            }
            int blocksDelta = mthBlocksCount - blocksCount;
            if (blocksDelta != 0) {
                int insnsCount = 0;
                for (BlockNode block2 : mth.getBasicBlocks()) {
                    if (block2.getPostDoms() != null) continue;
                    block2.setPostDoms(EmptyBitSet.EMPTY);
                    block2.setIPostDom(null);
                    insnsCount += block2.getInstructions().size();
                }
                mth.addInfoComment("Infinite loop detected, blocks: " + blocksDelta + ", insns: " + insnsCount);
            }
        }
        catch (Throwable e) {
            mth.addWarnComment("Failed to build post-dominance tree", e);
        }
        finally {
            mth.updateBlockIds(mth.getBasicBlocks());
        }
    }
}

