/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@JadxVisitor(name="ReplaceNewArray", desc="Replace new-array and sequence of array-put to new filled-array instruction", runAfter={CodeShrinkVisitor.class})
public class ReplaceNewArray
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        block4: {
            if (mth.isNoCode()) {
                return;
            }
            int k = 0;
            do {
                boolean changed = false;
                InsnRemover remover = new InsnRemover(mth);
                for (BlockNode block : mth.getBasicBlocks()) {
                    remover.setBlock(block);
                    List<InsnNode> instructions = block.getInstructions();
                    int size = instructions.size();
                    for (int i = 0; i < size; ++i) {
                        changed |= ReplaceNewArray.processInsn(mth, instructions, i, remover);
                    }
                    remover.perform();
                }
                if (!changed) break block4;
                CodeShrinkVisitor.shrinkMethod(mth);
            } while (k++ <= 100);
            mth.addWarnComment("Reached limit for ReplaceNewArray iterations");
        }
    }

    private static boolean processInsn(MethodNode mth, List<InsnNode> instructions, int i, InsnRemover remover) {
        InsnNode insn = instructions.get(i);
        if (insn.getType() == InsnType.NEW_ARRAY && !insn.contains(AFlag.REMOVE)) {
            return ReplaceNewArray.processNewArray(mth, (NewArrayNode)insn, instructions, remover);
        }
        return false;
    }

    private static boolean processNewArray(MethodNode mth, NewArrayNode newArrayInsn, List<InsnNode> instructions, InsnRemover remover) {
        Object arrayLenConst = InsnUtils.getConstValueByArg(mth.root(), newArrayInsn.getArg(0));
        if (!(arrayLenConst instanceof LiteralArg)) {
            return false;
        }
        int len = (int)((LiteralArg)arrayLenConst).getLiteral();
        if (len == 0) {
            return false;
        }
        ArgType arrType = newArrayInsn.getArrayType();
        ArgType elemType = arrType.getArrayElement();
        boolean allowMissingKeys = arrType.getArrayDimension() == 1 && elemType.isPrimitive();
        int minLen = allowMissingKeys ? len / 2 : len;
        RegisterArg arrArg = newArrayInsn.getResult();
        List<RegisterArg> useList = arrArg.getSVar().getUseList();
        if (useList.size() < minLen) {
            return false;
        }
        boolean foundPut = false;
        for (RegisterArg registerArg : useList) {
            InsnNode parentInsn = registerArg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.APUT) continue;
            foundPut = true;
            break;
        }
        if (!foundPut) {
            return false;
        }
        TreeMap<Long, InsnNode> arrPuts = new TreeMap<Long, InsnNode>();
        for (RegisterArg registerArg : useList) {
            InsnNode parentInsn = registerArg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.APUT) continue;
            if (!arrArg.sameRegAndSVar(parentInsn.getArg(0))) {
                return false;
            }
            Iterator constVal = InsnUtils.getConstValueByArg(mth.root(), parentInsn.getArg(1));
            if (!(constVal instanceof LiteralArg)) {
                return false;
            }
            long index = ((LiteralArg)((Object)constVal)).getLiteral();
            if (index >= (long)len) {
                return false;
            }
            if (arrPuts.containsKey(index)) break;
            arrPuts.put(index, parentInsn);
        }
        if (arrPuts.size() < minLen) {
            return false;
        }
        if (!new HashSet<InsnNode>(instructions).containsAll(arrPuts.values())) {
            return false;
        }
        FilledNewArrayNode filledNewArrayNode = new FilledNewArrayNode(elemType, len);
        filledNewArrayNode.setResult(arrArg.duplicate());
        filledNewArrayNode.copyAttributesFrom(newArrayInsn);
        filledNewArrayNode.inheritMetadata(newArrayInsn);
        filledNewArrayNode.setOffset(newArrayInsn.getOffset());
        long prevIndex = -1L;
        for (Map.Entry entry : arrPuts.entrySet()) {
            long index = (Long)entry.getKey();
            if (index != prevIndex) {
                for (long i = prevIndex + 1L; i < index; ++i) {
                    filledNewArrayNode.addArg(InsnArg.lit(0L, elemType));
                }
            }
            InsnNode put = (InsnNode)entry.getValue();
            filledNewArrayNode.addArg(ReplaceNewArray.replaceConstInArg(mth, put.getArg(2)));
            remover.addAndUnbind(put);
            prevIndex = index;
        }
        remover.addAndUnbind(newArrayInsn);
        InsnNode lastPut = (InsnNode)arrPuts.get(arrPuts.lastKey());
        int replaceIndex = InsnList.getIndex(instructions, lastPut);
        instructions.set(replaceIndex, filledNewArrayNode);
        BlockUtils.replaceInsn(mth, lastPut, filledNewArrayNode);
        return true;
    }

    private static InsnArg replaceConstInArg(MethodNode mth, InsnArg valueArg) {
        IFieldInfoRef f;
        if (valueArg.isLiteral() && (f = mth.getParentClass().getConstFieldByLiteralArg((LiteralArg)valueArg)) != null) {
            IndexInsnNode fGet = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
            InsnArg arg = InsnArg.wrapArg(fGet);
            ModVisitor.addFieldUsage(f, mth);
            return arg;
        }
        return valueArg.duplicate();
    }
}

