/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import org.jetbrains.annotations.NotNull;

public final class NamedArg
extends InsnArg
implements Named {
    @NotNull
    private String name;

    public NamedArg(@NotNull String name, @NotNull ArgType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    public InsnArg duplicate() {
        return this.copyCommonParams(new NamedArg(this.name, this.type));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedArg)) {
            return false;
        }
        return this.name.equals(((NamedArg)o).name);
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    public String toString() {
        return "(" + this.name + " " + this.type + ")";
    }
}

