/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.InfoStorage;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class MethodInfo
implements Comparable<MethodInfo> {
    private final String name;
    private final ArgType retType;
    private final List<ArgType> argTypes;
    private final ClassInfo declClass;
    private final String shortId;
    private final String rawFullId;
    private final int hash;
    private String alias;

    private MethodInfo(ClassInfo declClass, String name, List<ArgType> args, ArgType retType) {
        this.name = name;
        this.alias = name;
        this.declClass = declClass;
        this.argTypes = args;
        this.retType = retType;
        this.shortId = MethodInfo.makeShortId(name, this.argTypes, retType);
        this.rawFullId = declClass.makeRawFullName() + "." + this.shortId;
        this.hash = this.calcHashCode();
    }

    public static MethodInfo fromRef(RootNode root, IMethodRef methodRef) {
        MethodInfo prevMth;
        InfoStorage infoStorage = root.getInfoStorage();
        int uniqId = methodRef.getUniqId();
        if (uniqId != 0 && (prevMth = infoStorage.getByUniqId(uniqId)) != null) {
            return prevMth;
        }
        methodRef.load();
        ArgType parentClsType = ArgType.parse(methodRef.getParentClassType());
        ClassInfo parentClass = ClassInfo.fromType(root, parentClsType);
        ArgType returnType = ArgType.parse(methodRef.getReturnType());
        List<ArgType> args = Utils.collectionMap(methodRef.getArgTypes(), ArgType::parse);
        MethodInfo newMth = new MethodInfo(parentClass, methodRef.getName(), args, returnType);
        MethodInfo uniqMth = infoStorage.putMethod(newMth);
        if (uniqId != 0) {
            infoStorage.putByUniqId(uniqId, uniqMth);
        }
        return uniqMth;
    }

    public static MethodInfo fromDetails(RootNode root, ClassInfo declClass, String name, List<ArgType> args, ArgType retType) {
        MethodInfo newMth = new MethodInfo(declClass, name, args, retType);
        return root.getInfoStorage().putMethod(newMth);
    }

    public static MethodInfo fromMethodProto(RootNode root, ClassInfo declClass, String name, IMethodProto proto) {
        List<ArgType> args = Utils.collectionMap(proto.getArgTypes(), ArgType::parse);
        ArgType returnType = ArgType.parse(proto.getReturnType());
        return MethodInfo.fromDetails(root, declClass, name, args, returnType);
    }

    public String makeSignature(boolean includeRetType) {
        return this.makeSignature(false, includeRetType);
    }

    public String makeSignature(boolean useAlias, boolean includeRetType) {
        return MethodInfo.makeShortId(useAlias ? this.alias : this.name, this.argTypes, includeRetType ? this.retType : null);
    }

    public static String makeShortId(String name, List<ArgType> argTypes, @Nullable ArgType retType) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(');
        for (ArgType arg : argTypes) {
            sb.append(TypeGen.signature(arg));
        }
        sb.append(')');
        if (retType != null) {
            sb.append(TypeGen.signature(retType));
        }
        return sb.toString();
    }

    public boolean isOverloadedBy(MethodInfo otherMthInfo) {
        return this.argTypes.size() == otherMthInfo.argTypes.size() && this.name.equals(otherMthInfo.name) && !Objects.equals(this.shortId, otherMthInfo.shortId);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.declClass.getFullName() + "." + this.name;
    }

    public String getAliasFullName() {
        return this.declClass.getAliasFullName() + "." + this.alias;
    }

    public String getFullId() {
        return this.declClass.getFullName() + "." + this.shortId;
    }

    public String getRawFullId() {
        return this.rawFullId;
    }

    public String getShortId() {
        return this.shortId;
    }

    public ClassInfo getDeclClass() {
        return this.declClass;
    }

    public ArgType getReturnType() {
        return this.retType;
    }

    public List<ArgType> getArgumentsTypes() {
        return this.argTypes;
    }

    public int getArgsCount() {
        return this.argTypes.size();
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean isClassInit() {
        return this.name.equals("<clinit>");
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void removeAlias() {
        this.alias = this.name;
    }

    public boolean hasAlias() {
        return !this.name.equals(this.alias);
    }

    public int calcHashCode() {
        return this.shortId.hashCode() + 31 * this.declClass.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.shortId.equals(other.shortId) && this.declClass.equals(other.declClass);
    }

    @Override
    public int compareTo(MethodInfo other) {
        int clsCmp = this.declClass.compareTo(other.declClass);
        if (clsCmp != 0) {
            return clsCmp;
        }
        return this.shortId.compareTo(other.shortId);
    }

    public String toString() {
        return this.declClass.getFullName() + "." + this.name + "(" + Utils.listToString(this.argTypes) + "):" + this.retType;
    }
}

