/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.info.PackageInfo;
import jadx.core.dex.instructions.args.ArgType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InfoStorage {
    private final Map<ArgType, ClassInfo> classes = new HashMap<ArgType, ClassInfo>();
    private final Map<FieldInfo, FieldInfo> fields = new HashMap<FieldInfo, FieldInfo>();
    private final Map<MethodInfo, MethodInfo> uniqueMethods = new HashMap<MethodInfo, MethodInfo>();
    private final Map<Integer, MethodInfo> methods = new HashMap<Integer, MethodInfo>();
    private final Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();

    public ClassInfo getCls(ArgType type) {
        return this.classes.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo putCls(ClassInfo cls) {
        Map<ArgType, ClassInfo> map = this.classes;
        synchronized (map) {
            ClassInfo prev = this.classes.put(cls.getType(), cls);
            return prev == null ? cls : prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getByUniqId(int id) {
        Map<Integer, MethodInfo> map = this.methods;
        synchronized (map) {
            return this.methods.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putByUniqId(int id, MethodInfo mth) {
        Map<Integer, MethodInfo> map = this.methods;
        synchronized (map) {
            this.methods.put(id, mth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo putMethod(MethodInfo newMth) {
        Map<MethodInfo, MethodInfo> map = this.uniqueMethods;
        synchronized (map) {
            MethodInfo prev = this.uniqueMethods.get(newMth);
            if (prev != null) {
                return prev;
            }
            this.uniqueMethods.put(newMth, newMth);
            return newMth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getField(FieldInfo field) {
        Map<FieldInfo, FieldInfo> map = this.fields;
        synchronized (map) {
            FieldInfo f = this.fields.get(field);
            if (f != null) {
                return f;
            }
            this.fields.put(field, field);
            return field;
        }
    }

    @Nullable
    public PackageInfo getPkg(String fullName) {
        return this.packages.get(fullName);
    }

    public void putPkg(PackageInfo pkg) {
        this.packages.put(pkg.getFullName(), pkg);
    }
}

