/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf.conditions;

import jadx.api.deobf.IDeobfCondition;
import jadx.core.deobf.conditions.AbstractDeobfCondition;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludePackageWithTLDNames
extends AbstractDeobfCondition {
    private static Set<String> loadTldFile() {
        Set<String> set;
        BufferedReader reader = new BufferedReader(new InputStreamReader(TldHolder.class.getResourceAsStream("tld_3.txt")));
        try {
            set = reader.lines().map(String::trim).filter(line -> !line.startsWith("#") && !line.isEmpty()).collect(Collectors.toSet());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to load top level domain list file: tld_3.txt", e);
            }
        }
        reader.close();
        return set;
    }

    @Override
    public IDeobfCondition.Action check(PackageNode pkg) {
        if (TldHolder.TLD_SET.contains(pkg.getName())) {
            return IDeobfCondition.Action.FORBID_RENAME;
        }
        return IDeobfCondition.Action.NO_ACTION;
    }

    private static class TldHolder {
        private static final Set<String> TLD_SET = ExcludePackageWithTLDNames.loadTldFile();

        private TldHolder() {
        }
    }
}

