/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf.conditions;

import jadx.api.JadxArgs;
import jadx.api.deobf.IDeobfCondition;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;

public class DeobfLengthCondition
implements IDeobfCondition {
    private int minLength;
    private int maxLength;

    @Override
    public void init(RootNode root) {
        JadxArgs args = root.getArgs();
        this.minLength = args.getDeobfuscationMinLength();
        this.maxLength = args.getDeobfuscationMaxLength();
    }

    private IDeobfCondition.Action checkName(String s) {
        int len = s.length();
        if (len < this.minLength || len > this.maxLength) {
            return IDeobfCondition.Action.FORCE_RENAME;
        }
        return IDeobfCondition.Action.NO_ACTION;
    }

    @Override
    public IDeobfCondition.Action check(PackageNode pkg) {
        return this.checkName(pkg.getName());
    }

    @Override
    public IDeobfCondition.Action check(ClassNode cls) {
        return this.checkName(cls.getName());
    }

    @Override
    public IDeobfCondition.Action check(FieldNode fld) {
        return this.checkName(fld.getName());
    }

    @Override
    public IDeobfCondition.Action check(MethodNode mth) {
        return this.checkName(mth.getName());
    }
}

