/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.pass.impl;

import jadx.api.plugins.pass.JadxPassInfo;
import java.util.ArrayList;
import java.util.List;

public class OrderedJadxPassInfo
implements JadxPassInfo {
    private final String name;
    private final String desc;
    private final List<String> runAfter;
    private final List<String> runBefore;

    public OrderedJadxPassInfo(String name, String desc) {
        this(name, desc, new ArrayList<String>(), new ArrayList<String>());
    }

    public OrderedJadxPassInfo(String name, String desc, List<String> runAfter, List<String> runBefore) {
        this.name = name;
        this.desc = desc;
        this.runAfter = runAfter;
        this.runBefore = runBefore;
    }

    public OrderedJadxPassInfo after(String pass) {
        this.runAfter.add(pass);
        return this;
    }

    public OrderedJadxPassInfo before(String pass) {
        this.runBefore.add(pass);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public List<String> runAfter() {
        return this.runAfter;
    }

    @Override
    public List<String> runBefore() {
        return this.runBefore;
    }

    public String toString() {
        return "PassInfo{'" + this.name + "', desc='" + this.desc + "', runAfter=" + this.runAfter + ", runBefore=" + this.runBefore + "}";
    }
}

