/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.io.File;

public class ResourceFile {
    private final JadxDecompiler decompiler;
    private final String name;
    private final ResourceType type;
    private ZipRef zipRef;
    private String deobfName;

    public static ResourceFile createResourceFile(JadxDecompiler decompiler, File file, ResourceType type) {
        return new ResourceFile(decompiler, file.getAbsolutePath(), type);
    }

    public static ResourceFile createResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        if (!ZipSecurity.isValidZipEntryName(name)) {
            return null;
        }
        return new ResourceFile(decompiler, name, type);
    }

    protected ResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        this.decompiler = decompiler;
        this.name = name;
        this.type = type;
    }

    public String getOriginalName() {
        return this.name;
    }

    public String getDeobfName() {
        return this.deobfName != null ? this.deobfName : this.name;
    }

    public void setDeobfName(String resFullName) {
        this.deobfName = resFullName;
    }

    public ResourceType getType() {
        return this.type;
    }

    public ResContainer loadContent() {
        return ResourcesLoader.loadContent(this.decompiler, this);
    }

    void setZipRef(ZipRef zipRef) {
        this.zipRef = zipRef;
    }

    public boolean setAlias(ResourceEntry ri) {
        String alias;
        StringBuilder sb = new StringBuilder();
        sb.append("res/").append(ri.getTypeName()).append(ri.getConfig());
        sb.append("/").append(ri.getKeyName());
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            sb.append(this.name.substring(lastDot));
        }
        if (!(alias = sb.toString()).equals(this.name)) {
            this.setDeobfName(alias);
            return true;
        }
        return false;
    }

    public ZipRef getZipRef() {
        return this.zipRef;
    }

    public String toString() {
        return "ResourceFile{name='" + this.name + "', type=" + this.type + "}";
    }

    public static final class ZipRef {
        private final File zipFile;
        private final String entryName;

        public ZipRef(File zipFile, String entryName) {
            this.zipFile = zipFile;
            this.entryName = entryName;
        }

        public File getZipFile() {
            return this.zipFile;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String toString() {
            return "ZipRef{" + this.zipFile + ", '" + this.entryName + "'}";
        }
    }
}

