/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.info.PackageInfo;
import jadx.core.dex.nodes.PackageNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class JavaPackage
implements JavaNode,
Comparable<JavaPackage> {
    private final PackageNode pkgNode;
    private final List<JavaClass> classes;
    private final List<JavaPackage> subPkgs;

    JavaPackage(PackageNode pkgNode, List<JavaClass> classes, List<JavaPackage> subPkgs) {
        this.pkgNode = pkgNode;
        this.classes = classes;
        this.subPkgs = subPkgs;
    }

    @Override
    public String getName() {
        return this.pkgNode.getAliasPkgInfo().getName();
    }

    @Override
    public String getFullName() {
        return this.pkgNode.getAliasPkgInfo().getFullName();
    }

    public String getRawName() {
        return this.pkgNode.getPkgInfo().getName();
    }

    public String getRawFullName() {
        return this.pkgNode.getPkgInfo().getFullName();
    }

    public List<JavaPackage> getSubPackages() {
        return this.subPkgs;
    }

    public List<JavaClass> getClasses() {
        return this.classes;
    }

    public boolean isRoot() {
        return this.pkgNode.isRoot();
    }

    public boolean isLeaf() {
        return this.pkgNode.isLeaf();
    }

    public boolean isDefault() {
        return this.getFullName().isEmpty();
    }

    public void rename(String alias) {
        this.pkgNode.rename(alias);
    }

    @Override
    public void removeAlias() {
        this.pkgNode.removeAlias();
    }

    public boolean isParentRenamed() {
        PackageInfo aliasParent;
        PackageInfo parent = this.pkgNode.getPkgInfo().getParentPkg();
        return !Objects.equals(parent, aliasParent = this.pkgNode.getAliasPkgInfo().getParentPkg());
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.pkgNode;
    }

    @ApiStatus.Internal
    public PackageNode getPkgNode() {
        return this.pkgNode;
    }

    @Override
    public JavaClass getDeclaringClass() {
        return null;
    }

    @Override
    public JavaClass getTopParentClass() {
        return null;
    }

    @Override
    public int getDefPos() {
        return 0;
    }

    @Override
    public List<JavaNode> getUseIn() {
        ArrayList<JavaNode> list = new ArrayList<JavaNode>();
        this.addUseIn(list);
        return list;
    }

    public void addUseIn(List<JavaNode> list) {
        list.addAll(this.classes);
        for (JavaPackage subPkg : this.subPkgs) {
            subPkg.addUseIn(list);
        }
    }

    @Override
    public boolean isOwnCodeAnnotation(ICodeAnnotation ann) {
        return false;
    }

    @Override
    public int compareTo(@NotNull JavaPackage o) {
        return this.pkgNode.compareTo(o.pkgNode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaPackage that = (JavaPackage)o;
        return this.pkgNode.equals(that.pkgNode);
    }

    public int hashCode() {
        return this.pkgNode.hashCode();
    }

    public String toString() {
        return this.pkgNode.toString();
    }
}

