/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.rename;

import jadx.api.JadxArgs;
import jadx.core.codegen.json.JsonMappingGen;
import jadx.core.deobf.Deobfuscator;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.rename.UserRenames;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class RenameVisitor
extends AbstractVisitor {
    private static final Pattern ANONYMOUS_CLASS_PATTERN = Pattern.compile("^\\d+$");

    @Override
    public void init(RootNode root) {
        List<File> inputFiles = root.getArgs().getInputFiles();
        if (inputFiles.isEmpty()) {
            return;
        }
        this.process(root);
    }

    private void process(RootNode root) {
        Deobfuscator deobfuscator = new Deobfuscator(root);
        JadxArgs args = root.getArgs();
        if (args.isDeobfuscationOn()) {
            deobfuscator.execute();
        }
        UserRenames.applyForNodes(root);
        RenameVisitor.checkClasses(deobfuscator, root, args);
        if (args.isDeobfuscationOn() || !args.isJsonOutput()) {
            deobfuscator.savePresets();
            deobfuscator.clear();
        }
        if (args.isJsonOutput()) {
            JsonMappingGen.dump(root);
        }
    }

    private static void checkClasses(Deobfuscator deobfuscator, RootNode root, JadxArgs args) {
        List<ClassNode> classes = root.getClasses(true);
        for (ClassNode cls : classes) {
            RenameVisitor.checkClassName(deobfuscator, cls, args);
            RenameVisitor.checkFields(deobfuscator, cls, args);
            RenameVisitor.checkMethods(deobfuscator, cls, args);
        }
        if (!args.isFsCaseSensitive() && args.isRenameCaseSensitive()) {
            HashSet<String> clsFullPaths = new HashSet<String>(classes.size());
            for (ClassNode cls : classes) {
                ClassInfo clsInfo = cls.getClassInfo();
                if (clsFullPaths.add(clsInfo.getAliasFullPath().toLowerCase())) continue;
                String newShortName = deobfuscator.getClsAlias(cls);
                clsInfo.changeShortName(newShortName);
                cls.addAttr(new RenameReasonAttr(cls).append("case insensitive filesystem"));
                clsFullPaths.add(clsInfo.getAliasFullPath().toLowerCase());
            }
        }
        RenameVisitor.processRootPackages(deobfuscator, root, classes);
    }

    private static void checkClassName(Deobfuscator deobfuscator, ClassNode cls, JadxArgs args) {
        ClassInfo classInfo = cls.getClassInfo();
        String clsName = classInfo.getAliasShortName();
        String newShortName = RenameVisitor.fixClsShortName(args, clsName);
        if (newShortName == null) {
            String deobfName = deobfuscator.getClsAlias(cls);
            classInfo.changeShortName(deobfName);
            cls.addAttr(new RenameReasonAttr(cls).notPrintable());
            return;
        }
        if (!newShortName.equals(clsName)) {
            classInfo.changeShortName(newShortName);
            cls.addAttr(new RenameReasonAttr(cls).append("invalid class name"));
        }
        if (classInfo.isInner() && args.isRenameValid()) {
            for (ClassInfo parentClass = classInfo.getParentClass(); parentClass != null; parentClass = parentClass.getParentClass()) {
                if (!parentClass.getAliasShortName().equals(newShortName)) continue;
                String clsAlias = deobfuscator.getClsAlias(cls);
                classInfo.changeShortName(clsAlias);
                cls.addAttr(new RenameReasonAttr(cls).append("collision with other inner class name"));
                break;
            }
        }
        RenameVisitor.checkPackage(deobfuscator, cls, classInfo, args);
    }

    private static void checkPackage(Deobfuscator deobfuscator, ClassNode cls, ClassInfo classInfo, JadxArgs args) {
        if (classInfo.isInner()) {
            return;
        }
        String aliasPkg = classInfo.getAliasPkg();
        if (args.isRenameValid() && aliasPkg.isEmpty()) {
            classInfo.changePkg("defpackage");
            cls.addAttr(new RenameReasonAttr(cls).append("default package"));
            return;
        }
        String fullPkgAlias = deobfuscator.getPkgAlias(cls);
        if (!fullPkgAlias.equals(aliasPkg)) {
            classInfo.changePkg(fullPkgAlias);
            cls.addAttr(new RenameReasonAttr(cls).append("invalid package"));
        }
    }

    @Nullable
    private static String fixClsShortName(JadxArgs args, String clsName) {
        String cleanClsName;
        boolean renameValid = args.isRenameValid();
        if (renameValid) {
            if (ANONYMOUS_CLASS_PATTERN.matcher(clsName).matches()) {
                return "AnonymousClass" + NameMapper.removeInvalidCharsMiddle(clsName);
            }
            char firstChar = clsName.charAt(0);
            if (firstChar == '$' || Character.isDigit(firstChar)) {
                return 'C' + NameMapper.removeInvalidCharsMiddle(clsName);
            }
        }
        String string = cleanClsName = args.isRenamePrintable() ? NameMapper.removeNonPrintableCharacters(clsName) : clsName;
        if (cleanClsName.isEmpty()) {
            return null;
        }
        if (renameValid && !NameMapper.isValidIdentifier(cleanClsName = NameMapper.removeInvalidChars(clsName, "C"))) {
            return 'C' + cleanClsName;
        }
        return cleanClsName;
    }

    private static void checkFields(Deobfuscator deobfuscator, ClassNode cls, JadxArgs args) {
        HashSet<String> names = new HashSet<String>();
        for (FieldNode field : cls.getFields()) {
            boolean notPrintable;
            FieldInfo fieldInfo = field.getFieldInfo();
            String fieldName = fieldInfo.getAlias();
            boolean notUnique = !names.add(fieldName);
            boolean notValid = args.isRenameValid() && !NameMapper.isValidIdentifier(fieldName);
            boolean bl = notPrintable = args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(fieldName);
            if (!notUnique && !notValid && !notPrintable) continue;
            deobfuscator.forceRenameField(field);
            field.addAttr(new RenameReasonAttr(field, notValid, notPrintable));
            if (!notUnique) continue;
            field.addAttr(new RenameReasonAttr(field).append("collision with other field name"));
        }
    }

    private static void checkMethods(Deobfuscator deobfuscator, ClassNode cls, JadxArgs args) {
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>(cls.getMethods().size());
        for (MethodNode method : cls.getMethods()) {
            if (method.getAccessFlags().isConstructor()) continue;
            methods.add(method);
        }
        for (MethodNode mth : methods) {
            boolean notPrintable;
            String alias = mth.getAlias();
            boolean notValid = args.isRenameValid() && !NameMapper.isValidIdentifier(alias);
            boolean bl = notPrintable = args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(alias);
            if (!notValid && !notPrintable) continue;
            deobfuscator.forceRenameMethod(mth);
            mth.addAttr(new RenameReasonAttr(mth, notValid, notPrintable));
        }
        if (args.isRenameValid()) {
            HashSet<String> names = new HashSet<String>(methods.size());
            for (MethodNode mth : methods) {
                String signature = mth.getMethodInfo().makeSignature(true, false);
                if (names.add(signature)) continue;
                deobfuscator.forceRenameMethod(mth);
                mth.addAttr(new RenameReasonAttr("collision with other method in class"));
            }
        }
    }

    private static void processRootPackages(Deobfuscator deobfuscator, RootNode root, List<ClassNode> classes) {
        Set<String> rootPkgs = RenameVisitor.collectRootPkgs(classes);
        root.getCacheStorage().setRootPkgs(rootPkgs);
        if (root.getArgs().isRenameValid()) {
            for (ClassNode cls : classes) {
                for (FieldNode field : cls.getFields()) {
                    if (!rootPkgs.contains(field.getAlias())) continue;
                    deobfuscator.forceRenameField(field);
                    field.addAttr(new RenameReasonAttr("collision with root package name"));
                }
            }
        }
    }

    private static Set<String> collectRootPkgs(List<ClassNode> classes) {
        HashSet<String> fullPkgs = new HashSet<String>();
        for (ClassNode cls : classes) {
            fullPkgs.add(cls.getClassInfo().getAliasPkg());
        }
        HashSet<String> rootPkgs = new HashSet<String>();
        for (String pkg : fullPkgs) {
            String rootPkg = RenameVisitor.getRootPkg(pkg);
            if (rootPkg == null) continue;
            rootPkgs.add(rootPkg);
        }
        return rootPkgs;
    }

    @Nullable
    private static String getRootPkg(String pkg) {
        if (pkg.isEmpty()) {
            return null;
        }
        int dotPos = pkg.indexOf(46);
        if (dotPos < 0) {
            return pkg;
        }
        return pkg.substring(0, dotPos);
    }
}

