/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BlockNode
extends AttrNode
implements IBlock,
Comparable<BlockNode> {
    private int id;
    private final int startOffset;
    private final List<InsnNode> instructions = new ArrayList<InsnNode>(2);
    private List<BlockNode> predecessors = new ArrayList<BlockNode>(1);
    private List<BlockNode> successors = new ArrayList<BlockNode>(1);
    private List<BlockNode> cleanSuccessors;
    private BitSet doms = EmptyBitSet.EMPTY;
    private BitSet domFrontier;
    private BlockNode idom;
    private List<BlockNode> dominatesOn = new ArrayList<BlockNode>(3);

    public BlockNode(int id, int offset) {
        this.id = id;
        this.startOffset = offset;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public List<BlockNode> getPredecessors() {
        return this.predecessors;
    }

    public List<BlockNode> getSuccessors() {
        return this.successors;
    }

    public List<BlockNode> getCleanSuccessors() {
        return this.cleanSuccessors;
    }

    public void updateCleanSuccessors() {
        this.cleanSuccessors = BlockNode.cleanSuccessors(this);
    }

    public void lock() {
        try {
            List<BlockNode> successorsList = this.successors;
            this.successors = Utils.lockList(successorsList);
            this.cleanSuccessors = successorsList == this.cleanSuccessors ? this.successors : Utils.lockList(this.cleanSuccessors);
            this.predecessors = Utils.lockList(this.predecessors);
            this.dominatesOn = Utils.lockList(this.dominatesOn);
            if (this.domFrontier == null) {
                throw new JadxRuntimeException("Dominance frontier not set for block: " + this);
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to lock block: " + this, e);
        }
    }

    private static List<BlockNode> cleanSuccessors(BlockNode block) {
        List<BlockNode> sucList = block.getSuccessors();
        if (sucList.isEmpty()) {
            return sucList;
        }
        ArrayList<BlockNode> toRemove = new ArrayList<BlockNode>(sucList.size());
        for (BlockNode b : sucList) {
            if (!BlockUtils.isExceptionHandlerPath(b)) continue;
            toRemove.add(b);
        }
        if (block.contains(AFlag.LOOP_END)) {
            List loops = block.getAll(AType.LOOP);
            for (LoopInfo loop : loops) {
                toRemove.add(loop.getStart());
            }
        }
        if (toRemove.isEmpty()) {
            return sucList;
        }
        ArrayList<BlockNode> result = new ArrayList<BlockNode>(sucList);
        result.removeAll(toRemove);
        return result;
    }

    @Override
    public List<InsnNode> getInstructions() {
        return this.instructions;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public boolean isDominator(BlockNode block) {
        return this.doms.get(block.getId());
    }

    public BitSet getDoms() {
        return this.doms;
    }

    public void setDoms(BitSet doms) {
        this.doms = doms;
    }

    public BitSet getDomFrontier() {
        return this.domFrontier;
    }

    public void setDomFrontier(BitSet domFrontier) {
        this.domFrontier = domFrontier;
    }

    public BlockNode getIDom() {
        return this.idom;
    }

    public void setIDom(BlockNode idom) {
        this.idom = idom;
    }

    public List<BlockNode> getDominatesOn() {
        return this.dominatesOn;
    }

    public void addDominatesOn(BlockNode block) {
        this.dominatesOn.add(block);
    }

    public boolean isSynthetic() {
        return this.contains(AFlag.SYNTHETIC);
    }

    public boolean isReturnBlock() {
        return this.contains(AFlag.RETURN);
    }

    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public int hashCode() {
        return this.startOffset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockNode)) {
            return false;
        }
        BlockNode other = (BlockNode)obj;
        return this.id == other.id && this.startOffset == other.startOffset;
    }

    @Override
    public int compareTo(@NotNull BlockNode o) {
        return Integer.compare(this.id, o.id);
    }

    @Override
    public String baseString() {
        return Integer.toString(this.id);
    }

    public String toString() {
        return "B:" + this.id + ':' + InsnUtils.formatOffset(this.startOffset);
    }
}

