/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.attributes.nodes.TmpEdgeAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlockSplitter
extends AbstractVisitor {
    private static final Set<InsnType> SEPARATE_INSNS = EnumSet.of(InsnType.RETURN, new InsnType[]{InsnType.IF, InsnType.SWITCH, InsnType.MONITOR_ENTER, InsnType.MONITOR_EXIT, InsnType.THROW, InsnType.MOVE_EXCEPTION});

    public static boolean isSeparate(InsnType insnType) {
        return SEPARATE_INSNS.contains((Object)insnType);
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        mth.initBasicBlocks();
        Map<Integer, BlockNode> blocksMap = BlockSplitter.splitBasicBlocks(mth);
        BlockSplitter.setupConnectionsFromJumps(mth, blocksMap);
        BlockSplitter.initBlocksInTargetNodes(mth);
        BlockSplitter.addTempConnectionsForExcHandlers(mth, blocksMap);
        BlockSplitter.expandMoveMulti(mth);
        BlockSplitter.removeJumpAttr(mth);
        BlockSplitter.removeInsns(mth);
        BlockSplitter.removeEmptyDetachedBlocks(mth);
        mth.getBasicBlocks().removeIf(BlockSplitter::removeEmptyBlock);
        BlockSplitter.setupExitConnections(mth);
        mth.unloadInsnArr();
    }

    private static Map<Integer, BlockNode> splitBasicBlocks(MethodNode mth) {
        BlockNode enterBlock = BlockSplitter.startNewBlock(mth, -1);
        enterBlock.add(AFlag.MTH_ENTER_BLOCK);
        mth.setEnterBlock(enterBlock);
        BlockNode exitBlock = BlockSplitter.startNewBlock(mth, -1);
        exitBlock.add(AFlag.MTH_EXIT_BLOCK);
        mth.setExitBlock(exitBlock);
        HashMap<Integer, BlockNode> blocksMap = new HashMap<Integer, BlockNode>();
        BlockNode curBlock = enterBlock;
        InsnNode prevInsn = null;
        for (InsnNode insn : mth.getInstructions()) {
            if (insn == null || insn.getType() == InsnType.NOP && insn.isAttrStorageEmpty()) continue;
            int insnOffset = insn.getOffset();
            if (prevInsn == null) {
                curBlock = BlockSplitter.connectNewBlock(mth, curBlock, insnOffset);
            } else {
                InsnType prevType = prevInsn.getType();
                switch (prevType) {
                    case RETURN: 
                    case THROW: 
                    case GOTO: 
                    case IF: 
                    case SWITCH: {
                        curBlock = BlockSplitter.startNewBlock(mth, insnOffset);
                        break;
                    }
                    default: {
                        if (!BlockSplitter.isSeparate(prevType) && !BlockSplitter.isSeparate(insn.getType()) && !insn.contains(AFlag.TRY_ENTER) && !prevInsn.contains(AFlag.TRY_LEAVE) && !insn.contains(AType.EXC_HANDLER) && !BlockSplitter.isSplitByJump(prevInsn, insn) && !BlockSplitter.isDoWhile(blocksMap, curBlock, insn)) break;
                        curBlock = BlockSplitter.connectNewBlock(mth, curBlock, insnOffset);
                    }
                }
            }
            blocksMap.put(insnOffset, curBlock);
            curBlock.getInstructions().add(insn);
            prevInsn = insn;
        }
        return blocksMap;
    }

    private static void initBlocksInTargetNodes(MethodNode mth) {
        mth.getBasicBlocks().forEach(block -> {
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn instanceof TargetInsnNode) {
                ((TargetInsnNode)lastInsn).initBlocks((BlockNode)block);
            }
        });
    }

    static BlockNode connectNewBlock(MethodNode mth, BlockNode block, int offset) {
        BlockNode newBlock = BlockSplitter.startNewBlock(mth, offset);
        BlockSplitter.connect(block, newBlock);
        return newBlock;
    }

    static BlockNode startNewBlock(MethodNode mth, int offset) {
        BlockNode block = new BlockNode(mth.getBasicBlocks().size(), offset);
        mth.getBasicBlocks().add(block);
        return block;
    }

    public static void connect(BlockNode from, BlockNode to) {
        if (!from.getSuccessors().contains(to)) {
            from.getSuccessors().add(to);
        }
        if (!to.getPredecessors().contains(from)) {
            to.getPredecessors().add(from);
        }
    }

    public static void removeConnection(BlockNode from, BlockNode to) {
        from.getSuccessors().remove(to);
        to.getPredecessors().remove(from);
    }

    public static void removePredecessors(BlockNode block) {
        for (BlockNode pred : block.getPredecessors()) {
            pred.getSuccessors().remove(block);
        }
        block.getPredecessors().clear();
    }

    public static void replaceConnection(BlockNode source, BlockNode oldDest, BlockNode newDest) {
        BlockSplitter.removeConnection(source, oldDest);
        BlockSplitter.connect(source, newDest);
        BlockSplitter.replaceTarget(source, oldDest, newDest);
    }

    static BlockNode insertBlockBetween(MethodNode mth, BlockNode source, BlockNode target) {
        BlockNode newBlock = BlockSplitter.startNewBlock(mth, target.getStartOffset());
        newBlock.add(AFlag.SYNTHETIC);
        BlockSplitter.removeConnection(source, target);
        BlockSplitter.connect(source, newBlock);
        BlockSplitter.connect(newBlock, target);
        BlockSplitter.replaceTarget(source, target, newBlock);
        source.updateCleanSuccessors();
        newBlock.updateCleanSuccessors();
        return newBlock;
    }

    static BlockNode blockSplitTop(MethodNode mth, BlockNode block) {
        BlockNode newBlock = BlockSplitter.startNewBlock(mth, block.getStartOffset());
        for (BlockNode pred : new ArrayList<BlockNode>(block.getPredecessors())) {
            BlockSplitter.replaceConnection(pred, block, newBlock);
            pred.updateCleanSuccessors();
        }
        BlockSplitter.connect(newBlock, block);
        newBlock.updateCleanSuccessors();
        return newBlock;
    }

    static void copyBlockData(BlockNode from, BlockNode to) {
        List<InsnNode> toInsns = to.getInstructions();
        for (InsnNode insn : from.getInstructions()) {
            toInsns.add(insn.copyWithoutSsa());
        }
        to.copyAttributesFrom(from);
    }

    static void replaceTarget(BlockNode source, BlockNode oldTarget, BlockNode newTarget) {
        InsnNode lastInsn = BlockUtils.getLastInsn(source);
        if (lastInsn instanceof TargetInsnNode) {
            ((TargetInsnNode)lastInsn).replaceTargetBlock(oldTarget, newTarget);
        }
    }

    private static void setupConnectionsFromJumps(MethodNode mth, Map<Integer, BlockNode> blocksMap) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                List jumps = insn.getAll(AType.JUMP);
                for (JumpInfo jump : jumps) {
                    BlockNode srcBlock = BlockSplitter.getBlock(jump.getSrc(), blocksMap);
                    BlockNode thisBlock = BlockSplitter.getBlock(jump.getDest(), blocksMap);
                    BlockSplitter.connect(srcBlock, thisBlock);
                }
            }
        }
    }

    private static void addTempConnectionsForExcHandlers(MethodNode mth, Map<Integer, BlockNode> blocksMap) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                CatchAttr catchAttr = insn.get(AType.EXC_CATCH);
                if (catchAttr == null) continue;
                for (ExceptionHandler handler : catchAttr.getHandlers()) {
                    BlockNode handlerBlock = BlockSplitter.getBlock(handler.getHandlerOffset(), blocksMap);
                    if (handlerBlock.contains(AType.TMP_EDGE)) continue;
                    List<BlockNode> preds = block.getPredecessors();
                    if (preds.isEmpty()) {
                        throw new JadxRuntimeException("Unexpected missing predecessor for block: " + block);
                    }
                    BlockNode start = preds.size() == 1 ? preds.get(0) : block;
                    if (start.getSuccessors().contains(handlerBlock)) continue;
                    BlockSplitter.connect(start, handlerBlock);
                    handlerBlock.addAttr(new TmpEdgeAttr(start));
                }
            }
        }
    }

    private static void setupExitConnections(MethodNode mth) {
        BlockNode exitBlock = mth.getExitBlock();
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!block.getSuccessors().isEmpty() || block == exitBlock) continue;
            BlockSplitter.connect(block, exitBlock);
            if (!BlockUtils.checkLastInsnType(block, InsnType.RETURN)) continue;
            block.add(AFlag.RETURN);
        }
    }

    private static boolean isSplitByJump(InsnNode prevInsn, InsnNode currentInsn) {
        List pJumps = prevInsn.getAll(AType.JUMP);
        for (JumpInfo jump : pJumps) {
            if (jump.getSrc() != prevInsn.getOffset()) continue;
            return true;
        }
        List cJumps = currentInsn.getAll(AType.JUMP);
        for (JumpInfo jump : cJumps) {
            if (jump.getDest() != currentInsn.getOffset()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDoWhile(Map<Integer, BlockNode> blocksMap, BlockNode curBlock, InsnNode insn) {
        if (insn.getType() != InsnType.IF) {
            return false;
        }
        IfNode ifs = (IfNode)insn;
        BlockNode targetBlock = blocksMap.get(ifs.getTarget());
        return targetBlock == curBlock;
    }

    private static BlockNode getBlock(int offset, Map<Integer, BlockNode> blocksMap) {
        BlockNode block = blocksMap.get(offset);
        if (block == null) {
            throw new JadxRuntimeException("Missing block: " + offset);
        }
        return block;
    }

    private static void expandMoveMulti(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            List<InsnNode> insnsList = block.getInstructions();
            int len = insnsList.size();
            for (int i = 0; i < len; ++i) {
                InsnNode insn = insnsList.get(i);
                if (insn.getType() != InsnType.MOVE_MULTI) continue;
                int mvCount = insn.getArgsCount() / 2;
                for (int j = 0; j < mvCount; ++j) {
                    InsnNode mv = new InsnNode(InsnType.MOVE, 1);
                    int startArg = j * 2;
                    mv.setResult((RegisterArg)insn.getArg(startArg));
                    mv.addArg(insn.getArg(startArg + 1));
                    mv.copyAttributesFrom(insn);
                    if (j == 0) {
                        mv.setOffset(insn.getOffset());
                        insnsList.set(i, mv);
                        continue;
                    }
                    insnsList.add(i + j, mv);
                }
                i += mvCount - 1;
                len = insnsList.size();
            }
        }
    }

    private static void removeJumpAttr(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                insn.remove(AType.JUMP);
            }
        }
    }

    private static void removeInsns(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            block.getInstructions().removeIf(insn -> {
                if (!insn.isAttrStorageEmpty()) {
                    return false;
                }
                InsnType insnType = insn.getType();
                return insnType == InsnType.GOTO || insnType == InsnType.NOP;
            });
        }
    }

    public static void detachMarkedBlocks(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!block.contains(AFlag.REMOVE)) continue;
            BlockSplitter.detachBlock(block);
        }
    }

    static boolean removeEmptyDetachedBlocks(MethodNode mth) {
        return mth.getBasicBlocks().removeIf(block -> block.getInstructions().isEmpty() && block.getPredecessors().isEmpty() && block.getSuccessors().isEmpty() && !block.contains(AFlag.MTH_ENTER_BLOCK) && !block.contains(AFlag.MTH_EXIT_BLOCK));
    }

    static boolean removeEmptyBlock(BlockNode block) {
        if (BlockSplitter.canRemoveBlock(block)) {
            if (block.getSuccessors().size() == 1) {
                BlockNode successor = block.getSuccessors().get(0);
                block.getPredecessors().forEach(pred -> {
                    pred.getSuccessors().remove(block);
                    BlockSplitter.connect(pred, successor);
                    BlockSplitter.replaceTarget(pred, block, successor);
                    pred.updateCleanSuccessors();
                });
                BlockSplitter.removeConnection(block, successor);
            } else {
                block.getPredecessors().forEach(pred -> {
                    pred.getSuccessors().remove(block);
                    pred.updateCleanSuccessors();
                });
            }
            block.add(AFlag.REMOVE);
            block.getSuccessors().clear();
            block.getPredecessors().clear();
            return true;
        }
        return false;
    }

    private static boolean canRemoveBlock(BlockNode block) {
        return block.getInstructions().isEmpty() && block.isAttrStorageEmpty() && block.getSuccessors().size() <= 1 && !block.getPredecessors().isEmpty() && !block.contains(AFlag.MTH_ENTER_BLOCK) && !block.contains(AFlag.MTH_EXIT_BLOCK);
    }

    static void collectSuccessors(BlockNode startBlock, BlockNode methodEnterBlock, Set<BlockNode> toRemove) {
        ArrayDeque<BlockNode> stack = new ArrayDeque<BlockNode>();
        stack.add(startBlock);
        while (!stack.isEmpty()) {
            BlockNode block = (BlockNode)stack.pop();
            if (toRemove.contains(block)) continue;
            toRemove.add(block);
            for (BlockNode successor : block.getSuccessors()) {
                if (successor == methodEnterBlock || !toRemove.containsAll(successor.getPredecessors())) continue;
                stack.push(successor);
            }
        }
    }

    static void detachBlock(BlockNode block) {
        for (BlockNode pred : block.getPredecessors()) {
            pred.getSuccessors().remove(block);
            pred.updateCleanSuccessors();
        }
        for (BlockNode successor : block.getSuccessors()) {
            successor.getPredecessors().remove(block);
        }
        block.add(AFlag.REMOVE);
        block.getInstructions().clear();
        block.getPredecessors().clear();
        block.getSuccessors().clear();
    }
}

