/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.ICodeCache;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.data.ICodeData;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.core.Jadx;
import jadx.core.ProcessClass;
import jadx.core.clsp.ClspGraph;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.InfoStorage;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeDataUpdateListener;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.utils.MethodUtils;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.utils.CacheStorage;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.ResTableParser;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNode {
    private static final Logger LOG = LoggerFactory.getLogger(RootNode.class);
    private final JadxArgs args;
    private final List<IDexTreeVisitor> preDecompilePasses;
    private final List<ICodeDataUpdateListener> codeDataUpdateListeners = new ArrayList<ICodeDataUpdateListener>();
    private final ProcessClass processClasses;
    private final ErrorsCounter errorsCounter = new ErrorsCounter();
    private final StringUtils stringUtils;
    private final ConstStorage constValues;
    private final InfoStorage infoStorage = new InfoStorage();
    private final CacheStorage cacheStorage = new CacheStorage();
    private final TypeUpdate typeUpdate;
    private final MethodUtils methodUtils;
    private final TypeUtils typeUtils;
    private final Map<ClassInfo, ClassNode> clsMap = new HashMap<ClassInfo, ClassNode>();
    private List<ClassNode> classes = new ArrayList<ClassNode>();
    private ClspGraph clsp;
    @Nullable
    private String appPackage;
    @Nullable
    private ClassNode appResClass;
    private boolean isProto;

    public RootNode(JadxArgs args) {
        this.args = args;
        this.preDecompilePasses = Jadx.getPreDecompilePassesList();
        this.processClasses = new ProcessClass(this.getArgs());
        this.stringUtils = new StringUtils(args);
        this.constValues = new ConstStorage(args);
        this.typeUpdate = new TypeUpdate(this);
        this.methodUtils = new MethodUtils(this);
        this.typeUtils = new TypeUtils(this);
        this.isProto = args.getInputFiles().size() > 0 && args.getInputFiles().get(0).getName().toLowerCase().endsWith(".aab");
    }

    public void loadClasses(List<ILoadResult> loadedInputs) {
        for (ILoadResult loadedInput : loadedInputs) {
            loadedInput.visitClasses(cls -> {
                try {
                    this.addClassNode(new ClassNode(this, (IClassData)cls));
                }
                catch (Exception e) {
                    this.addDummyClass((IClassData)cls, e);
                }
                Utils.checkThreadInterrupt();
            });
        }
        if (this.classes.size() != this.clsMap.size()) {
            RootNode.markDuplicatedClasses(this.classes);
        }
        this.classes = new ArrayList<ClassNode>(this.clsMap.values());
        int mthCount = this.classes.stream().mapToInt(c -> c.getMethods().size()).sum();
        int insnsCount = this.classes.stream().flatMap(c -> c.getMethods().stream()).mapToInt(MethodNode::getInsnsCount).sum();
        LOG.info("Loaded classes: {}, methods: {}, instructions: {}", new Object[]{this.classes.size(), mthCount, insnsCount});
        this.classes.sort(Comparator.comparing(ClassNode::getFullName));
        this.initInnerClasses();
    }

    private void addDummyClass(IClassData classData, Exception exc) {
        try {
            String typeStr = classData.getType();
            String name = null;
            try {
                ClassInfo clsInfo = ClassInfo.fromName(this, typeStr);
                if (clsInfo != null) {
                    name = clsInfo.getShortName();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to get name for class with type {}", (Object)typeStr, (Object)e);
            }
            if (name == null || name.isEmpty()) {
                name = "CLASS_" + typeStr;
            }
            ClassNode clsNode = ClassNode.addSyntheticClass(this, name, classData.getAccessFlags());
            ErrorsCounter.error(clsNode, "Load error", exc);
        }
        catch (Exception innerExc) {
            LOG.error("Failed to load class from file: {}", (Object)classData.getInputFileName(), (Object)exc);
        }
    }

    private static void markDuplicatedClasses(List<ClassNode> classes) {
        classes.stream().collect(Collectors.groupingBy(ClassNode::getClassInfo)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            List<String> sources = Utils.collectionMap((Collection)entry.getValue(), ClassNode::getInputFileName);
            LOG.warn("Found duplicated class: {}, count: {}. Only one will be loaded!\n  {}", new Object[]{entry.getKey(), ((List)entry.getValue()).size(), String.join((CharSequence)"\n  ", sources)});
            ((List)entry.getValue()).forEach(cls -> {
                String thisSource = cls.getInputFileName();
                String otherSourceStr = sources.stream().filter(s -> !s.equals(thisSource)).sorted().collect(Collectors.joining("\n  "));
                cls.addWarnComment("Classes with same name are omitted:\n  " + otherSourceStr + '\n');
            });
        });
    }

    public void addClassNode(ClassNode clsNode) {
        this.classes.add(clsNode);
        this.clsMap.put(clsNode.getClassInfo(), clsNode);
    }

    public void loadResources(List<ResourceFile> resources) {
        ResourceFile arsc = null;
        for (ResourceFile rf : resources) {
            if (rf.getType() != ResourceType.ARSC) continue;
            arsc = rf;
            break;
        }
        if (arsc == null) {
            LOG.debug("'.arsc' file not found");
            return;
        }
        try {
            ResTableParser parser = ResourcesLoader.decodeStream(arsc, (size, is) -> {
                ResTableParser tableParser = new ResTableParser(this);
                tableParser.decode(is);
                return tableParser;
            });
            if (parser != null) {
                this.processResources(parser.getResStorage());
                this.updateObfuscatedFiles(parser, resources);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse '.arsc' file", (Throwable)e);
        }
    }

    public void processResources(ResourceStorage resStorage) {
        this.constValues.setResourcesNames(resStorage.getResourcesNames());
        this.appPackage = resStorage.getAppPackage();
        this.appResClass = AndroidResourcesUtils.searchAppResClass(this, resStorage);
    }

    public void initClassPath() {
        try {
            if (this.clsp == null) {
                ClspGraph newClsp = new ClspGraph(this);
                newClsp.load();
                newClsp.addApp(this.classes);
                newClsp.initCache();
                this.clsp = newClsp;
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error loading jadx class set", e);
        }
    }

    private void updateObfuscatedFiles(ResTableParser parser, List<ResourceFile> resources) {
        if (this.args.isSkipResources()) {
            return;
        }
        long start = System.currentTimeMillis();
        int renamedCount = 0;
        ResourceStorage resStorage = parser.getResStorage();
        ValuesParser valuesParser = new ValuesParser(parser.getStrings(), resStorage.getResourcesNames());
        HashMap<String, ResourceEntry> entryNames = new HashMap<String, ResourceEntry>();
        for (ResourceEntry resEntry : resStorage.getResources()) {
            String val = valuesParser.getSimpleValueString(resEntry);
            if (val == null) continue;
            entryNames.put(val, resEntry);
        }
        for (ResourceFile resource : resources) {
            ResourceEntry resEntry = (ResourceEntry)entryNames.get(resource.getOriginalName());
            if (resEntry == null) continue;
            resource.setAlias(resEntry);
            ++renamedCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Renamed obfuscated resources: {}, duration: {}ms", (Object)renamedCount, (Object)(System.currentTimeMillis() - start));
        }
    }

    private void initInnerClasses() {
        ArrayList<ClassNode> inner = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (!cls.getClassInfo().isInner()) continue;
            inner.add(cls);
        }
        ArrayList<ClassNode> updated = new ArrayList<ClassNode>();
        for (ClassNode cls : inner) {
            ClassInfo clsInfo = cls.getClassInfo();
            ClassNode parent = this.resolveClass(clsInfo.getParentClass());
            if (parent == null) {
                this.clsMap.remove(clsInfo);
                clsInfo.notInner(this);
                this.clsMap.put(clsInfo, cls);
                updated.add(cls);
                continue;
            }
            parent.addInnerClass(cls);
        }
        for (ClassNode updCls : updated) {
            for (ClassNode innerCls : updCls.getInnerClasses()) {
                innerCls.getClassInfo().updateNames(this);
            }
        }
        this.classes.forEach(ClassNode::updateParentClass);
    }

    public void runPreDecompileStage() {
        boolean debugEnabled = LOG.isDebugEnabled();
        for (IDexTreeVisitor pass : this.preDecompilePasses) {
            Utils.checkThreadInterrupt();
            long start = debugEnabled ? System.currentTimeMillis() : 0L;
            try {
                pass.init(this);
            }
            catch (Exception e) {
                LOG.error("Visitor init failed: {}", (Object)pass.getClass().getSimpleName(), (Object)e);
            }
            for (ClassNode cls : this.classes) {
                if (cls.isInner()) continue;
                DepthTraversal.visit(pass, cls);
            }
            if (!debugEnabled) continue;
            LOG.debug("{} time: {}ms", (Object)pass.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - start));
        }
    }

    public void runPreDecompileStageForClass(ClassNode cls) {
        for (IDexTreeVisitor pass : this.preDecompilePasses) {
            DepthTraversal.visit(pass, cls);
        }
    }

    public List<ClassNode> getClasses() {
        return this.classes;
    }

    public List<ClassNode> getClassesWithoutInner() {
        return this.getClasses(false);
    }

    public List<ClassNode> getClasses(boolean includeInner) {
        if (includeInner) {
            return this.classes;
        }
        ArrayList<ClassNode> notInnerClasses = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (cls.getClassInfo().isInner()) continue;
            notInnerClasses.add(cls);
        }
        return notInnerClasses;
    }

    @Nullable
    public ClassNode resolveClass(ClassInfo clsInfo) {
        return this.clsMap.get(clsInfo);
    }

    @Nullable
    public ClassNode resolveClass(ArgType clsType) {
        if (!clsType.isTypeKnown() || clsType.isGenericType()) {
            return null;
        }
        if (clsType.getWildcardBound() == ArgType.WildcardBound.UNBOUND) {
            return null;
        }
        if (clsType.isGeneric()) {
            clsType = ArgType.object(clsType.getObject());
        }
        return this.resolveClass(ClassInfo.fromType(this, clsType));
    }

    @Nullable
    public ClassNode resolveClass(String fullName) {
        ClassInfo clsInfo = ClassInfo.fromName(this, fullName);
        return this.resolveClass(clsInfo);
    }

    @Nullable
    public ClassNode searchClassByFullAlias(String fullName) {
        for (ClassNode cls : this.classes) {
            ClassInfo classInfo = cls.getClassInfo();
            if (!classInfo.getFullName().equals(fullName) && !classInfo.getAliasFullName().equals(fullName)) continue;
            return cls;
        }
        return null;
    }

    public Map<String, ClassNode> buildFullAliasClassCache() {
        HashMap<String, ClassNode> classNameCache = new HashMap<String, ClassNode>(this.classes.size());
        for (ClassNode cls : this.classes) {
            ClassInfo classInfo = cls.getClassInfo();
            String fullName = classInfo.getFullName();
            String alias = classInfo.getAliasFullName();
            classNameCache.put(fullName, cls);
            if (alias == null || fullName.equals(alias)) continue;
            classNameCache.put(alias, cls);
        }
        return classNameCache;
    }

    public List<ClassNode> searchClassByShortName(String shortName) {
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (!cls.getClassInfo().getShortName().equals(shortName)) continue;
            list.add(cls);
        }
        return list;
    }

    @Nullable
    public MethodNode resolveMethod(@NotNull MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls == null) {
            return null;
        }
        MethodNode methodNode = cls.searchMethod(mth);
        if (methodNode != null) {
            return methodNode;
        }
        return this.deepResolveMethod(cls, mth.makeSignature(false));
    }

    @Nullable
    private MethodNode deepResolveMethod(@NotNull ClassNode cls, String signature) {
        MethodNode found;
        ClassNode superNode;
        for (MethodNode m : cls.getMethods()) {
            if (!m.getMethodInfo().getShortId().startsWith(signature)) continue;
            return m;
        }
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (superNode = this.resolveClass(superClass)) != null && (found = this.deepResolveMethod(superNode, signature)) != null) {
            return found;
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            ClassNode iFaceNode = this.resolveClass(iFaceType);
            if (iFaceNode == null || (found = this.deepResolveMethod(iFaceNode, signature)) == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public FieldNode resolveField(FieldInfo field) {
        ClassNode cls = this.resolveClass(field.getDeclClass());
        if (cls == null) {
            return null;
        }
        FieldNode fieldNode = cls.searchField(field);
        if (fieldNode != null) {
            return fieldNode;
        }
        return this.deepResolveField(cls, field);
    }

    @Nullable
    private FieldNode deepResolveField(@NotNull ClassNode cls, FieldInfo fieldInfo) {
        FieldNode found;
        ClassNode superNode;
        FieldNode field = cls.searchFieldByNameAndType(fieldInfo);
        if (field != null) {
            return field;
        }
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (superNode = this.resolveClass(superClass)) != null && (found = this.deepResolveField(superNode, fieldInfo)) != null) {
            return found;
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            FieldNode found2;
            ClassNode iFaceNode = this.resolveClass(iFaceType);
            if (iFaceNode == null || (found2 = this.deepResolveField(iFaceNode, fieldInfo)) == null) continue;
            return found2;
        }
        return null;
    }

    public ProcessClass getProcessClasses() {
        return this.processClasses;
    }

    public List<IDexTreeVisitor> getPasses() {
        return this.processClasses.getPasses();
    }

    public void initPasses() {
        this.processClasses.initPasses(this);
    }

    public ICodeWriter makeCodeWriter() {
        JadxArgs jadxArgs = this.args;
        return jadxArgs.getCodeWriterProvider().apply(jadxArgs);
    }

    public void registerCodeDataUpdateListener(ICodeDataUpdateListener listener) {
        this.codeDataUpdateListeners.add(listener);
    }

    public void notifyCodeDataListeners() {
        ICodeData codeData = this.args.getCodeData();
        this.codeDataUpdateListeners.forEach(l -> l.updated(codeData));
    }

    public ClspGraph getClsp() {
        return this.clsp;
    }

    public ErrorsCounter getErrorsCounter() {
        return this.errorsCounter;
    }

    @Nullable
    public String getAppPackage() {
        return this.appPackage;
    }

    @Nullable
    public ClassNode getAppResClass() {
        return this.appResClass;
    }

    public StringUtils getStringUtils() {
        return this.stringUtils;
    }

    public ConstStorage getConstValues() {
        return this.constValues;
    }

    public InfoStorage getInfoStorage() {
        return this.infoStorage;
    }

    public CacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    public JadxArgs getArgs() {
        return this.args;
    }

    public TypeUpdate getTypeUpdate() {
        return this.typeUpdate;
    }

    public TypeCompare getTypeCompare() {
        return this.typeUpdate.getTypeCompare();
    }

    public ICodeCache getCodeCache() {
        return this.args.getCodeCache();
    }

    public MethodUtils getMethodUtils() {
        return this.methodUtils;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    public boolean isProto() {
        return this.isProto;
    }
}

