/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.loops;

import jadx.api.ICodeWriter;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.ConditionRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class LoopRegion
extends ConditionRegion {
    private final LoopInfo info;
    private final boolean conditionAtEnd;
    @Nullable
    private final BlockNode header;
    @Nullable
    private BlockNode preCondition;
    private IRegion body;
    private LoopType type;

    public LoopRegion(IRegion parent, LoopInfo info, @Nullable BlockNode header, boolean reversed) {
        super(parent);
        this.info = info;
        this.header = header;
        this.conditionAtEnd = reversed;
        if (header != null) {
            this.updateCondition(header);
        }
    }

    public LoopInfo getInfo() {
        return this.info;
    }

    @Nullable
    public BlockNode getHeader() {
        return this.header;
    }

    public IRegion getBody() {
        return this.body;
    }

    public void setBody(IRegion body) {
        this.body = body;
    }

    public boolean isConditionAtEnd() {
        return this.conditionAtEnd;
    }

    public void setPreCondition(BlockNode preCondition) {
        this.preCondition = preCondition;
    }

    public boolean checkPreCondition() {
        List<InsnNode> insns = this.preCondition.getInstructions();
        if (insns.isEmpty()) {
            return true;
        }
        IfCondition condition = this.getCondition();
        if (condition == null) {
            return false;
        }
        List<RegisterArg> conditionArgs = condition.getRegisterArgs();
        if (conditionArgs.isEmpty()) {
            return false;
        }
        int size = insns.size();
        for (int i = 0; i < size; ++i) {
            InsnNode insn = insns.get(i);
            if (insn.getResult() == null) {
                return false;
            }
            RegisterArg res = insn.getResult();
            if (res.getSVar().getUseCount() > 1) {
                return false;
            }
            boolean found = false;
            for (int j = i + 1; j < size; ++j) {
                if (!insns.get(i).containsVar(res)) continue;
                found = true;
            }
            if (!found && InsnUtils.containsVar(conditionArgs, res)) {
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void mergePreCondition() {
        if (this.preCondition != null && this.header != null) {
            List<InsnNode> condInsns = this.header.getInstructions();
            List<InsnNode> preCondInsns = this.preCondition.getInstructions();
            preCondInsns.addAll(condInsns);
            condInsns.clear();
            condInsns.addAll(preCondInsns);
            preCondInsns.clear();
            this.preCondition = null;
        }
    }

    public int getSourceLine() {
        int headerLine;
        InsnNode lastInsn = BlockUtils.getLastInsn(this.header);
        int n = headerLine = lastInsn == null ? 0 : lastInsn.getSourceLine();
        if (headerLine != 0) {
            return headerLine;
        }
        return this.getConditionSourceLine();
    }

    public LoopType getType() {
        return this.type;
    }

    public void setType(LoopType type) {
        this.type = type;
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(2 + this.getConditionBlocks().size());
        if (this.preCondition != null) {
            all.add(this.preCondition);
        }
        all.addAll(this.getConditionBlocks());
        if (this.body != null) {
            all.add(this.body);
        }
        return all;
    }

    @Override
    public boolean replaceSubBlock(IContainer oldBlock, IContainer newBlock) {
        return false;
    }

    @Override
    public void generate(RegionGen regionGen, ICodeWriter code) throws CodegenException {
        regionGen.makeLoop(this, code);
    }

    @Override
    public String baseString() {
        return this.body == null ? "-" : this.body.baseString();
    }

    public String toString() {
        return "LOOP:" + this.info.getId() + ": " + this.baseString();
    }
}

