/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoopInfo {
    private final BlockNode start;
    private final BlockNode end;
    private final Set<BlockNode> loopBlocks;
    private int id;
    private LoopInfo parentLoop;

    public LoopInfo(BlockNode start, BlockNode end, Set<BlockNode> loopBlocks) {
        this.start = start;
        this.end = end;
        this.loopBlocks = loopBlocks;
    }

    public BlockNode getStart() {
        return this.start;
    }

    public BlockNode getEnd() {
        return this.end;
    }

    public Set<BlockNode> getLoopBlocks() {
        return this.loopBlocks;
    }

    public Set<BlockNode> getExitNodes() {
        HashSet<BlockNode> nodes = new HashSet<BlockNode>();
        Set<BlockNode> blocks = this.getLoopBlocks();
        for (BlockNode block : blocks) {
            for (BlockNode s : block.getSuccessors()) {
                if (blocks.contains(s) || s.contains(AType.EXC_HANDLER)) continue;
                nodes.add(block);
            }
        }
        return nodes;
    }

    public List<Edge> getExitEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Set<BlockNode> blocks = this.getLoopBlocks();
        for (BlockNode block : blocks) {
            for (BlockNode s : block.getSuccessors()) {
                if (blocks.contains(s) || BlockUtils.isExceptionHandlerPath(s)) continue;
                edges.add(new Edge(block, s));
            }
        }
        return edges;
    }

    public BlockNode getPreHeader() {
        return BlockUtils.selectOther(this.end, this.start.getPredecessors());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public LoopInfo getParentLoop() {
        return this.parentLoop;
    }

    public void setParentLoop(LoopInfo parentLoop) {
        this.parentLoop = parentLoop;
    }

    public String toString() {
        return "LOOP:" + this.id + ": " + this.start + "->" + this.end;
    }
}

