/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.data.annotations;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.MethodNode;
import org.jetbrains.annotations.Nullable;

public class VarRef {
    private final MethodNode mth;
    private final int reg;
    private final int ssa;
    private final ArgType type;
    private String name;

    @Nullable
    public static VarRef get(MethodNode mth, RegisterArg reg) {
        SSAVar ssaVar = reg.getSVar();
        if (ssaVar == null) {
            return null;
        }
        CodeVar codeVar = ssaVar.getCodeVar();
        VarRef cachedVarRef = codeVar.getCachedVarRef();
        if (cachedVarRef != null) {
            if (cachedVarRef.getName() == null) {
                cachedVarRef.setName(codeVar.getName());
            }
            return cachedVarRef;
        }
        VarRef newVarRef = new VarRef(mth, ssaVar);
        codeVar.setCachedVarRef(newVarRef);
        return newVarRef;
    }

    protected VarRef(MethodNode mth, SSAVar ssaVar) {
        this(mth, ssaVar.getRegNum(), ssaVar.getVersion(), ssaVar.getCodeVar().getType(), ssaVar.getCodeVar().getName());
    }

    private VarRef(MethodNode mth, int reg, int ssa, ArgType type, String name) {
        this.mth = mth;
        this.reg = reg;
        this.ssa = ssa;
        this.type = type;
        this.name = name;
    }

    public MethodNode getMth() {
        return this.mth;
    }

    public int getReg() {
        return this.reg;
    }

    public int getSsa() {
        return this.ssa;
    }

    public ArgType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VarRef)) {
            return false;
        }
        VarRef other = (VarRef)o;
        return this.getReg() == other.getReg() && this.getSsa() == other.getSsa() && this.getMth().equals(other.getMth());
    }

    public int hashCode() {
        return 31 * this.getReg() + this.getSsa();
    }

    public String toString() {
        return "VarUseRef{r" + this.reg + 'v' + this.ssa + '}';
    }
}

