/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.android;

import jadx.api.ICodeWriter;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.codegen.ClassGen;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidResourcesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidResourcesUtils.class);

    private AndroidResourcesUtils() {
    }

    public static ClassNode searchAppResClass(RootNode root, ResourceStorage resStorage) {
        String appPackage = root.getAppPackage();
        String fullName = appPackage != null ? appPackage + ".R" : "R";
        ClassInfo clsInfo = ClassInfo.fromName(root, fullName);
        ClassNode resCls = root.resolveClass(clsInfo);
        if (resCls != null) {
            AndroidResourcesUtils.addResourceFields(resCls, resStorage, true);
            return resCls;
        }
        LOG.info("Can't find 'R' class in app package: {}", (Object)appPackage);
        List<ClassNode> candidates = root.searchClassByShortName("R");
        if (candidates.size() == 1) {
            ClassNode resClsCandidate = candidates.get(0);
            AndroidResourcesUtils.addResourceFields(resClsCandidate, resStorage, true);
            return resClsCandidate;
        }
        if (!candidates.isEmpty()) {
            LOG.info("Found several 'R' class candidates: {}", candidates);
        }
        LOG.info("App 'R' class not found, put all resources ids into : '{}'", (Object)fullName);
        ClassNode rCls = ClassNode.addSyntheticClass(root, clsInfo, 17);
        rCls.addInfoComment("This class is generated by JADX");
        AndroidResourcesUtils.addResourceFields(rCls, resStorage, false);
        return rCls;
    }

    public static boolean handleAppResField(ICodeWriter code, ClassGen clsGen, ClassInfo declClass) {
        ClassInfo parentClass = declClass.getParentClass();
        if (parentClass != null && parentClass.getShortName().equals("R")) {
            clsGen.useClass(code, parentClass);
            code.add('.');
            code.add(declClass.getAliasShortName());
            return true;
        }
        return false;
    }

    public static boolean handleResourceFieldValue(ClassNode cls, ICodeWriter code, long lit, ArgType type) {
        if (type.equals(ArgType.INT) && AndroidResourcesUtils.isResourceClass(cls)) {
            code.add(String.format("0x%08x", lit));
            return true;
        }
        return false;
    }

    public static boolean isResourceClass(ClassNode cls) {
        ClassNode parentClass = cls.getParentClass();
        return parentClass != null && parentClass.getShortName().equals("R");
    }

    private static void addResourceFields(ClassNode resCls, ResourceStorage resStorage, boolean rClsExists) {
        Map<Integer, FieldNode> resFieldsMap = AndroidResourcesUtils.fillResFieldsMap(resCls);
        TreeMap<String, ResClsInfo> innerClsMap = new TreeMap<String, ResClsInfo>();
        if (rClsExists) {
            for (ClassNode innerClass : resCls.getInnerClasses()) {
                ResClsInfo innerResCls = new ResClsInfo(innerClass);
                innerClass.getFields().forEach(field -> innerResCls.getFieldsMap().put(field.getName(), (FieldNode)field));
                innerClsMap.put(innerClass.getShortName(), innerResCls);
            }
        }
        for (ResourceEntry resource : resStorage.getResources()) {
            String resTypeName = resource.getTypeName();
            String resName = resTypeName.equals("style") ? resource.getKeyName().replace('.', '_') : resource.getKeyName();
            ResClsInfo typeClsInfo = innerClsMap.computeIfAbsent(resTypeName, name -> AndroidResourcesUtils.getClassForResType(resCls, rClsExists, name));
            typeClsInfo.getFieldsMap().computeIfAbsent(resName, name -> {
                ClassNode typeCls = typeClsInfo.getTypeCls();
                FieldInfo rFieldInfo = FieldInfo.from(typeCls.root(), typeCls.getClassInfo(), resName, ArgType.INT);
                FieldNode newResField = new FieldNode(typeCls, rFieldInfo, 25);
                newResField.addAttr((IJadxAttribute)new EncodedValue(EncodedType.ENCODED_INT, (Object)resource.getId()));
                typeCls.getFields().add(newResField);
                if (rClsExists) {
                    newResField.addInfoComment("Added by JADX");
                }
                return newResField;
            });
            FieldNode fieldNode = resFieldsMap.get(resource.getId());
            if (fieldNode == null || fieldNode.getName().equals(resName) || !NameMapper.isValidAndPrintable(resName) || !resCls.root().getArgs().isRenameValid()) continue;
            fieldNode.add(AFlag.DONT_RENAME);
            fieldNode.getFieldInfo().setAlias(resName);
        }
    }

    @NotNull
    private static ResClsInfo getClassForResType(ClassNode resCls, boolean rClsExists, String typeName) {
        String clsFullName = resCls.getFullName() + '$' + typeName;
        ClassInfo clsInfo = ClassInfo.fromName(resCls.root(), clsFullName);
        ClassNode existCls = resCls.root().resolveClass(clsInfo);
        if (existCls != null) {
            if (!rClsExists && !existCls.isInner()) {
                existCls.getClassInfo().convertToInner(resCls);
                resCls.addInnerClass(existCls);
            }
            ResClsInfo resClsInfo = new ResClsInfo(existCls);
            existCls.getFields().forEach(field -> resClsInfo.getFieldsMap().put(field.getName(), (FieldNode)field));
            return resClsInfo;
        }
        ClassNode newTypeCls = ClassNode.addSyntheticClass(resCls.root(), clsInfo, 25);
        resCls.addInnerClass(newTypeCls);
        if (rClsExists) {
            newTypeCls.addInfoComment("Added by JADX");
        }
        return new ResClsInfo(newTypeCls);
    }

    @NotNull
    private static Map<Integer, FieldNode> fillResFieldsMap(ClassNode resCls) {
        HashMap<Integer, FieldNode> resFieldsMap = new HashMap<Integer, FieldNode>();
        ConstStorage constStorage = resCls.root().getConstValues();
        Map<Object, FieldNode> constFields = constStorage.getGlobalConstFields();
        for (Map.Entry<Object, FieldNode> entry : constFields.entrySet()) {
            Object key = entry.getKey();
            FieldNode field = entry.getValue();
            AccessInfo accessFlags = field.getAccessFlags();
            if (!field.getType().equals(ArgType.INT) || !accessFlags.isStatic() || !accessFlags.isFinal() || !(key instanceof Integer)) continue;
            resFieldsMap.put((Integer)key, field);
        }
        return resFieldsMap;
    }

    private static final class ResClsInfo {
        private final ClassNode typeCls;
        private final Map<String, FieldNode> fieldsMap = new HashMap<String, FieldNode>();

        private ResClsInfo(ClassNode typeCls) {
            this.typeCls = typeCls;
        }

        public ClassNode getTypeCls() {
            return this.typeCls;
        }

        public Map<String, FieldNode> getFieldsMap() {
            return this.fieldsMap;
        }
    }
}

