/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrList;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RegionUtils {
    private RegionUtils() {
    }

    public static boolean hasExitEdge(IContainer container) {
        if (container instanceof IBlock) {
            return BlockUtils.containsExitInsn((IBlock)container);
        }
        if (container instanceof IBranchRegion) {
            for (IContainer br : ((IBranchRegion)container).getBranches()) {
                if (br != null && RegionUtils.hasExitEdge(br)) continue;
                return false;
            }
            return true;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            List<IContainer> blocks = region.getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasExitEdge(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static InsnNode getFirstInsn(IContainer container) {
        if (container instanceof IBlock) {
            IBlock block = (IBlock)container;
            List<InsnNode> insnList = block.getInstructions();
            if (insnList.isEmpty()) {
                return null;
            }
            return insnList.get(0);
        }
        if (container instanceof IBranchRegion) {
            return null;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            List<IContainer> blocks = region.getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            return RegionUtils.getFirstInsn(blocks.get(0));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static InsnNode getLastInsn(IContainer container) {
        if (container instanceof IBlock) {
            IBlock block = (IBlock)container;
            List<InsnNode> insnList = block.getInstructions();
            if (insnList.isEmpty()) {
                return null;
            }
            return insnList.get(insnList.size() - 1);
        }
        if (container instanceof IBranchRegion) {
            return null;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            List<IContainer> blocks = region.getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            return RegionUtils.getLastInsn(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static IBlock getLastBlock(IContainer container) {
        if (container instanceof IBlock) {
            return (IBlock)container;
        }
        if (container instanceof IBranchRegion) {
            return null;
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            return RegionUtils.getLastBlock(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean hasExitBlock(IContainer container) {
        return RegionUtils.hasExitBlock(container, container);
    }

    private static boolean hasExitBlock(IContainer rootContainer, IContainer container) {
        if (container instanceof BlockNode) {
            BlockNode blockNode = (BlockNode)container;
            if (blockNode.getSuccessors().isEmpty()) {
                return true;
            }
            return RegionUtils.isInsnExitContainer(rootContainer, (IBlock)container);
        }
        if (container instanceof IBranchRegion) {
            return false;
        }
        if (container instanceof IBlock) {
            return RegionUtils.isInsnExitContainer(rootContainer, (IBlock)container);
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasExitBlock(rootContainer, blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    private static boolean isInsnExitContainer(IContainer rootContainer, IBlock block) {
        InsnNode lastInsn = BlockUtils.getLastInsn(block);
        if (lastInsn == null) {
            return false;
        }
        InsnType insnType = lastInsn.getType();
        if (insnType == InsnType.RETURN) {
            return true;
        }
        if (insnType == InsnType.THROW) {
            CatchAttr catchAttr = lastInsn.get(AType.EXC_CATCH);
            if (catchAttr != null) {
                for (ExceptionHandler handler : catchAttr.getHandlers()) {
                    if (!RegionUtils.isRegionContainsBlock(rootContainer, handler.getHandlerBlock())) continue;
                    return false;
                }
            }
            return true;
        }
        if (insnType == InsnType.BREAK) {
            LoopLabelAttr loopLabelAttr;
            AttrList<LoopInfo> loopInfoAttrList = lastInsn.get(AType.LOOP);
            if (loopInfoAttrList != null) {
                for (LoopInfo loopInfo : loopInfoAttrList.getList()) {
                    if (RegionUtils.isRegionContainsBlock(rootContainer, loopInfo.getStart())) continue;
                    return true;
                }
            }
            if ((loopLabelAttr = lastInsn.get(AType.LOOP_LABEL)) != null && !RegionUtils.isRegionContainsBlock(rootContainer, loopLabelAttr.getLoop().getStart())) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasBreakInsn(IContainer container) {
        if (container instanceof IBlock) {
            return BlockUtils.checkLastInsnType((IBlock)container, InsnType.BREAK);
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasBreakInsn(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException("Unknown container type: " + container);
    }

    public static int insnsCount(IContainer container) {
        if (container instanceof IBlock) {
            return ((IBlock)container).getInstructions().size();
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            int count = 0;
            for (IContainer block : region.getSubBlocks()) {
                count += RegionUtils.insnsCount(block);
            }
            return count;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean isEmpty(IContainer container) {
        return !RegionUtils.notEmpty(container);
    }

    public static boolean notEmpty(@Nullable IContainer container) {
        if (container == null) {
            return false;
        }
        if (container instanceof IBlock) {
            List<InsnNode> insnList = ((IBlock)container).getInstructions();
            for (InsnNode insnNode : insnList) {
                if (insnNode.contains(AFlag.DONT_GENERATE)) continue;
                return true;
            }
            return false;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer block : region.getSubBlocks()) {
                if (!RegionUtils.notEmpty(block)) continue;
                return true;
            }
            return false;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static void getAllRegionBlocks(IContainer container, Set<IBlock> blocks) {
        if (container instanceof IBlock) {
            blocks.add((IBlock)container);
        } else if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer block : region.getSubBlocks()) {
                RegionUtils.getAllRegionBlocks(block, blocks);
            }
        } else {
            throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
        }
    }

    public static boolean isRegionContainsBlock(IContainer container, BlockNode block) {
        if (container instanceof IBlock) {
            return container == block;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer b : region.getSubBlocks()) {
                if (!RegionUtils.isRegionContainsBlock(b, block)) continue;
                return true;
            }
            return false;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static List<IContainer> getExcHandlersForRegion(IContainer region) {
        TryCatchBlockAttr tb = region.get(AType.TRY_BLOCK);
        if (tb != null) {
            ArrayList<IContainer> list = new ArrayList<IContainer>(tb.getHandlersCount());
            for (ExceptionHandler eh : tb.getHandlers()) {
                list.add(eh.getHandlerRegion());
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static boolean isRegionContainsExcHandlerRegion(IContainer container, IRegion region) {
        if (container == region) {
            return true;
        }
        if (container instanceof IRegion) {
            IRegion r = (IRegion)container;
            for (IContainer b : r.getSubBlocks()) {
                TryCatchBlockAttr tb = b.get(AType.TRY_BLOCK);
                if (tb != null && b instanceof IRegion) {
                    for (ExceptionHandler eh : tb.getHandlers()) {
                        if (!RegionUtils.isRegionContainsRegion(eh.getHandlerRegion(), region)) continue;
                        return true;
                    }
                }
                if (!RegionUtils.isRegionContainsRegion(b, region)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRegionContainsRegion(IContainer container, IRegion region) {
        if (container == region) {
            return true;
        }
        if (region == null) {
            return false;
        }
        IRegion parent = region.getParent();
        while (container != parent) {
            if (parent == null) {
                if (region.contains(AType.EXC_HANDLER)) {
                    return RegionUtils.isRegionContainsExcHandlerRegion(container, region);
                }
                return false;
            }
            region = parent;
            parent = region.getParent();
        }
        return true;
    }

    public static IContainer getBlockContainer(IContainer container, BlockNode block) {
        if (container instanceof IBlock) {
            return container == block ? container : null;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer c : region.getSubBlocks()) {
                IContainer res = RegionUtils.getBlockContainer(c, block);
                if (res == null) continue;
                return res instanceof IBlock ? region : res;
            }
            return null;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean isBlocksInSameRegion(MethodNode mth, BlockNode firstBlock, BlockNode secondBlock) {
        Region region = mth.getRegion();
        if (region == null) {
            return false;
        }
        IContainer firstContainer = RegionUtils.getBlockContainer(region, firstBlock);
        if (firstContainer instanceof IRegion) {
            if (firstContainer instanceof IBranchRegion) {
                return false;
            }
            List<IContainer> subBlocks = ((IRegion)firstContainer).getSubBlocks();
            return subBlocks.contains(secondBlock);
        }
        return false;
    }

    public static boolean isDominatedBy(BlockNode dom, IContainer cont) {
        if (dom == cont) {
            return true;
        }
        if (cont instanceof BlockNode) {
            BlockNode block = (BlockNode)cont;
            return block.isDominator(dom);
        }
        if (cont instanceof IBlock) {
            return false;
        }
        if (cont instanceof IRegion) {
            IRegion region = (IRegion)cont;
            for (IContainer c : region.getSubBlocks()) {
                if (RegionUtils.isDominatedBy(dom, c)) continue;
                return false;
            }
            return true;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(cont));
    }

    public static boolean hasPathThroughBlock(BlockNode block, IContainer cont) {
        if (block == cont) {
            return true;
        }
        if (cont instanceof BlockNode) {
            return BlockUtils.isPathExists(block, (BlockNode)cont);
        }
        if (cont instanceof IBlock) {
            return false;
        }
        if (cont instanceof IRegion) {
            IRegion region = (IRegion)cont;
            for (IContainer c : region.getSubBlocks()) {
                if (!RegionUtils.hasPathThroughBlock(block, c)) continue;
                return true;
            }
            return false;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(cont));
    }

    protected static String unknownContainerType(IContainer container) {
        if (container == null) {
            return "Null container variable";
        }
        return "Unknown container type: " + container.getClass();
    }
}

