/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TryCatchBlockAttr
implements IJadxAttribute {
    private final int id;
    private final List<ExceptionHandler> handlers;
    private List<BlockNode> blocks;
    private TryCatchBlockAttr outerTryBlock;
    private List<TryCatchBlockAttr> innerTryBlocks = Collections.emptyList();
    private boolean merged = false;
    private BlockNode topSplitter;

    public TryCatchBlockAttr(int id, List<ExceptionHandler> handlers, List<BlockNode> blocks) {
        this.id = id;
        this.handlers = handlers;
        this.blocks = blocks;
        handlers.forEach(h -> h.setTryBlock(this));
    }

    public boolean isAllHandler() {
        return this.handlers.size() == 1 && this.handlers.get(0).isCatchAll();
    }

    public boolean isThrowOnly() {
        boolean throwFound = false;
        block4: for (BlockNode block : this.blocks) {
            List<InsnNode> insns = block.getInstructions();
            if (insns.size() != 1) {
                return false;
            }
            InsnNode insn = insns.get(0);
            switch (insn.getType()) {
                case MOVE_EXCEPTION: 
                case MONITOR_EXIT: {
                    continue block4;
                }
                case THROW: {
                    throwFound = true;
                    continue block4;
                }
            }
            return false;
        }
        return throwFound;
    }

    public List<ExceptionHandler> getHandlers() {
        return this.handlers;
    }

    public int getHandlersCount() {
        return this.handlers.size();
    }

    public List<BlockNode> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<BlockNode> blocks) {
        this.blocks = blocks;
    }

    public void clear() {
        this.blocks.clear();
        this.handlers.forEach(ExceptionHandler::markForRemove);
        this.handlers.clear();
    }

    public void removeBlock(BlockNode block) {
        this.blocks.remove(block);
    }

    public void removeHandler(ExceptionHandler handler) {
        this.handlers.remove(handler);
        handler.markForRemove();
    }

    public List<TryCatchBlockAttr> getInnerTryBlocks() {
        return this.innerTryBlocks;
    }

    public void addInnerTryBlock(TryCatchBlockAttr inner) {
        if (this.innerTryBlocks.isEmpty()) {
            this.innerTryBlocks = new ArrayList<TryCatchBlockAttr>();
        }
        this.innerTryBlocks.add(inner);
    }

    public TryCatchBlockAttr getOuterTryBlock() {
        return this.outerTryBlock;
    }

    public void setOuterTryBlock(TryCatchBlockAttr outerTryBlock) {
        this.outerTryBlock = outerTryBlock;
    }

    public BlockNode getTopSplitter() {
        return this.topSplitter;
    }

    public void setTopSplitter(BlockNode topSplitter) {
        this.topSplitter = topSplitter;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public int id() {
        return this.id;
    }

    public IJadxAttrType<? extends IJadxAttribute> getAttrType() {
        return AType.TRY_BLOCK;
    }

    public int hashCode() {
        return this.handlers.hashCode() + 31 * this.blocks.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryCatchBlockAttr other = (TryCatchBlockAttr)obj;
        return this.id == other.id && this.handlers.equals(other.handlers) && this.blocks.equals(other.blocks);
    }

    public String toString() {
        if (this.merged) {
            return "Merged into " + this.outerTryBlock;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TryCatch #").append(this.id).append(" {").append(Utils.listToString(this.handlers));
        sb.append(", blocks: (").append(Utils.listToString(this.blocks)).append(')');
        if (this.topSplitter != null) {
            sb.append(", top: ").append(this.topSplitter);
        }
        if (this.outerTryBlock != null) {
            sb.append(", outer: #").append(this.outerTryBlock.id);
        }
        if (!this.innerTryBlocks.isEmpty()) {
            sb.append(", inners: ").append(Utils.listToString(this.innerTryBlocks, inner -> "#" + inner.id));
        }
        sb.append(" }");
        return sb.toString();
    }
}

